/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherSpgrRecord
extends EscherRecord {
    public static final short RECORD_ID = -4087;
    public static final String RECORD_DESCRIPTION = "MsofbtSpgr";
    private int field_1_rectX1;
    private int field_2_rectY1;
    private int field_3_rectX2;
    private int field_4_rectY2;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_rectX1 = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_rectY1 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_rectX2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_rectY2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        if ((n2 -= (n4 += 4)) != 0) {
            throw new RecordFormatException("Expected no remaining bytes but got " + n2);
        }
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = 16;
        LittleEndian.putInt(byArray, n + 4, n2);
        LittleEndian.putInt(byArray, n + 8, this.field_1_rectX1);
        LittleEndian.putInt(byArray, n + 12, this.field_2_rectY1);
        LittleEndian.putInt(byArray, n + 16, this.field_3_rectX2);
        LittleEndian.putInt(byArray, n + 20, this.field_4_rectY2);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), n + this.getRecordSize(), this);
        return 24;
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -4087;
    }

    public String getRecordName() {
        return "Spgr";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4087) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  RectX: " + this.field_1_rectX1 + string + "  RectY: " + this.field_2_rectY1 + string + "  RectWidth: " + this.field_3_rectX2 + string + "  RectHeight: " + this.field_4_rectY2 + string;
    }

    public int getRectX1() {
        return this.field_1_rectX1;
    }

    public void setRectX1(int n) {
        this.field_1_rectX1 = n;
    }

    public int getRectY1() {
        return this.field_2_rectY1;
    }

    public void setRectY1(int n) {
        this.field_2_rectY1 = n;
    }

    public int getRectX2() {
        return this.field_3_rectX2;
    }

    public void setRectX2(int n) {
        this.field_3_rectX2 = n;
    }

    public int getRectY2() {
        return this.field_4_rectY2;
    }

    public void setRectY2(int n) {
        this.field_4_rectY2 = n;
    }
}

