/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherSpRecord
extends EscherRecord {
    public static final short RECORD_ID = -4086;
    public static final String RECORD_DESCRIPTION = "MsofbtSp";
    public static final int FLAG_GROUP = 1;
    public static final int FLAG_CHILD = 2;
    public static final int FLAG_PATRIARCH = 4;
    public static final int FLAG_DELETED = 8;
    public static final int FLAG_OLESHAPE = 16;
    public static final int FLAG_HAVEMASTER = 32;
    public static final int FLAG_FLIPHORIZ = 64;
    public static final int FLAG_FLIPVERT = 128;
    public static final int FLAG_CONNECTOR = 256;
    public static final int FLAG_HAVEANCHOR = 512;
    public static final int FLAG_BACKGROUND = 1024;
    public static final int FLAG_HASSHAPETYPE = 2048;
    private int field_1_shapeId;
    private int field_2_flags;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_shapeId = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_flags = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        n4 += 4;
        return this.getRecordSize();
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = 8;
        LittleEndian.putInt(byArray, n + 4, n2);
        LittleEndian.putInt(byArray, n + 8, this.field_1_shapeId);
        LittleEndian.putInt(byArray, n + 12, this.field_2_flags);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return 16;
    }

    public int getRecordSize() {
        return 16;
    }

    public short getRecordId() {
        return -4086;
    }

    public String getRecordName() {
        return "Sp";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4086) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  ShapeId: " + this.field_1_shapeId + string + "  Flags: " + this.decodeFlags(this.field_2_flags) + " (0x" + HexDump.toHex(this.field_2_flags) + ")" + string;
    }

    private String decodeFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((n & 1) != 0 ? "|GROUP" : "");
        stringBuffer.append((n & 2) != 0 ? "|CHILD" : "");
        stringBuffer.append((n & 4) != 0 ? "|PATRIARCH" : "");
        stringBuffer.append((n & 8) != 0 ? "|DELETED" : "");
        stringBuffer.append((n & 0x10) != 0 ? "|OLESHAPE" : "");
        stringBuffer.append((n & 0x20) != 0 ? "|HAVEMASTER" : "");
        stringBuffer.append((n & 0x40) != 0 ? "|FLIPHORIZ" : "");
        stringBuffer.append((n & 0x80) != 0 ? "|FLIPVERT" : "");
        stringBuffer.append((n & 0x100) != 0 ? "|CONNECTOR" : "");
        stringBuffer.append((n & 0x200) != 0 ? "|HAVEANCHOR" : "");
        stringBuffer.append((n & 0x400) != 0 ? "|BACKGROUND" : "");
        stringBuffer.append((n & 0x800) != 0 ? "|HASSHAPETYPE" : "");
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public int getShapeId() {
        return this.field_1_shapeId;
    }

    public void setShapeId(int n) {
        this.field_1_shapeId = n;
    }

    public int getFlags() {
        return this.field_2_flags;
    }

    public void setFlags(int n) {
        this.field_2_flags = n;
    }
}

