/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.ddf.NullEscherSerializationListener;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public abstract class EscherRecord {
    private short options;
    private short recordId;

    protected int fillFields(byte[] byArray, EscherRecordFactory escherRecordFactory) {
        return this.fillFields(byArray, 0, escherRecordFactory);
    }

    public abstract int fillFields(byte[] var1, int var2, EscherRecordFactory var3);

    protected int readHeader(byte[] byArray, int n) {
        EscherRecordHeader escherRecordHeader = EscherRecordHeader.readHeader(byArray, n);
        this.options = escherRecordHeader.getOptions();
        this.recordId = escherRecordHeader.getRecordId();
        return escherRecordHeader.getRemainingBytes();
    }

    public boolean isContainerRecord() {
        return (this.options & 0xF) == 15;
    }

    public short getOptions() {
        return this.options;
    }

    public void setOptions(short s) {
        this.options = s;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[this.getRecordSize()];
        this.serialize(0, byArray);
        return byArray;
    }

    public int serialize(int n, byte[] byArray) {
        return this.serialize(n, byArray, new NullEscherSerializationListener());
    }

    public abstract int serialize(int var1, byte[] var2, EscherSerializationListener var3);

    public abstract int getRecordSize();

    public short getRecordId() {
        return this.recordId;
    }

    public void setRecordId(short s) {
        this.recordId = s;
    }

    public List getChildRecords() {
        return Collections.EMPTY_LIST;
    }

    public void setChildRecords(List list) {
        throw new IllegalArgumentException("This record does not support child records.");
    }

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public EscherRecord getChild(int n) {
        return (EscherRecord)this.getChildRecords().get(n);
    }

    public void display(PrintWriter printWriter, int n) {
        for (int i = 0; i < n * 4; ++i) {
            printWriter.print(' ');
        }
        printWriter.println(this.getRecordName());
    }

    public abstract String getRecordName();

    public short getInstance() {
        return (short)(this.options >> 4);
    }

    static class EscherRecordHeader {
        private short options;
        private short recordId;
        private int remainingBytes;

        private EscherRecordHeader() {
        }

        public static EscherRecordHeader readHeader(byte[] byArray, int n) {
            EscherRecordHeader escherRecordHeader = new EscherRecordHeader();
            escherRecordHeader.options = LittleEndian.getShort(byArray, n);
            escherRecordHeader.recordId = LittleEndian.getShort(byArray, n + 2);
            escherRecordHeader.remainingBytes = LittleEndian.getInt(byArray, n + 4);
            return escherRecordHeader;
        }

        public short getOptions() {
            return this.options;
        }

        public short getRecordId() {
            return this.recordId;
        }

        public int getRemainingBytes() {
            return this.remainingBytes;
        }

        public String toString() {
            return "EscherRecordHeader{options=" + this.options + ", recordId=" + this.recordId + ", remainingBytes=" + this.remainingBytes + "}";
        }
    }
}

