/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherArrayProperty;
import com.fr.third.org.apache.poi.ddf.EscherBoolProperty;
import com.fr.third.org.apache.poi.ddf.EscherComplexProperty;
import com.fr.third.org.apache.poi.ddf.EscherProperties;
import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.ddf.EscherRGBProperty;
import com.fr.third.org.apache.poi.ddf.EscherShapePathProperty;
import com.fr.third.org.apache.poi.ddf.EscherSimpleProperty;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EscherPropertyFactory {
    public List createProperties(byte[] byArray, int n, short n2) {
        ArrayList<EscherProperty> arrayList = new ArrayList<EscherProperty>();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            short s = LittleEndian.getShort(byArray, n3);
            int n4 = LittleEndian.getInt(byArray, n3 + 2);
            short s2 = (short)(s & 0x3FFF);
            boolean bl = (s & Short.MIN_VALUE) != 0;
            boolean bl2 = (s & 0x4000) != 0;
            byte by = EscherProperties.getPropertyType(s2);
            if (by == 1) {
                arrayList.add(new EscherBoolProperty(s, n4));
            } else if (by == 2) {
                arrayList.add(new EscherRGBProperty(s, n4));
            } else if (by == 3) {
                arrayList.add(new EscherShapePathProperty(s, n4));
            } else if (!bl) {
                arrayList.add(new EscherSimpleProperty(s, n4));
            } else if (by == 5) {
                arrayList.add(new EscherArrayProperty(s, new byte[n4]));
            } else {
                arrayList.add(new EscherComplexProperty(s, new byte[n4]));
            }
            n3 += 6;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            if (!(escherProperty instanceof EscherComplexProperty)) continue;
            if (escherProperty instanceof EscherArrayProperty) {
                n3 += ((EscherArrayProperty)escherProperty).setArrayData(byArray, n3);
                continue;
            }
            byte[] byArray2 = ((EscherComplexProperty)escherProperty).getComplexData();
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            n3 += byArray2.length;
        }
        return arrayList;
    }
}

