/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherBlipRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class EscherPictBlip
extends EscherBlipRecord {
    private static final POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$ddf$EscherPictBlip == null ? (class$com$fr$third$org$apache$poi$ddf$EscherPictBlip = EscherPictBlip.class$("com.fr.third.org.apache.poi.ddf.EscherPictBlip")) : class$com$fr$third$org$apache$poi$ddf$EscherPictBlip);
    public static final short RECORD_ID_EMF = -4070;
    public static final short RECORD_ID_WMF = -4069;
    public static final short RECORD_ID_PICT = -4068;
    private static final int HEADER_SIZE = 8;
    private byte[] field_1_UID;
    private int field_2_cb;
    private int field_3_rcBounds_x1;
    private int field_3_rcBounds_y1;
    private int field_3_rcBounds_x2;
    private int field_3_rcBounds_y2;
    private int field_4_ptSize_w;
    private int field_4_ptSize_h;
    private int field_5_cbSave;
    private byte field_6_fCompression;
    private byte field_7_fFilter;
    private byte[] raw_pictureData;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$ddf$EscherPictBlip;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.field_1_UID = new byte[16];
        System.arraycopy(byArray, n3, this.field_1_UID, 0, 16);
        this.field_2_cb = LittleEndian.getInt(byArray, n3 += 16);
        this.field_3_rcBounds_x1 = LittleEndian.getInt(byArray, n3 += 4);
        this.field_3_rcBounds_y1 = LittleEndian.getInt(byArray, n3 += 4);
        this.field_3_rcBounds_x2 = LittleEndian.getInt(byArray, n3 += 4);
        this.field_3_rcBounds_y2 = LittleEndian.getInt(byArray, n3 += 4);
        this.field_4_ptSize_w = LittleEndian.getInt(byArray, n3 += 4);
        this.field_4_ptSize_h = LittleEndian.getInt(byArray, n3 += 4);
        this.field_5_cbSave = LittleEndian.getInt(byArray, n3 += 4);
        this.field_6_fCompression = byArray[n3 += 4];
        this.field_7_fFilter = byArray[++n3];
        this.raw_pictureData = new byte[this.field_5_cbSave];
        System.arraycopy(byArray, ++n3, this.raw_pictureData, 0, this.field_5_cbSave);
        this.field_pictureData = this.field_6_fCompression == 0 ? EscherPictBlip.inflatePictureData(this.raw_pictureData) : this.raw_pictureData;
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        n2 += 2;
        LittleEndian.putInt(byArray, this.getRecordSize() - 8);
        System.arraycopy(this.field_1_UID, 0, byArray, n2 += 4, 16);
        LittleEndian.putInt(byArray, n2 += 16, this.field_2_cb);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_rcBounds_x1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_rcBounds_y1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_rcBounds_x2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_rcBounds_y2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_ptSize_w);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_ptSize_h);
        LittleEndian.putInt(byArray, n2 += 4, this.field_5_cbSave);
        byArray[n2 += 4] = this.field_6_fCompression;
        byArray[++n2] = this.field_7_fFilter;
        System.arraycopy(this.raw_pictureData, 0, byArray, ++n2, this.raw_pictureData.length);
        escherSerializationListener.afterRecordSerialize(n + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), this);
        return 25 + this.raw_pictureData.length;
    }

    private static byte[] inflatePictureData(byte[] byArray) {
        try {
            int n;
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = inflaterInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            log.log(3, (Object)"Possibly corrupt compression or non-compressed data", iOException);
            return byArray;
        }
    }

    public int getRecordSize() {
        return 58 + this.raw_pictureData.length;
    }

    public byte[] getUID() {
        return this.field_1_UID;
    }

    public void setUID(byte[] byArray) {
        this.field_1_UID = byArray;
    }

    public int getUncompressedSize() {
        return this.field_2_cb;
    }

    public void setUncompressedSize(int n) {
        this.field_2_cb = n;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.field_3_rcBounds_x1, this.field_3_rcBounds_y1, this.field_3_rcBounds_x2 - this.field_3_rcBounds_x1, this.field_3_rcBounds_y2 - this.field_3_rcBounds_y1);
    }

    public void setBounds(Rectangle rectangle) {
        this.field_3_rcBounds_x1 = rectangle.x;
        this.field_3_rcBounds_y1 = rectangle.y;
        this.field_3_rcBounds_x2 = rectangle.x + rectangle.width;
        this.field_3_rcBounds_y2 = rectangle.y + rectangle.height;
    }

    public Dimension getSizeEMU() {
        return new Dimension(this.field_4_ptSize_w, this.field_4_ptSize_h);
    }

    public void setSizeEMU(Dimension dimension) {
        this.field_4_ptSize_w = dimension.width;
        this.field_4_ptSize_h = dimension.height;
    }

    public int getCompressedSize() {
        return this.field_5_cbSave;
    }

    public void setCompressedSize(int n) {
        this.field_5_cbSave = n;
    }

    public boolean isCompressed() {
        return this.field_6_fCompression == 0;
    }

    public void setCompressed(boolean bl) {
        this.field_6_fCompression = (byte)(bl ? 0 : -2);
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_pictureData, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return this.getClass().getName() + ":" + string2 + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + string2 + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string2 + "  UID: 0x" + HexDump.toHex(this.field_1_UID) + string2 + "  Uncompressed Size: " + HexDump.toHex(this.field_2_cb) + string2 + "  Bounds: " + this.getBounds() + string2 + "  Size in EMU: " + this.getSizeEMU() + string2 + "  Compressed Size: " + HexDump.toHex(this.field_5_cbSave) + string2 + "  Compression: " + HexDump.toHex(this.field_6_fCompression) + string2 + "  Filter: " + HexDump.toHex(this.field_7_fFilter) + string2 + "  Extra Data:" + string2 + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

