/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.ddf.EscherPropertyFactory;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class EscherOptRecord
extends EscherRecord {
    public static final short RECORD_ID = -4085;
    public static final String RECORD_DESCRIPTION = "msofbtOPT";
    private List properties = new ArrayList();

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        EscherPropertyFactory escherPropertyFactory = new EscherPropertyFactory();
        this.properties = escherPropertyFactory.createProperties(byArray, n3, this.getInstance());
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        EscherProperty escherProperty;
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, this.getPropertiesSize());
        int n2 = n + 8;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            escherProperty = (EscherProperty)iterator.next();
            n2 += escherProperty.serializeSimplePart(byArray, n2);
        }
        iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            escherProperty = (EscherProperty)iterator.next();
            n2 += escherProperty.serializeComplexPart(byArray, n2);
        }
        escherSerializationListener.afterRecordSerialize(n2, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public short getOptions() {
        this.setOptions((short)(this.properties.size() << 4 | 3));
        return super.getOptions();
    }

    public String getRecordName() {
        return "Opt";
    }

    private int getPropertiesSize() {
        int n = 0;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            n += escherProperty.getPropertySize();
        }
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    " + iterator.next().toString() + string);
        }
        return "com.fr.third.org.apache.poi.ddf.EscherOptRecord:" + string + "  isContainer: " + this.isContainerRecord() + string + "  options: 0x" + HexDump.toHex(this.getOptions()) + string + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + string + "  numchildren: " + this.getChildRecords().size() + string + "  properties:" + string + stringBuffer.toString();
    }

    public List getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int n) {
        return (EscherProperty)this.properties.get(n);
    }

    public void addEscherProperty(EscherProperty escherProperty) {
        this.properties.add(escherProperty);
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator(){

            public int compare(Object object, Object object2) {
                EscherProperty escherProperty = (EscherProperty)object;
                EscherProperty escherProperty2 = (EscherProperty)object2;
                return new Short(escherProperty.getPropertyNumber()).compareTo(new Short(escherProperty2.getPropertyNumber()));
            }
        });
    }
}

