/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class EscherDggRecord
extends EscherRecord {
    public static final short RECORD_ID = -4090;
    public static final String RECORD_DESCRIPTION = "MsofbtDgg";
    private int field_1_shapeIdMax;
    private int field_3_numShapesSaved;
    private int field_4_drawingsSaved;
    private FileIdCluster[] field_5_fileIdClusters;
    private int maxDgId;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_shapeIdMax = LittleEndian.getInt(byArray, n3 + n4);
        int n5 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_numShapesSaved = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_drawingsSaved = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_5_fileIdClusters = new FileIdCluster[(n2 - (n4 += 4)) / 8];
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            this.field_5_fileIdClusters[i] = new FileIdCluster(LittleEndian.getInt(byArray, n3 + n4), LittleEndian.getInt(byArray, n3 + n4 + 4));
            this.maxDgId = Math.max(this.maxDgId, this.field_5_fileIdClusters[i].getDrawingGroupId());
            n4 += 8;
        }
        if ((n2 -= n4) != 0) {
            throw new RecordFormatException("Expecting no remaining data but got " + n2 + " byte(s).");
        }
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        int n3 = this.getRecordSize() - 8;
        LittleEndian.putInt(byArray, n2 += 2, n3);
        LittleEndian.putInt(byArray, n2 += 4, this.field_1_shapeIdMax);
        LittleEndian.putInt(byArray, n2 += 4, this.getNumIdClusters());
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_numShapesSaved);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_drawingsSaved);
        n2 += 4;
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            LittleEndian.putInt(byArray, n2, this.field_5_fileIdClusters[i].field_1_drawingGroupId);
            LittleEndian.putInt(byArray, n2 += 4, this.field_5_fileIdClusters[i].field_2_numShapeIdsUsed);
            n2 += 4;
        }
        escherSerializationListener.afterRecordSerialize(n2, this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24 + 8 * this.field_5_fileIdClusters.length;
    }

    public short getRecordId() {
        return -4090;
    }

    public String getRecordName() {
        return "Dgg";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.field_5_fileIdClusters.length; ++i) {
            stringBuffer.append("  DrawingGroupId").append(i + 1).append(": ");
            stringBuffer.append(this.field_5_fileIdClusters[i].field_1_drawingGroupId);
            stringBuffer.append(string);
            stringBuffer.append("  NumShapeIdsUsed").append(i + 1).append(": ");
            stringBuffer.append(this.field_5_fileIdClusters[i].field_2_numShapeIdsUsed);
            stringBuffer.append(string);
        }
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4090) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  ShapeIdMax: " + this.field_1_shapeIdMax + string + "  NumIdClusters: " + this.getNumIdClusters() + string + "  NumShapesSaved: " + this.field_3_numShapesSaved + string + "  DrawingsSaved: " + this.field_4_drawingsSaved + string + "" + stringBuffer.toString();
    }

    public int getShapeIdMax() {
        return this.field_1_shapeIdMax;
    }

    public void setShapeIdMax(int n) {
        this.field_1_shapeIdMax = n;
    }

    public int getNumIdClusters() {
        return this.field_5_fileIdClusters.length + 1;
    }

    public int getNumShapesSaved() {
        return this.field_3_numShapesSaved;
    }

    public void setNumShapesSaved(int n) {
        this.field_3_numShapesSaved = n;
    }

    public int getDrawingsSaved() {
        return this.field_4_drawingsSaved;
    }

    public void setDrawingsSaved(int n) {
        this.field_4_drawingsSaved = n;
    }

    public int getMaxDrawingGroupId() {
        return this.maxDgId;
    }

    public void setMaxDrawingGroupId(int n) {
        this.maxDgId = n;
    }

    public FileIdCluster[] getFileIdClusters() {
        return this.field_5_fileIdClusters;
    }

    public void setFileIdClusters(FileIdCluster[] fileIdClusterArray) {
        this.field_5_fileIdClusters = fileIdClusterArray;
    }

    public void addCluster(int n, int n2) {
        this.addCluster(n, n2, true);
    }

    public void addCluster(int n, int n2, boolean bl) {
        ArrayList<FileIdCluster> arrayList = new ArrayList<FileIdCluster>(Arrays.asList(this.field_5_fileIdClusters));
        arrayList.add(new FileIdCluster(n, n2));
        if (bl) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileIdCluster fileIdCluster = (FileIdCluster)object;
                    FileIdCluster fileIdCluster2 = (FileIdCluster)object2;
                    if (fileIdCluster.getDrawingGroupId() == fileIdCluster2.getDrawingGroupId()) {
                        return 0;
                    }
                    if (fileIdCluster.getDrawingGroupId() < fileIdCluster2.getDrawingGroupId()) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        this.maxDgId = Math.min(this.maxDgId, n);
        this.field_5_fileIdClusters = arrayList.toArray(new FileIdCluster[arrayList.size()]);
    }

    public static class FileIdCluster {
        private int field_1_drawingGroupId;
        private int field_2_numShapeIdsUsed;

        public FileIdCluster(int n, int n2) {
            this.field_1_drawingGroupId = n;
            this.field_2_numShapeIdsUsed = n2;
        }

        public int getDrawingGroupId() {
            return this.field_1_drawingGroupId;
        }

        public int getNumShapeIdsUsed() {
            return this.field_2_numShapeIdsUsed;
        }

        public void incrementShapeId() {
            ++this.field_2_numShapeIdsUsed;
        }
    }
}

