/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherDgRecord
extends EscherRecord {
    public static final short RECORD_ID = -4088;
    public static final String RECORD_DESCRIPTION = "MsofbtDg";
    private int field_1_numShapes;
    private int field_2_lastMSOSPID;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_numShapes = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_lastMSOSPID = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        n4 += 4;
        return this.getRecordSize();
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, 8);
        LittleEndian.putInt(byArray, n + 8, this.field_1_numShapes);
        LittleEndian.putInt(byArray, n + 12, this.field_2_lastMSOSPID);
        escherSerializationListener.afterRecordSerialize(n + 16, this.getRecordId(), this.getRecordSize(), this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public short getRecordId() {
        return -4088;
    }

    public String getRecordName() {
        return "Dg";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4088) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  NumShapes: " + this.field_1_numShapes + string + "  LastMSOSPID: " + this.field_2_lastMSOSPID + string;
    }

    public int getNumShapes() {
        return this.field_1_numShapes;
    }

    public void setNumShapes(int n) {
        this.field_1_numShapes = n;
    }

    public int getLastMSOSPID() {
        return this.field_2_lastMSOSPID;
    }

    public void setLastMSOSPID(int n) {
        this.field_2_lastMSOSPID = n;
    }

    public short getDrawingGroupId() {
        return (short)(this.getOptions() >> 4);
    }

    public void incrementShapeCount() {
        ++this.field_1_numShapes;
    }
}

