/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.ddf.EscherSpRecord;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private List childRecords = new ArrayList();

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = 8;
        n += 8;
        while (n2 > 0 && n < byArray.length) {
            EscherRecord escherRecord = escherRecordFactory.createRecord(byArray, n);
            int n4 = escherRecord.fillFields(byArray, n, escherRecordFactory);
            n3 += n4;
            this.getChildRecords().add(escherRecord);
            if ((n += n4) < byArray.length || (n2 -= n4) <= 0) continue;
            System.out.println("WARNING: " + n2 + " bytes remaining but no space left");
        }
        return n3;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        Object object;
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = 0;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            object = (EscherRecord)iterator.next();
            n2 += ((EscherRecord)object).getRecordSize();
        }
        LittleEndian.putInt(byArray, n + 4, n2);
        int n3 = n + 8;
        object = this.getChildRecords().iterator();
        while (object.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)object.next();
            n3 += escherRecord.serialize(n3, byArray, escherSerializationListener);
        }
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public int getRecordSize() {
        int n = 0;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            n += escherRecord.getRecordSize();
        }
        return 8 + n;
    }

    public boolean hasChildOfType(short s) {
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != s) continue;
            return true;
        }
        return false;
    }

    public List getChildRecords() {
        return this.childRecords;
    }

    public List getChildContainers() {
        ArrayList<EscherRecord> arrayList = new ArrayList<EscherRecord>();
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (!(escherRecord instanceof EscherContainerRecord)) continue;
            arrayList.add(escherRecord);
        }
        return arrayList;
    }

    public void setChildRecords(List list) {
        this.childRecords = list;
    }

    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    public void display(PrintWriter printWriter, int n) {
        super.display(printWriter, n);
        Iterator iterator = this.childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            escherRecord.display(printWriter, n + 1);
        }
    }

    public void addChildRecord(EscherRecord escherRecord) {
        this.childRecords.add(escherRecord);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            stringBuffer.append("  children: " + string2);
            int n = 0;
            Iterator iterator = this.getChildRecords().iterator();
            while (iterator.hasNext()) {
                String string3 = string + "   ";
                EscherRecord escherRecord = (EscherRecord)iterator.next();
                stringBuffer.append(string3 + "Child " + n + ":" + string2);
                if (escherRecord instanceof EscherContainerRecord) {
                    EscherContainerRecord escherContainerRecord = (EscherContainerRecord)escherRecord;
                    stringBuffer.append(escherContainerRecord.toString(string3));
                } else {
                    stringBuffer.append(escherRecord.toString());
                }
                ++n;
            }
        }
        return string + this.getClass().getName() + " (" + this.getRecordName() + "):" + string2 + string + "  isContainer: " + this.isContainerRecord() + string2 + string + "  options: 0x" + HexDump.toHex(this.getOptions()) + string2 + string + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + string2 + string + "  numchildren: " + this.getChildRecords().size() + string2 + string + stringBuffer.toString();
    }

    public EscherSpRecord getChildById(short s) {
        Iterator iterator = this.childRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != s) continue;
            return (EscherSpRecord)escherRecord;
        }
        return null;
    }
}

