/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherProperties;
import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class EscherComplexProperty
extends EscherProperty {
    byte[] complexData = new byte[0];

    public EscherComplexProperty(short s, byte[] byArray) {
        super(s);
        this.complexData = byArray;
    }

    public EscherComplexProperty(short s, boolean bl, byte[] byArray) {
        super(s, true, bl);
        this.complexData = byArray;
    }

    public int serializeSimplePart(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this.getId());
        LittleEndian.putInt(byArray, n + 2, this.complexData.length);
        return 6;
    }

    public int serializeComplexPart(byte[] byArray, int n) {
        System.arraycopy(this.complexData, 0, byArray, n, this.complexData.length);
        return this.complexData.length;
    }

    public byte[] getComplexData() {
        return this.complexData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EscherComplexProperty)) {
            return false;
        }
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)object;
        return Arrays.equals(this.complexData, escherComplexProperty.complexData);
    }

    public int getPropertySize() {
        return 6 + this.complexData.length;
    }

    public int hashCode() {
        return this.getId() * 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.complexData, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + System.getProperty("line.separator") + string;
    }
}

