/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;

public class EscherClientDataRecord
extends EscherRecord {
    public static final short RECORD_ID = -4079;
    public static final String RECORD_DESCRIPTION = "MsofbtClientData";
    private byte[] remainingData;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.remainingData = new byte[n2];
        System.arraycopy(byArray, n3, this.remainingData, 0, n2);
        return 8 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        if (this.remainingData == null) {
            this.remainingData = new byte[0];
        }
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        LittleEndian.putInt(byArray, n + 4, this.remainingData.length);
        System.arraycopy(this.remainingData, 0, byArray, n + 8, this.remainingData.length);
        int n2 = n + 8 + this.remainingData.length;
        escherSerializationListener.afterRecordSerialize(n2, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public int getRecordSize() {
        return 8 + (this.remainingData == null ? 0 : this.remainingData.length);
    }

    public short getRecordId() {
        return -4079;
    }

    public String getRecordName() {
        return "ClientData";
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.remainingData, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = "error\n";
        }
        return this.getClass().getName() + ":" + string2 + "  RecordId: 0x" + HexDump.toHex((short)-4079) + string2 + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string2 + "  Extra Data:" + string2 + string;
    }

    public byte[] getRemainingData() {
        return this.remainingData;
    }

    public void setRemainingData(byte[] byArray) {
        this.remainingData = byArray;
    }
}

