/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherChildAnchorRecord
extends EscherRecord {
    public static final short RECORD_ID = -4081;
    public static final String RECORD_DESCRIPTION = "MsofbtChildAnchor";
    private int field_1_dx1;
    private int field_2_dy1;
    private int field_3_dx2;
    private int field_4_dy2;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_dx1 = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_dy1 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_dx2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_dy2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        return 8 + (n4 += 4);
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        LittleEndian.putInt(byArray, n2 += 2, this.getRecordSize() - 8);
        LittleEndian.putInt(byArray, n2 += 4, this.field_1_dx1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_2_dy1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_dx2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_dy2);
        escherSerializationListener.afterRecordSerialize(n2 += 4, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -4081;
    }

    public String getRecordName() {
        return "ChildAnchor";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4081) + string + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string + "  X1: " + this.field_1_dx1 + string + "  Y1: " + this.field_2_dy1 + string + "  X2: " + this.field_3_dx2 + string + "  Y2: " + this.field_4_dy2 + string;
    }

    public int getDx1() {
        return this.field_1_dx1;
    }

    public void setDx1(int n) {
        this.field_1_dx1 = n;
    }

    public int getDy1() {
        return this.field_2_dy1;
    }

    public void setDy1(int n) {
        this.field_2_dy1 = n;
    }

    public int getDx2() {
        return this.field_3_dx2;
    }

    public void setDx2(int n) {
        this.field_3_dx2 = n;
    }

    public int getDy2() {
        return this.field_4_dy2;
    }

    public void setDy2(int n) {
        this.field_4_dy2 = n;
    }
}

