/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherBlipRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class EscherBlipWMFRecord
extends EscherBlipRecord {
    public static final String RECORD_DESCRIPTION = "msofbtBlip";
    private static final int HEADER_SIZE = 8;
    private byte[] field_1_secondaryUID;
    private int field_2_cacheOfSize;
    private int field_3_boundaryTop;
    private int field_4_boundaryLeft;
    private int field_5_boundaryWidth;
    private int field_6_boundaryHeight;
    private int field_7_width;
    private int field_8_height;
    private int field_9_cacheOfSavedSize;
    private byte field_10_compressionFlag;
    private byte field_11_filter;
    private byte[] field_12_data;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_secondaryUID = new byte[16];
        System.arraycopy(byArray, n3 + n4, this.field_1_secondaryUID, 0, 16);
        this.field_2_cacheOfSize = LittleEndian.getInt(byArray, n3 + (n4 += 16));
        this.field_3_boundaryTop = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_boundaryLeft = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_5_boundaryWidth = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_6_boundaryHeight = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_7_width = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_8_height = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_9_cacheOfSavedSize = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_10_compressionFlag = byArray[n3 + (n4 += 4)];
        this.field_11_filter = byArray[n3 + ++n4];
        int n5 = n2 - ++n4;
        this.field_12_data = new byte[n5];
        System.arraycopy(byArray, n3 + n4, this.field_12_data, 0, n5);
        return 8 + (n4 += n5);
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = this.field_12_data.length + 36;
        LittleEndian.putInt(byArray, n + 4, n2);
        int n3 = n + 8;
        System.arraycopy(this.field_1_secondaryUID, 0, byArray, n3, 16);
        LittleEndian.putInt(byArray, n3 += 16, this.field_2_cacheOfSize);
        LittleEndian.putInt(byArray, n3 += 4, this.field_3_boundaryTop);
        LittleEndian.putInt(byArray, n3 += 4, this.field_4_boundaryLeft);
        LittleEndian.putInt(byArray, n3 += 4, this.field_5_boundaryWidth);
        LittleEndian.putInt(byArray, n3 += 4, this.field_6_boundaryHeight);
        LittleEndian.putInt(byArray, n3 += 4, this.field_7_width);
        LittleEndian.putInt(byArray, n3 += 4, this.field_8_height);
        LittleEndian.putInt(byArray, n3 += 4, this.field_9_cacheOfSavedSize);
        n3 += 4;
        byArray[n3++] = this.field_10_compressionFlag;
        byArray[n3++] = this.field_11_filter;
        System.arraycopy(this.field_12_data, 0, byArray, n3, this.field_12_data.length);
        escherSerializationListener.afterRecordSerialize(n3 += this.field_12_data.length, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    public int getRecordSize() {
        return 58 + this.field_12_data.length;
    }

    public String getRecordName() {
        return "Blip";
    }

    public byte[] getSecondaryUID() {
        return this.field_1_secondaryUID;
    }

    public void setSecondaryUID(byte[] byArray) {
        this.field_1_secondaryUID = byArray;
    }

    public int getCacheOfSize() {
        return this.field_2_cacheOfSize;
    }

    public void setCacheOfSize(int n) {
        this.field_2_cacheOfSize = n;
    }

    public int getBoundaryTop() {
        return this.field_3_boundaryTop;
    }

    public void setBoundaryTop(int n) {
        this.field_3_boundaryTop = n;
    }

    public int getBoundaryLeft() {
        return this.field_4_boundaryLeft;
    }

    public void setBoundaryLeft(int n) {
        this.field_4_boundaryLeft = n;
    }

    public int getBoundaryWidth() {
        return this.field_5_boundaryWidth;
    }

    public void setBoundaryWidth(int n) {
        this.field_5_boundaryWidth = n;
    }

    public int getBoundaryHeight() {
        return this.field_6_boundaryHeight;
    }

    public void setBoundaryHeight(int n) {
        this.field_6_boundaryHeight = n;
    }

    public int getWidth() {
        return this.field_7_width;
    }

    public void setWidth(int n) {
        this.field_7_width = n;
    }

    public int getHeight() {
        return this.field_8_height;
    }

    public void setHeight(int n) {
        this.field_8_height = n;
    }

    public int getCacheOfSavedSize() {
        return this.field_9_cacheOfSavedSize;
    }

    public void setCacheOfSavedSize(int n) {
        this.field_9_cacheOfSavedSize = n;
    }

    public byte getCompressionFlag() {
        return this.field_10_compressionFlag;
    }

    public void setCompressionFlag(byte by) {
        this.field_10_compressionFlag = by;
    }

    public byte getFilter() {
        return this.field_11_filter;
    }

    public void setFilter(byte by) {
        this.field_11_filter = by;
    }

    public byte[] getData() {
        return this.field_12_data;
    }

    public void setData(byte[] byArray) {
        this.field_12_data = byArray;
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_12_data, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return this.getClass().getName() + ":" + string2 + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + string2 + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string2 + "  Secondary UID: " + HexDump.toHex(this.field_1_secondaryUID) + string2 + "  CacheOfSize: " + this.field_2_cacheOfSize + string2 + "  BoundaryTop: " + this.field_3_boundaryTop + string2 + "  BoundaryLeft: " + this.field_4_boundaryLeft + string2 + "  BoundaryWidth: " + this.field_5_boundaryWidth + string2 + "  BoundaryHeight: " + this.field_6_boundaryHeight + string2 + "  X: " + this.field_7_width + string2 + "  Y: " + this.field_8_height + string2 + "  CacheOfSavedSize: " + this.field_9_cacheOfSavedSize + string2 + "  CompressionFlag: " + this.field_10_compressionFlag + string2 + "  Filter: " + this.field_11_filter + string2 + "  Data:" + string2 + string;
    }

    public static byte[] compress(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        try {
            for (int i = 0; i < byArray.length; ++i) {
                deflaterOutputStream.write(byArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new RecordFormatException(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decompress(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n + 50, byArray2, 0, n2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            while ((n3 = inflaterInputStream.read()) != -1) {
                byteArrayOutputStream.write(n3);
            }
        }
        catch (IOException iOException) {
            throw new RecordFormatException(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

