/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherRecordFactory;
import com.fr.third.org.apache.poi.ddf.EscherSerializationListener;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;

public class EscherBlipRecord
extends EscherRecord {
    public static final short RECORD_ID_START = -4072;
    public static final short RECORD_ID_END = -3817;
    public static final String RECORD_DESCRIPTION = "msofbtBlip";
    private static final int HEADER_SIZE = 8;
    protected byte[] field_pictureData;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.field_pictureData = new byte[n2];
        System.arraycopy(byArray, n3, this.field_pictureData, 0, n2);
        return n2 + 8;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        System.arraycopy(this.field_pictureData, 0, byArray, n + 4, this.field_pictureData.length);
        escherSerializationListener.afterRecordSerialize(n + 4 + this.field_pictureData.length, this.getRecordId(), this.field_pictureData.length + 4, this);
        return this.field_pictureData.length + 4;
    }

    public int getRecordSize() {
        return this.field_pictureData.length + 8;
    }

    public String getRecordName() {
        return "Blip";
    }

    public byte[] getPicturedata() {
        return this.field_pictureData;
    }

    public void setPictureData(byte[] byArray) {
        this.field_pictureData = byArray;
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_pictureData, 0L, byteArrayOutputStream, 0);
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return this.getClass().getName() + ":" + string2 + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + string2 + "  Options: 0x" + HexDump.toHex(this.getOptions()) + string2 + "  Extra Data:" + string2 + string;
    }
}

