/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.ddf;

import com.fr.third.org.apache.poi.ddf.EscherComplexProperty;
import com.fr.third.org.apache.poi.ddf.EscherProperties;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class EscherArrayProperty
extends EscherComplexProperty {
    private static final int FIXED_SIZE = 6;
    private boolean sizeIncludesHeaderSize = true;
    private boolean emptyComplexPart = false;

    public EscherArrayProperty(short s, byte[] byArray) {
        super(s, EscherArrayProperty.checkComplexData(byArray));
        this.emptyComplexPart = byArray.length == 0;
    }

    public EscherArrayProperty(short s, boolean bl, byte[] byArray) {
        super(s, bl, EscherArrayProperty.checkComplexData(byArray));
    }

    private static byte[] checkComplexData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[6];
        }
        return byArray;
    }

    public int getNumberOfElementsInArray() {
        return LittleEndian.getUShort(this.complexData, 0);
    }

    public void setNumberOfElementsInArray(int n) {
        int n2 = n * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this.complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.complexData, 0, byArray, 0, this.complexData.length);
            this.complexData = byArray;
        }
        LittleEndian.putShort(this.complexData, 0, (short)n);
    }

    public int getNumberOfElementsInMemory() {
        return LittleEndian.getUShort(this.complexData, 2);
    }

    public void setNumberOfElementsInMemory(int n) {
        int n2 = n * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this.complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.complexData, 0, byArray, 0, n2);
            this.complexData = byArray;
        }
        LittleEndian.putShort(this.complexData, 2, (short)n);
    }

    public short getSizeOfElements() {
        return LittleEndian.getShort(this.complexData, 4);
    }

    public void setSizeOfElements(int n) {
        LittleEndian.putShort(this.complexData, 4, (short)n);
        int n2 = this.getNumberOfElementsInArray() * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (n2 != this.complexData.length) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.complexData, 0, byArray, 0, 6);
            this.complexData = byArray;
        }
    }

    public byte[] getElement(int n) {
        int n2 = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        byte[] byArray = new byte[n2];
        System.arraycopy(this.complexData, 6 + n * n2, byArray, 0, byArray.length);
        return byArray;
    }

    public void setElement(int n, byte[] byArray) {
        int n2 = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        System.arraycopy(byArray, 0, this.complexData, 6 + n * n2, n2);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    {EscherArrayProperty:" + string);
        stringBuffer.append("     Num Elements: " + this.getNumberOfElementsInArray() + string);
        stringBuffer.append("     Num Elements In Memory: " + this.getNumberOfElementsInMemory() + string);
        stringBuffer.append("     Size of elements: " + this.getSizeOfElements() + string);
        for (int i = 0; i < this.getNumberOfElementsInArray(); ++i) {
            stringBuffer.append("     Element " + i + ": " + HexDump.toHex(this.getElement(i)) + string);
        }
        stringBuffer.append("}" + string);
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + string + stringBuffer.toString();
    }

    public int setArrayData(byte[] byArray, int n) {
        if (this.emptyComplexPart) {
            this.complexData = new byte[0];
        } else {
            short s = LittleEndian.getShort(byArray, n);
            short s2 = LittleEndian.getShort(byArray, n + 2);
            short s3 = LittleEndian.getShort(byArray, n + 4);
            int n2 = EscherArrayProperty.getActualSizeOfElements(s3) * s;
            if (n2 == this.complexData.length) {
                this.complexData = new byte[n2 + 6];
                this.sizeIncludesHeaderSize = false;
            }
            System.arraycopy(byArray, n, this.complexData, 0, this.complexData.length);
        }
        return this.complexData.length;
    }

    public int serializeSimplePart(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this.getId());
        int n2 = this.complexData.length;
        if (!this.sizeIncludesHeaderSize) {
            n2 -= 6;
        }
        LittleEndian.putInt(byArray, n + 2, n2);
        return 6;
    }

    public static int getActualSizeOfElements(short s) {
        if (s < 0) {
            return (short)(-s >> 2);
        }
        return s;
    }
}

