/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi;

import com.fr.third.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.org.apache.poi.hpsf.HPSFException;
import com.fr.third.org.apache.poi.hpsf.MutablePropertySet;
import com.fr.third.org.apache.poi.hpsf.PropertySet;
import com.fr.third.org.apache.poi.hpsf.PropertySetFactory;
import com.fr.third.org.apache.poi.hpsf.SummaryInformation;
import com.fr.third.org.apache.poi.hpsf.WritingNotSupportedException;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentEntry;
import com.fr.third.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.org.apache.poi.poifs.filesystem.Entry;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public abstract class POIDocument {
    protected SummaryInformation sInf;
    protected DocumentSummaryInformation dsInf;
    protected POIFSFileSystem filesystem;
    protected DirectoryNode directory;
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    protected boolean initialized = false;

    protected POIDocument(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) {
        this.filesystem = pOIFSFileSystem;
        this.directory = directoryNode;
    }

    protected POIDocument(POIFSFileSystem pOIFSFileSystem) {
        this(pOIFSFileSystem.getRoot(), pOIFSFileSystem);
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    protected void readProperties() {
        PropertySet propertySet = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (propertySet != null && propertySet instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)propertySet;
        } else if (propertySet != null) {
            this.logger.log(5, (Object)"DocumentSummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        propertySet = this.getPropertySet("\u0005SummaryInformation");
        if (propertySet instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)propertySet;
        } else if (propertySet != null) {
            this.logger.log(5, (Object)"SummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String string) {
        DocumentInputStream documentInputStream;
        try {
            documentInputStream = this.directory.createDocumentInputStream(string);
        }
        catch (IOException iOException) {
            this.logger.log(5, "Error getting property set with name " + string + "\n" + iOException);
            return null;
        }
        try {
            PropertySet propertySet = PropertySetFactory.create(documentInputStream);
            return propertySet;
        }
        catch (IOException iOException) {
            this.logger.log(5, "Error creating property set with name " + string + "\n" + iOException);
        }
        catch (HPSFException hPSFException) {
            this.logger.log(5, "Error creating property set with name " + string + "\n" + hPSFException);
        }
        return null;
    }

    protected void writeProperties(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this.writeProperties(pOIFSFileSystem, null);
    }

    protected void writeProperties(POIFSFileSystem pOIFSFileSystem, List list) throws IOException {
        if (this.sInf != null) {
            this.writePropertySet("\u0005SummaryInformation", this.sInf, pOIFSFileSystem);
            if (list != null) {
                list.add("\u0005SummaryInformation");
            }
        }
        if (this.dsInf != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", this.dsInf, pOIFSFileSystem);
            if (list != null) {
                list.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String string, PropertySet propertySet, POIFSFileSystem pOIFSFileSystem) throws IOException {
        try {
            MutablePropertySet mutablePropertySet = new MutablePropertySet(propertySet);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mutablePropertySet.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            pOIFSFileSystem.createDocument(byteArrayInputStream, string);
            this.logger.log(3, "Wrote property set " + string + " of size " + byArray.length);
        }
        catch (WritingNotSupportedException writingNotSupportedException) {
            System.err.println("Couldn't write property set with name " + string + " as not supported by HPSF yet");
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    protected void copyNodes(POIFSFileSystem pOIFSFileSystem, POIFSFileSystem pOIFSFileSystem2, List list) throws IOException {
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        DirectoryNode directoryNode2 = pOIFSFileSystem2.getRoot();
        Iterator iterator = directoryNode.getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (this.isInList(entry.getName(), list)) continue;
            this.copyNodeRecursively(entry, directoryNode2);
        }
    }

    private boolean isInList(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    private void copyNodeRecursively(Entry entry, DirectoryEntry directoryEntry) throws IOException {
        DirectoryEntry directoryEntry2 = null;
        if (entry.isDirectoryEntry()) {
            directoryEntry2 = directoryEntry.createDirectory(entry.getName());
            Iterator iterator = ((DirectoryEntry)entry).getEntries();
            while (iterator.hasNext()) {
                this.copyNodeRecursively((Entry)iterator.next(), directoryEntry2);
            }
        } else {
            DocumentEntry documentEntry = (DocumentEntry)entry;
            DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);
            directoryEntry.createDocument(documentEntry.getName(), documentInputStream);
            documentInputStream.close();
        }
    }
}

