/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.graphic.RtfImage;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.fr.third.com.lowagie.text.rtf.text.RtfPhrase;
import java.io.IOException;
import java.io.OutputStream;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = DocWriter.getISOBytes("\\par");
    protected RtfParagraphStyle paragraphStyle = null;

    public RtfParagraph(RtfDocument rtfDocument, Paragraph paragraph) {
        super(rtfDocument);
        RtfFont rtfFont = null;
        if (paragraph.getFont() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)paragraph.getFont()).getStyleName());
            rtfFont = this.paragraphStyle;
        } else {
            rtfFont = new RtfFont(this.document, paragraph.getFont());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
            this.paragraphStyle.setAlignment(paragraph.getAlignment());
            this.paragraphStyle.setFirstLineIndent((int)((double)paragraph.getFirstLineIndent() * 20.0));
            this.paragraphStyle.setIndentLeft((int)((double)paragraph.getIndentationLeft() * 20.0));
            this.paragraphStyle.setIndentRight((int)((double)paragraph.getIndentationRight() * 20.0));
            this.paragraphStyle.setSpacingBefore((int)((double)paragraph.getSpacingBefore() * 20.0));
            this.paragraphStyle.setSpacingAfter((int)((double)paragraph.getSpacingAfter() * 20.0));
            if (paragraph.hasLeading()) {
                this.paragraphStyle.setLineLeading((int)((double)paragraph.getLeading() * 20.0));
            }
            this.paragraphStyle.setKeepTogether(paragraph.getKeepTogether());
        }
        for (int i = 0; i < paragraph.size(); ++i) {
            Element element = (Element)paragraph.get(i);
            if (element instanceof Chunk) {
                ((Chunk)element).setFont(rtfFont.difference(((Chunk)element).getFont()));
            } else if (element instanceof RtfImage) {
                ((RtfImage)this.chunks.get(i)).setAlignment(this.paragraphStyle.getAlignment());
            }
            try {
                RtfBasicElement[] rtfBasicElementArray = rtfDocument.getMapper().mapElement(element);
                for (int j = 0; j < rtfBasicElementArray.length; ++j) {
                    this.chunks.add(rtfBasicElementArray[j]);
                }
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    public void setKeepTogetherWithNext(boolean bl) {
        this.paragraphStyle.setKeepTogetherWithNext(bl);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(PARAGRAPH_DEFAULTS);
        outputStream.write(PLAIN);
        if (this.inTable) {
            outputStream.write(IN_TABLE);
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeBegin(outputStream);
        }
        outputStream.write(DocWriter.getISOBytes("\\plain"));
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)this.chunks.get(i);
            rtfBasicElement.writeContent(outputStream);
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeEnd(outputStream);
        }
        if (!this.inTable) {
            outputStream.write(PARAGRAPH);
        }
        this.document.outputDebugLinebreak(outputStream);
    }

    public int getIndentLeft() {
        return this.paragraphStyle.getIndentLeft();
    }

    public void setIndentLeft(int n) {
        this.paragraphStyle.setIndentLeft(n);
    }

    public int getIndentRight() {
        return this.paragraphStyle.getIndentRight();
    }

    public void setIndentRight(int n) {
        this.paragraphStyle.setIndentRight(n);
    }
}

