/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfColor;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfChunk
extends RtfElement {
    private static final byte[] FONT_SUBSCRIPT = DocWriter.getISOBytes("\\sub");
    private static final byte[] FONT_SUPERSCRIPT = DocWriter.getISOBytes("\\super");
    private static final byte[] FONT_END_SUPER_SUBSCRIPT = DocWriter.getISOBytes("\\nosupersub");
    private static final byte[] BACKGROUND_COLOR = DocWriter.getISOBytes("\\chcbpat");
    private RtfFont font = null;
    private String content = "";
    private boolean softLineBreaks = false;
    private float superSubScript = 0.0f;
    private RtfColor background = null;

    public RtfChunk(RtfDocument rtfDocument, Chunk chunk) {
        super(rtfDocument);
        if (chunk == null) {
            return;
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            this.superSubScript = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("BACKGROUND") != null) {
            this.background = new RtfColor(this.document, (Color)((Object[])chunk.getAttributes().get("BACKGROUND"))[0]);
        }
        this.font = new RtfFont(rtfDocument, chunk.getFont());
        this.content = chunk.getContent();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.background != null) {
            outputStream.write(RtfBasicElement.OPEN_GROUP);
        }
        this.font.writeBegin(outputStream);
        if (this.superSubScript < 0.0f) {
            outputStream.write(FONT_SUBSCRIPT);
        } else if (this.superSubScript > 0.0f) {
            outputStream.write(FONT_SUPERSCRIPT);
        }
        if (this.background != null) {
            outputStream.write(BACKGROUND_COLOR);
            outputStream.write(this.intToByteArray(this.background.getColorNumber()));
        }
        outputStream.write(RtfBasicElement.DELIMITER);
        this.document.filterSpecialChar(outputStream, this.content, false, this.softLineBreaks || this.document.getDocumentSettings().isAlwaysGenerateSoftLinebreaks());
        if (this.superSubScript != 0.0f) {
            outputStream.write(FONT_END_SUPER_SUBSCRIPT);
        }
        this.font.writeEnd(outputStream);
        if (this.background != null) {
            outputStream.write(RtfBasicElement.CLOSE_GROUP);
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        this.font.setRtfDocument(this.document);
    }

    public void setSoftLineBreaks(boolean bl) {
        this.softLineBreaks = bl;
    }

    public boolean getSoftLineBreaks() {
        return this.softLineBreaks;
    }
}

