/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Annotation;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;

public class RtfAnnotation
extends RtfElement {
    private static final byte[] ANNOTATION_ID = DocWriter.getISOBytes("\\*\\atnid");
    private static final byte[] ANNOTATION_AUTHOR = DocWriter.getISOBytes("\\*\\atnauthor");
    private static final byte[] ANNOTATION = DocWriter.getISOBytes("\\*\\annotation");
    private String title = "";
    private String content = "";

    public RtfAnnotation(RtfDocument rtfDocument, Annotation annotation) {
        super(rtfDocument);
        this.title = annotation.title();
        this.content = annotation.content();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(ANNOTATION_ID);
        outputStream.write(RtfBasicElement.DELIMITER);
        outputStream.write(this.intToByteArray(this.document.getRandomInt()));
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(ANNOTATION_AUTHOR);
        outputStream.write(RtfBasicElement.DELIMITER);
        outputStream.write(DocWriter.getISOBytes(this.title));
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(ANNOTATION);
        outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        outputStream.write(RtfBasicElement.DELIMITER);
        outputStream.write(DocWriter.getISOBytes(this.content));
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
    }
}

