/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.table;

import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.table.RtfBorder;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class RtfBorderGroup
extends RtfElement {
    private int borderType = 1;
    private Hashtable borders = null;

    public RtfBorderGroup() {
        super(null);
        this.borders = new Hashtable();
    }

    public RtfBorderGroup(int n, int n2, float f, Color color) {
        super(null);
        this.borders = new Hashtable();
        this.addBorder(n, n2, f, color);
    }

    protected RtfBorderGroup(RtfDocument rtfDocument, int n, RtfBorderGroup rtfBorderGroup) {
        super(rtfDocument);
        this.borders = new Hashtable();
        this.borderType = n;
        if (rtfBorderGroup != null) {
            Iterator iterator = rtfBorderGroup.getBorders().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.borders.put(entry.getKey(), new RtfBorder(this.document, this.borderType, (RtfBorder)entry.getValue()));
            }
        }
    }

    protected RtfBorderGroup(RtfDocument rtfDocument, int n, int n2, float f, Color color) {
        super(rtfDocument);
        this.borderType = n;
        this.borders = new Hashtable();
        this.addBorder(n2, 1, f, color);
    }

    private void setBorder(int n, int n2, float f, Color color) {
        RtfBorder rtfBorder = new RtfBorder(this.document, this.borderType, n, n2, f, color);
        this.borders.put(new Integer(n), rtfBorder);
    }

    public void addBorder(int n, int n2, float f, Color color) {
        if ((n & 4) == 4) {
            this.setBorder(1, n2, f, color);
        }
        if ((n & 1) == 1) {
            this.setBorder(2, n2, f, color);
        }
        if ((n & 8) == 8) {
            this.setBorder(4, n2, f, color);
        }
        if ((n & 2) == 2) {
            this.setBorder(8, n2, f, color);
        }
        if ((n & 0xF) == 15 && this.borderType == 1) {
            this.setBorder(16, n2, f, color);
            this.setBorder(32, n2, f, color);
        }
    }

    public void removeBorder(int n) {
        if ((n & 4) == 4) {
            this.borders.remove(new Integer(1));
        }
        if ((n & 1) == 1) {
            this.borders.remove(new Integer(2));
        }
        if ((n & 8) == 8) {
            this.borders.remove(new Integer(4));
        }
        if ((n & 2) == 2) {
            this.borders.remove(new Integer(8));
        }
        if ((n & 0xF) == 15 && this.borderType == 1) {
            this.borders.remove(new Integer(16));
            this.borders.remove(new Integer(32));
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        Iterator iterator = this.borders.values().iterator();
        while (iterator.hasNext()) {
            ((RtfBorder)iterator.next()).writeContent(outputStream);
        }
    }

    protected Hashtable getBorders() {
        return this.borders;
    }
}

