/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.style;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.RtfExtendedElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = DocWriter.getISOBytes("\\deff");
    private static final byte[] FONT_TABLE = DocWriter.getISOBytes("\\fonttbl");
    public static final byte[] FONT_NUMBER = DocWriter.getISOBytes("\\f");
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public int getFontNumber(RtfFont rtfFont) {
        if (rtfFont instanceof RtfParagraphStyle) {
            rtfFont = new RtfFont(this.document, rtfFont);
        }
        int n = -1;
        for (int i = 0; i < this.fontList.size(); ++i) {
            if (!this.fontList.get(i).equals(rtfFont)) continue;
            n = i;
        }
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.add(rtfFont);
        }
        return n;
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(DEFAULT_FONT);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(FONT_TABLE);
        for (int i = 0; i < this.fontList.size(); ++i) {
            outputStream.write(RtfBasicElement.OPEN_GROUP);
            outputStream.write(FONT_NUMBER);
            outputStream.write(this.intToByteArray(i));
            RtfFont rtfFont = (RtfFont)this.fontList.get(i);
            rtfFont.writeDefinition(outputStream);
            outputStream.write(RtfBasicElement.COMMA_DELIMITER);
            outputStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }
}

