/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.style;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfExtendedElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfColor;
import com.fr.third.com.lowagie.text.rtf.style.RtfFontList;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfFont
extends Font
implements RtfExtendedElement {
    private static final byte[] FONT_FAMILY = DocWriter.getISOBytes("\\froman");
    private static final byte[] FONT_CHARSET = DocWriter.getISOBytes("\\fcharset");
    public static final byte[] FONT_SIZE = DocWriter.getISOBytes("\\fs");
    private static final byte[] FONT_BOLD = DocWriter.getISOBytes("\\b");
    private static final byte[] FONT_ITALIC = DocWriter.getISOBytes("\\i");
    private static final byte[] FONT_UNDERLINE = DocWriter.getISOBytes("\\ul");
    private static final byte[] FONT_STRIKETHROUGH = DocWriter.getISOBytes("\\strike");
    private static final byte[] FONT_DOUBLE_STRIKETHROUGH = DocWriter.getISOBytes("\\striked");
    private static final byte[] FONT_SHADOW = DocWriter.getISOBytes("\\shad");
    private static final byte[] FONT_OUTLINE = DocWriter.getISOBytes("\\outl");
    private static final byte[] FONT_EMBOSSED = DocWriter.getISOBytes("\\embo");
    private static final byte[] FONT_ENGRAVED = DocWriter.getISOBytes("\\impr");
    private static final byte[] FONT_HIDDEN = DocWriter.getISOBytes("\\v");
    public static final int STYLE_NONE = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int STYLE_DOUBLE_STRIKETHROUGH = 16;
    public static final int STYLE_SHADOW = 32;
    public static final int STYLE_OUTLINE = 64;
    public static final int STYLE_EMBOSSED = 128;
    public static final int STYLE_ENGRAVED = 256;
    public static final int STYLE_HIDDEN = 512;
    public static final String DEFAULT_FONT = "Times New Roman";
    private String fontName = "Times New Roman";
    private int fontSize = 10;
    private int fontStyle = 0;
    private int fontNumber = 0;
    private RtfColor color = null;
    private int charset = 0;
    protected RtfDocument document = null;

    public RtfFont(String string) {
        super(-1, -1.0f, -1, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f) {
        super(-1, f, -1, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n) {
        super(-1, f, n, null);
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n, Color color) {
        super(-1, f, n, color);
        this.fontName = string;
    }

    public RtfFont(String string, float f, int n, Color color, int n2) {
        this(string, f, n, color);
        this.charset = n2;
    }

    protected RtfFont(RtfDocument rtfDocument, int n) {
        this.document = rtfDocument;
        this.fontNumber = n;
        this.color = new RtfColor(rtfDocument, 0, 0, 0);
    }

    public RtfFont(RtfDocument rtfDocument, Font font) {
        this.document = rtfDocument;
        if (font != null) {
            if (font instanceof RtfFont) {
                this.fontName = ((RtfFont)font).getFontName();
                this.charset = ((RtfFont)font).getCharset();
            } else {
                this.setToDefaultFamily(font.getFamilyname());
            }
            if (font.getBaseFont() != null) {
                String[][] stringArray = font.getBaseFont().getFullFontName();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i][2].equals("0")) {
                        this.fontName = stringArray[i][3];
                        break;
                    }
                    if (!stringArray[i][2].equals("1033") && !stringArray[i][2].equals("")) continue;
                    this.fontName = stringArray[i][3];
                }
            }
            if (this.fontName.equalsIgnoreCase("unknown")) {
                this.fontName = DEFAULT_FONT;
            }
            this.setSize(font.getSize());
            this.setStyle(font.getStyle());
            this.setColor(font.getColor());
            if (this.document != null) {
                this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
            }
        }
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(FONT_FAMILY);
        outputStream.write(FONT_CHARSET);
        outputStream.write(this.intToByteArray(this.charset));
        outputStream.write(RtfBasicElement.DELIMITER);
        this.document.filterSpecialChar(outputStream, this.fontName, true, false);
    }

    public void writeBegin(OutputStream outputStream) throws IOException {
        if (this.fontNumber != -1) {
            outputStream.write(RtfFontList.FONT_NUMBER);
            outputStream.write(this.intToByteArray(this.fontNumber));
        }
        if (this.fontSize != -1) {
            outputStream.write(FONT_SIZE);
            outputStream.write(this.intToByteArray(this.fontSize * 2));
        }
        if (this.fontStyle != -1) {
            if ((this.fontStyle & 1) == 1) {
                outputStream.write(FONT_BOLD);
            }
            if ((this.fontStyle & 2) == 2) {
                outputStream.write(FONT_ITALIC);
            }
            if ((this.fontStyle & 4) == 4) {
                outputStream.write(FONT_UNDERLINE);
            }
            if ((this.fontStyle & 8) == 8) {
                outputStream.write(FONT_STRIKETHROUGH);
            }
            if ((this.fontStyle & 0x200) == 512) {
                outputStream.write(FONT_HIDDEN);
            }
            if ((this.fontStyle & 0x10) == 16) {
                outputStream.write(FONT_DOUBLE_STRIKETHROUGH);
                outputStream.write(this.intToByteArray(1));
            }
            if ((this.fontStyle & 0x20) == 32) {
                outputStream.write(FONT_SHADOW);
            }
            if ((this.fontStyle & 0x40) == 64) {
                outputStream.write(FONT_OUTLINE);
            }
            if ((this.fontStyle & 0x80) == 128) {
                outputStream.write(FONT_EMBOSSED);
            }
            if ((this.fontStyle & 0x100) == 256) {
                outputStream.write(FONT_ENGRAVED);
            }
        }
        if (this.color != null) {
            this.color.writeBegin(outputStream);
        }
    }

    public void writeEnd(OutputStream outputStream) throws IOException {
        if (this.fontStyle != -1) {
            if ((this.fontStyle & 1) == 1) {
                outputStream.write(FONT_BOLD);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 2) == 2) {
                outputStream.write(FONT_ITALIC);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 4) == 4) {
                outputStream.write(FONT_UNDERLINE);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 8) == 8) {
                outputStream.write(FONT_STRIKETHROUGH);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x200) == 512) {
                outputStream.write(FONT_HIDDEN);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x10) == 16) {
                outputStream.write(FONT_DOUBLE_STRIKETHROUGH);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x20) == 32) {
                outputStream.write(FONT_SHADOW);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x40) == 64) {
                outputStream.write(FONT_OUTLINE);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x80) == 128) {
                outputStream.write(FONT_EMBOSSED);
                outputStream.write(this.intToByteArray(0));
            }
            if ((this.fontStyle & 0x100) == 256) {
                outputStream.write(FONT_ENGRAVED);
                outputStream.write(this.intToByteArray(0));
            }
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfFont)) {
            return false;
        }
        RtfFont rtfFont = (RtfFont)object;
        boolean bl = true;
        return bl &= this.fontName.equals(rtfFont.getFontName());
    }

    public int hashCode() {
        return (this.fontName + this.fontSize + "-" + this.fontStyle).hashCode();
    }

    public String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String string) {
        this.fontName = string;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
    }

    public String getFamilyname() {
        return this.fontName;
    }

    public void setFamily(String string) {
        super.setFamily(string);
        this.setToDefaultFamily(string);
    }

    private void setToDefaultFamily(String string) {
        switch (Font.getFamilyIndex(string)) {
            case 0: {
                this.fontName = "Courier";
                break;
            }
            case 1: {
                this.fontName = "Arial";
                break;
            }
            case 3: {
                this.fontName = "Symbol";
                this.charset = 2;
                break;
            }
            case 2: {
                this.fontName = DEFAULT_FONT;
                break;
            }
            case 4: {
                this.fontName = "Windings";
                break;
            }
            default: {
                this.fontName = string;
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setSize(float f) {
        super.setSize(f);
        this.fontSize = (int)this.getSize();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setStyle(int n) {
        super.setStyle(n);
        this.fontStyle = this.getStyle();
    }

    public void setStyle(String string) {
        super.setStyle(string);
        this.fontStyle = this.getStyle();
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int n) {
        this.charset = n;
    }

    public int getFontNumber() {
        return this.fontNumber;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        if (this.color != null) {
            this.color.setRtfDocument(this.document);
        }
    }

    public void setInTable(boolean bl) {
    }

    public void setInHeader(boolean bl) {
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.color = color != null ? new RtfColor(this.document, color) : null;
    }

    public void setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        this.color = new RtfColor(this.document, n, n2, n3);
    }

    protected byte[] intToByteArray(int n) {
        return DocWriter.getISOBytes(Integer.toString(n));
    }

    public Font difference(Font font) {
        float f;
        String string = font.getFamilyname();
        if (string == null || string.trim().equals("") || string.trim().equalsIgnoreCase("unknown")) {
            string = this.fontName;
        }
        if ((f = font.getSize()) == -1.0f) {
            f = this.getSize();
        }
        int n = -1;
        if (this.getStyle() != -1 && font.getStyle() != -1) {
            n = this.getStyle() | font.getStyle();
        } else if (this.getStyle() != -1) {
            n = this.getStyle();
        } else if (font.getStyle() != -1) {
            n = font.getStyle();
        }
        Color color = font.getColor();
        if (color == null) {
            color = this.getColor();
        }
        int n2 = this.charset;
        if (font instanceof RtfFont) {
            n2 = ((RtfFont)font).getCharset();
        }
        return new RtfFont(string, f, n, color, n2);
    }

    public boolean isStandardFont() {
        return false;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof RtfFont) {
            if (this.getFontName().compareTo(((RtfFont)object).getFontName()) != 0) {
                return 1;
            }
            return super.compareTo(object);
        }
        if (object instanceof Font) {
            return super.compareTo(object);
        }
        return -3;
    }
}

