/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.style;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.RtfExtendedElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfColor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfColorList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_TABLE = DocWriter.getISOBytes("\\colortbl");
    ArrayList colorList = new ArrayList();

    public RtfColorList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.colorList.add(new RtfColor(rtfDocument, 0, 0, 0, 0));
        this.colorList.add(new RtfColor(rtfDocument, 255, 255, 255, 1));
    }

    public int getColorNumber(RtfColor rtfColor) {
        int n = -1;
        for (int i = 0; i < this.colorList.size(); ++i) {
            if (!this.colorList.get(i).equals(rtfColor)) continue;
            n = i;
        }
        if (n == -1) {
            n = this.colorList.size();
            this.colorList.add(rtfColor);
        }
        return n;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(COLOR_TABLE);
        for (int i = 0; i < this.colorList.size(); ++i) {
            RtfColor rtfColor = (RtfColor)this.colorList.get(i);
            rtfColor.writeDefinition(outputStream);
        }
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }
}

