/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.parser.destinations;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.FontFactory;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.rtf.direct.RtfDirectContent;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.parser.RtfParser;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestinationFontTable;
import com.fr.third.com.lowagie.text.rtf.parser.properties.RtfPropertyListener;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class RtfDestinationDocument
extends RtfDestination
implements RtfPropertyListener {
    private RtfDocument rtfDoc = null;
    private Document doc = null;
    private StringBuffer buffer = null;
    private int conversionType = 0;
    private int tableLevel = 0;
    private static final List IMPORT_IGNORED_CTRLWORDS = Arrays.asList("rtf", "ansicpg", "deff", "ansi", "mac", "pca", "pc", "stshfdbch", "stshfloch", "stshfhich", "stshfbi", "deflang", "deflangfe", "adeflang", "adeflangfe");
    private static final List CONVERT_IGNORED_CTRLWORDS = Arrays.asList("rtf");
    private Paragraph iTextParagraph = null;

    public RtfDestinationDocument() {
        super(null);
    }

    public RtfDestinationDocument(RtfParser rtfParser) {
        super(rtfParser);
        this.rtfDoc = rtfParser.getRtfDocument();
        this.doc = rtfParser.getDocument();
        this.conversionType = rtfParser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    protected void finalize() throws Throwable {
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        }
        super.finalize();
    }

    public void setParser(RtfParser rtfParser) {
        this.rtfParser = rtfParser;
        this.rtfDoc = rtfParser.getRtfDocument();
        this.doc = rtfParser.getDocument();
        this.conversionType = rtfParser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    public boolean closeDestination() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        return true;
    }

    public boolean handleOpenGroup() {
        this.onOpenGroup();
        if (this.rtfParser.isImport()) {
            // empty if block
        }
        if (this.rtfParser.isConvert() && this.iTextParagraph == null) {
            this.iTextParagraph = new Paragraph();
        }
        return true;
    }

    public boolean handleOpeningSubGroup() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        return true;
    }

    public boolean handleCloseGroup() {
        this.onCloseGroup();
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 0) {
                this.writeBuffer();
            }
            this.writeText("}");
        }
        if (this.rtfParser.isConvert()) {
            if (this.buffer.length() > 0 && this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            if (this.buffer.length() > 0) {
                Chunk chunk = new Chunk();
                chunk.append(this.buffer.toString());
                this.iTextParagraph.add(chunk);
            }
            if (this.iTextParagraph != null) {
                this.addParagraphToDocument();
            }
        }
        return true;
    }

    public boolean handleCharacter(int n) {
        boolean bl = true;
        this.onCharacter(n);
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 254) {
                this.writeBuffer();
            }
            this.buffer.append((char)n);
        }
        if (this.rtfParser.isConvert()) {
            this.buffer.append((char)n);
        }
        return bl;
    }

    public boolean handleControlWord(RtfCtrlWordData rtfCtrlWordData) {
        boolean bl = false;
        this.onCtrlWord(rtfCtrlWordData);
        if (this.rtfParser.isImport()) {
            if (rtfCtrlWordData.ctrlWord.equals("f")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapFontNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("cb")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("cf")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcbpat")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcbpatraw")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcfpat")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcfpatraw")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcfpat")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcbpat")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("brdrcf")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapColorNr(rtfCtrlWordData.param);
            }
            if (rtfCtrlWordData.ctrlWord.equals("ls")) {
                rtfCtrlWordData.param = this.rtfParser.getImportManager().mapListNr(rtfCtrlWordData.param);
            }
        }
        if (this.rtfParser.isConvert()) {
            if (rtfCtrlWordData.ctrlWord.equals("par")) {
                this.addParagraphToDocument();
            }
            if (rtfCtrlWordData.ctrlWord.equals("f")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cf")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcbpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcbpatraw")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcfpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clcfpatraw")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcfpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcbpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("brdrcf")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trowd")) {
                ++this.tableLevel;
            }
            if (rtfCtrlWordData.ctrlWord.equals("cell")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            if (rtfCtrlWordData.ctrlWord.equals("lastrow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            if (rtfCtrlWordData.ctrlWord.equals("irow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("irowband")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tcelld")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("nestcell")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("nestrow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("nesttableprops")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("nonesttables")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trgaph")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cellx")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmgf")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmrg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clvmgf")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clvmrg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trauth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trdate")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkborder")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkshading")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkfont")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkcolor")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkbestfit")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkhdrrows")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllklastrow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllkhdrcols")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllklastcol")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllknorowband")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tbllknocolband")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("taprtl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trautofit")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trhdr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trkeep")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trkeepfollow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trleft")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trqc")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trql")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trqr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trrh")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddfb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddfl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddfr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpaddft")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdfl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdft")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdfb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trspdfr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trwWidth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trftsWidth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trwWidthB")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trftsWidthB")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trftsWidthB")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trwWidthA")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trftsWidthA")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tblind")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tblindtype")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcbpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trcfpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trpat")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trshdng")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgbdiag")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgcross")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdcross")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkbdiag")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkcross")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkdcross")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkfdiag")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkhor")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgdkvert")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgfdiag")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbghoriz")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbgvert")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clFitText")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clNoWrap")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadfl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadft")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadfb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clpadfr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clwWidth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clftsWidth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clhidemark")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clins")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cldel")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmrgd")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmrgdr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clsplit")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clsplitr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clinsauth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clinsdttm")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cldelauth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cldeldttm")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmrgdauth")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clmrgddttm")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tdfrmtxtLeft")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tdfrmtxtRight")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tdfrmtxtTop")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tdfrmtxtBottom")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tabsnoovrlp")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tphcol")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tphmrg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tphpg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposnegx")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposnegy")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposx")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposxc")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposxi")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposxl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposxo")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposxr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposy")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyc")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyil")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyin")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyout")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tposyt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tpvmrg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tpvpara")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("tpvpg")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("rtlrow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("ltrrow")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrh")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("trbrdrv")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("brdrnil")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clbrdrb")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clbrdrt")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clbrdrl")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("clbrdrr")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cldglu")) {
                // empty if block
            }
            if (rtfCtrlWordData.ctrlWord.equals("cldgll")) {
                // empty if block
            }
        }
        if (rtfCtrlWordData.ctrlWordType == 4) {
            this.rtfParser.getState().properties.toggleProperty(rtfCtrlWordData);
        }
        if (rtfCtrlWordData.ctrlWordType == 2 || rtfCtrlWordData.ctrlWordType == 3) {
            this.rtfParser.getState().properties.setProperty(rtfCtrlWordData);
        }
        switch (this.conversionType) {
            case 0: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(rtfCtrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(rtfCtrlWordData.toString());
                }
                bl = true;
                break;
            }
            case 1: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(rtfCtrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(rtfCtrlWordData.toString());
                }
                bl = true;
                break;
            }
            case 2: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(rtfCtrlWordData.ctrlWord)) {
                    // empty if block
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void writeBuffer() {
        this.writeText(this.buffer.toString());
        this.setToDefaults();
    }

    private void writeText(String string) {
        if (this.rtfParser.isNewGroup()) {
            this.rtfDoc.add(new RtfDirectContent("{"));
            this.rtfParser.setNewGroup(false);
        }
        if (string.length() > 0) {
            this.rtfDoc.add(new RtfDirectContent(string));
        }
    }

    public void setToDefaults() {
        this.buffer = new StringBuffer(255);
    }

    public void afterPropertyChange(String string) {
        if (string.startsWith("character.") || string.startsWith("paragraph.") || string.startsWith("section.") || string.startsWith("document.")) {
            // empty if block
        }
    }

    public void beforePropertyChange(String string) {
        if (this.buffer.length() == 0) {
            return;
        }
        if (string.startsWith("character.")) {
            Chunk chunk = new Chunk();
            chunk.append(this.buffer.toString());
            this.buffer = new StringBuffer(255);
            HashMap hashMap = this.rtfParser.getState().properties.getProperties("character.");
            String string2 = (String)hashMap.get("character.font");
            if (string2 == null) {
                string2 = "0";
            }
            RtfDestinationFontTable rtfDestinationFontTable = (RtfDestinationFontTable)this.rtfParser.getDestination("fonttbl");
            Font font = rtfDestinationFontTable.getFont(string2);
            int n = 0;
            if (hashMap.containsKey("character.bold")) {
                n |= 1;
            }
            if (hashMap.containsKey("character.italic")) {
                n |= 2;
            }
            if (hashMap.containsKey("character.underline")) {
                n |= 4;
            }
            Font font2 = FontFactory.getFont(font.getFamilyname(), 12.0f, n, new Color(0, 0, 0));
            chunk.setFont(font2);
            if (this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            this.iTextParagraph.add(chunk);
        } else if (string.startsWith("paragraph.") || string.startsWith("section.") || string.startsWith("document.")) {
            // empty if block
        }
    }

    private void addParagraphToDocument() {
        if (this.iTextParagraph != null) {
            try {
                this.rtfParser.getDocument().add(this.iTextParagraph);
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
            this.iTextParagraph = null;
        }
    }
}

