/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.parser.destinations;

import com.fr.third.com.lowagie.text.rtf.parser.RtfImportMgr;
import com.fr.third.com.lowagie.text.rtf.parser.RtfParser;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestination;
import java.awt.Color;
import java.util.HashMap;

public class RtfDestinationColorTable
extends RtfDestination {
    private RtfImportMgr importHeader = null;
    private int colorNr = 0;
    private int red = -1;
    private int green = -1;
    private int blue = -1;
    private int ctint = 255;
    private int cshade = 255;
    private int themeColor = -1;
    private HashMap colorMap = new HashMap();

    public RtfDestinationColorTable() {
        super(null);
    }

    public RtfDestinationColorTable(RtfParser rtfParser) {
        super(rtfParser);
        this.importHeader = rtfParser.getImportManager();
        this.setToDefaults();
    }

    public void setParser(RtfParser rtfParser) {
        this.rtfParser = rtfParser;
        this.colorMap = new HashMap();
        this.colorNr = 0;
        this.importHeader = rtfParser.getImportManager();
        this.setToDefaults();
    }

    public boolean handleOpeningSubGroup() {
        return true;
    }

    public boolean closeDestination() {
        return true;
    }

    public boolean handleCloseGroup() {
        this.processColor();
        return true;
    }

    public boolean handleOpenGroup() {
        return true;
    }

    public boolean handleCharacter(int n) {
        if (n == 59) {
            this.processColor();
        }
        return true;
    }

    public boolean handleControlWord(RtfCtrlWordData rtfCtrlWordData) {
        if (rtfCtrlWordData.ctrlWord.equals("blue")) {
            this.setBlue(rtfCtrlWordData.intValue());
        }
        if (rtfCtrlWordData.ctrlWord.equals("red")) {
            this.setRed(rtfCtrlWordData.intValue());
        }
        if (rtfCtrlWordData.ctrlWord.equals("green")) {
            this.setGreen(rtfCtrlWordData.intValue());
        }
        if (rtfCtrlWordData.ctrlWord.equals("cshade")) {
            this.setShade(rtfCtrlWordData.intValue());
        }
        if (rtfCtrlWordData.ctrlWord.equals("ctint")) {
            this.setTint(rtfCtrlWordData.intValue());
        }
        return true;
    }

    public void setToDefaults() {
        this.red = -1;
        this.green = -1;
        this.blue = -1;
        this.ctint = 255;
        this.cshade = 255;
        this.themeColor = -1;
    }

    private void processColor() {
        if (this.red != -1 && this.green != -1 && this.blue != -1) {
            if (this.rtfParser.isImport()) {
                this.importHeader.importColor(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
            if (this.rtfParser.isConvert()) {
                this.colorMap.put(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
        }
        this.setToDefaults();
        ++this.colorNr;
    }

    private void setRed(int n) {
        if (n >= 0 && n <= 255) {
            this.red = n;
        }
    }

    private void setGreen(int n) {
        if (n >= 0 && n <= 255) {
            this.green = n;
        }
    }

    private void setBlue(int n) {
        if (n >= 0 && n <= 255) {
            this.blue = n;
        }
    }

    private void setTint(int n) {
        if (n >= 0 && n <= 255) {
            this.ctint = n;
            if (n >= 0 && n < 255) {
                this.cshade = 255;
            }
        }
    }

    private void setShade(int n) {
        if (n >= 0 && n <= 255) {
            this.cshade = n;
            if (n >= 0 && n < 255) {
                this.ctint = 255;
            }
        }
    }

    private void setThemeColor(int n) {
        this.themeColor = n >= -1 && n <= 15 ? n : -1;
    }

    public Color getColor(String string) {
        return (Color)this.colorMap.get(string);
    }
}

