/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.parser.ctrlwords;

import com.fr.third.com.lowagie.text.rtf.parser.RtfParser;
import com.fr.third.com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.fr.third.com.lowagie.text.rtf.parser.destinations.RtfDestinationMgr;

public class RtfCtrlWordHandler
implements Cloneable {
    private static final boolean debug = false;
    protected RtfParser rtfParser = null;
    protected String ctrlWord = "";
    protected int defaultParameterValue = 0;
    protected boolean passDefaultParameterValue = false;
    protected int ctrlWordType = -1;
    protected String specialHandler = "";
    protected float rtfVersionSupported = -1.0f;
    protected RtfCtrlWordData ctrlWordData = null;
    protected String groupPrefix = "";
    protected String ctrlWordPrefix = "\\";
    protected String ctrlWordSuffix = " ";

    private RtfCtrlWordHandler() {
    }

    public RtfCtrlWordHandler(RtfParser rtfParser, String string, int n, boolean bl, int n2, String string2, String string3, String string4) {
        this.rtfParser = rtfParser;
        this.ctrlWord = string;
        this.defaultParameterValue = n;
        this.passDefaultParameterValue = bl;
        this.ctrlWordType = n2;
        this.ctrlWordPrefix = string2;
        this.ctrlWordSuffix = string3;
        this.specialHandler = string4;
        if (this.ctrlWordType == 0 || this.ctrlWordType == 1) {
            if (this.specialHandler == null) {
                this.specialHandler = "RtfDestinationNull";
            }
            String string5 = "";
            RtfDestinationMgr.addDestination(this.ctrlWord, new Object[]{this.specialHandler, string5});
        } else if (this.ctrlWordType != 5) {
            if (this.specialHandler == null) {
                this.specialHandler = this.ctrlWord;
            } else if (this.specialHandler.length() > 1 && this.specialHandler.endsWith(".")) {
                this.specialHandler = this.specialHandler + this.ctrlWord;
            }
        }
    }

    public final boolean handleControlword(RtfCtrlWordData rtfCtrlWordData) {
        boolean bl = false;
        this.ctrlWordData = rtfCtrlWordData;
        RtfDestination rtfDestination = null;
        boolean bl2 = false;
        this.ctrlWordData.prefix = this.ctrlWordPrefix;
        this.ctrlWordData.suffix = this.ctrlWordSuffix;
        this.ctrlWordData.newGroup = this.rtfParser.getState().newGroup;
        this.ctrlWordData.ctrlWordType = this.ctrlWordType;
        this.ctrlWordData.specialHandler = this.specialHandler;
        if (!this.ctrlWordData.hasParam && this.passDefaultParameterValue) {
            this.ctrlWordData.hasParam = true;
            this.ctrlWordData.param = Integer.toString(this.defaultParameterValue);
        }
        if (this.ctrlWordData.ctrlWord.equals("*")) {
            return true;
        }
        if (!this.beforeControlWord()) {
            return true;
        }
        switch (this.ctrlWordType) {
            case 2: 
            case 3: 
            case 4: {
                rtfDestination = this.rtfParser.getCurrentDestination();
                if (rtfDestination == null) break;
                bl2 = rtfDestination.handleControlWord(this.ctrlWordData);
                break;
            }
            case 5: {
                rtfDestination = this.rtfParser.getCurrentDestination();
                if (rtfDestination == null) break;
                String string = null;
                if (this.rtfParser.isImport()) {
                    string = this.ctrlWordPrefix + this.ctrlWordData.ctrlWord + this.ctrlWordSuffix;
                }
                if (this.rtfParser.isConvert()) {
                    string = this.specialHandler;
                }
                if (string != null) {
                    for (int i = 0; i < string.length(); ++i) {
                        bl2 = rtfDestination.handleCharacter(string.charAt(i));
                    }
                    break;
                }
                bl2 = rtfDestination.handleControlWord(this.ctrlWordData);
                break;
            }
            case 0: 
            case 1: {
                int n = 0;
                if ("shppict".equals(this.ctrlWord) || "nonshppict".equals(this.ctrlWord)) {
                    ++n;
                }
                bl2 = this.rtfParser.setCurrentDestination(this.ctrlWord);
                rtfDestination = this.rtfParser.getCurrentDestination();
                if (rtfDestination == null) break;
                if (rtfDestination.getNewTokeniserState() == 5) {
                    bl2 = rtfDestination.handleControlWord(this.ctrlWordData);
                    break;
                }
                this.rtfParser.setTokeniserState(rtfDestination.getNewTokeniserState());
            }
        }
        this.afterControlWord();
        return bl;
    }

    protected boolean beforeControlWord() {
        return true;
    }

    protected boolean onControlWord() {
        return false;
    }

    protected boolean afterControlWord() {
        return true;
    }

    private final void printDebug(String string) {
        System.out.println(this.getClass().getName() + " : " + string);
    }
}

