/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.list;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.RtfExtendedElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.list.RtfList;
import com.fr.third.com.lowagie.text.rtf.style.RtfColor;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfFontList;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.fr.third.com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfListLevel
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = DocWriter.getISOBytes("\\listlevel");
    private static final byte[] LIST_LEVEL_TEMPLATE_ID = DocWriter.getISOBytes("\\leveltemplateid");
    private static final byte[] LIST_LEVEL_TYPE = DocWriter.getISOBytes("\\levelnfc");
    private static final byte[] LIST_LEVEL_TYPE_NEW = DocWriter.getISOBytes("\\levelnfcn");
    private static final byte[] LIST_LEVEL_ALIGNMENT = DocWriter.getISOBytes("\\leveljc");
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = DocWriter.getISOBytes("\\leveljcn");
    private static final byte[] LIST_LEVEL_START_AT = DocWriter.getISOBytes("\\levelstartat");
    private static final byte[] LIST_LEVEL_TEXT = DocWriter.getISOBytes("\\leveltext");
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = DocWriter.getISOBytes("\\'02\\'");
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = DocWriter.getISOBytes(".;");
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_BEGIN = DocWriter.getISOBytes("\\'01");
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_END = DocWriter.getISOBytes(";");
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = DocWriter.getISOBytes("\\levelnumbers");
    private static final byte[] LIST_LEVEL_FOLOW = DocWriter.getISOBytes("\\levelfollow");
    private static final byte[] LIST_LEVEL_SPACE = DocWriter.getISOBytes("\\levelspace");
    private static final byte[] LIST_LEVEL_INDENT = DocWriter.getISOBytes("\\levelindent");
    private static final byte[] LIST_LEVEL_LEGAL = DocWriter.getISOBytes("\\levellegal");
    private static final byte[] LIST_LEVEL_NO_RESTART = DocWriter.getISOBytes("\\levelnorestart");
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = DocWriter.getISOBytes("\\'01");
    private static final byte[] LIST_LEVEL_NUMBERS_END = DocWriter.getISOBytes(";");
    private static final byte[] LIST_LEVEL_FIRST_INDENT = DocWriter.getISOBytes("\\fi");
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = DocWriter.getISOBytes("\\tx");
    private static final byte[] LIST_LEVEL_TENTATIVE = DocWriter.getISOBytes("\\lvltentative");
    private static final byte[] LIST_LEVEL_PICTURE = DocWriter.getISOBytes("\\levelpicture");
    public static final int LIST_TYPE_NUMBERED = 1;
    public static final int LIST_TYPE_UPPER_LETTERS = 2;
    public static final int LIST_TYPE_LOWER_LETTERS = 3;
    public static final int LIST_TYPE_UPPER_ROMAN = 4;
    public static final int LIST_TYPE_LOWER_ROMAN = 5;
    public static final int LIST_TYPE_UNKNOWN = -1;
    public static final int LIST_TYPE_BASE = 1000;
    public static final int LIST_TYPE_ARABIC = 1000;
    public static final int LIST_TYPE_UPPERCASE_ROMAN_NUMERAL = 1001;
    public static final int LIST_TYPE_LOWERCASE_ROMAN_NUMERAL = 1002;
    public static final int LIST_TYPE_UPPERCASE_LETTER = 1003;
    public static final int LIST_TYPE_LOWERCASE_LETTER = 1004;
    public static final int LIST_TYPE_ORDINAL_NUMBER = 1005;
    public static final int LIST_TYPE_CARDINAL_TEXT_NUMBER = 1006;
    public static final int LIST_TYPE_ORDINAL_TEXT_NUMBER = 1007;
    public static final int LIST_TYPE_ARABIC_LEADING_ZERO = 1022;
    public static final int LIST_TYPE_BULLET = 1023;
    public static final int LIST_TYPE_NO_NUMBER = 1255;
    private int listType = -1;
    private String bulletCharacter = "\u00b7";
    private Chunk bulletChunk = null;
    private int listStartAt = 1;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private boolean isTentative = true;
    private boolean isLegal = false;
    private int listNoRestart = 0;
    public static final int LIST_LEVEL_FOLLOW_TAB = 0;
    public static final int LIST_LEVEL_FOLLOW_SPACE = 1;
    public static final int LIST_LEVEL_FOLLOW_NOTHING = 2;
    private int levelFollowValue = 0;
    private int alignment = 0;
    private int levelPicture = -1;
    private int levelTextNumber = 0;
    private RtfFont fontNumber;
    private RtfFont fontBullet;
    private int templateID = -1;
    private RtfListLevel listLevelParent = null;
    private RtfList parent = null;

    public RtfListLevel(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.templateID = this.document.getRandomInt();
        this.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
        this.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    public RtfListLevel(RtfDocument rtfDocument, RtfList rtfList) {
        super(rtfDocument);
        this.parent = rtfList;
        this.templateID = this.document.getRandomInt();
        this.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
        this.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    public RtfListLevel(RtfListLevel rtfListLevel) {
        super(rtfListLevel.document);
        this.templateID = this.document.getRandomInt();
        this.alignment = rtfListLevel.alignment;
        this.bulletCharacter = rtfListLevel.bulletCharacter;
        this.firstIndent = rtfListLevel.firstIndent;
        this.fontBullet = rtfListLevel.fontBullet;
        this.fontNumber = rtfListLevel.fontNumber;
        this.inHeader = rtfListLevel.inHeader;
        this.inTable = rtfListLevel.inTable;
        this.leftIndent = rtfListLevel.leftIndent;
        this.listLevel = rtfListLevel.listLevel;
        this.listNoRestart = rtfListLevel.listNoRestart;
        this.listStartAt = rtfListLevel.listStartAt;
        this.listType = rtfListLevel.listType;
        this.parent = rtfListLevel.parent;
        this.rightIndent = rtfListLevel.rightIndent;
        this.symbolIndent = rtfListLevel.symbolIndent;
    }

    public int getListNoRestart() {
        return this.listNoRestart;
    }

    public void setListNoRestart(int n) {
        this.listNoRestart = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(LIST_LEVEL);
        outputStream.write(LIST_LEVEL_TYPE);
        switch (this.listType) {
            case 1023: {
                outputStream.write(this.intToByteArray(23));
                break;
            }
            case 1: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 2: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 3: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 4: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 5: {
                outputStream.write(this.intToByteArray(2));
                break;
            }
            case 1000: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 1001: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 1002: {
                outputStream.write(this.intToByteArray(2));
                break;
            }
            case 1003: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 1005: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 1006: {
                outputStream.write(this.intToByteArray(5));
                break;
            }
            case 1007: {
                outputStream.write(this.intToByteArray(6));
                break;
            }
            case 1004: {
                outputStream.write(this.intToByteArray(7));
                break;
            }
            case 1022: {
                outputStream.write(this.intToByteArray(22));
                break;
            }
            case 1255: {
                outputStream.write(this.intToByteArray(255));
                break;
            }
            default: {
                if (this.listType < 1000) break;
                outputStream.write(this.intToByteArray(this.listType - 1000));
            }
        }
        outputStream.write(LIST_LEVEL_TYPE_NEW);
        switch (this.listType) {
            case 1023: {
                outputStream.write(this.intToByteArray(23));
                break;
            }
            case 1: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 2: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 3: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 4: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 5: {
                outputStream.write(this.intToByteArray(2));
                break;
            }
            case 1000: {
                outputStream.write(this.intToByteArray(0));
                break;
            }
            case 1001: {
                outputStream.write(this.intToByteArray(1));
                break;
            }
            case 1002: {
                outputStream.write(this.intToByteArray(2));
                break;
            }
            case 1003: {
                outputStream.write(this.intToByteArray(3));
                break;
            }
            case 1005: {
                outputStream.write(this.intToByteArray(4));
                break;
            }
            case 1006: {
                outputStream.write(this.intToByteArray(5));
                break;
            }
            case 1007: {
                outputStream.write(this.intToByteArray(6));
                break;
            }
            case 1004: {
                outputStream.write(this.intToByteArray(7));
                break;
            }
            case 1022: {
                outputStream.write(this.intToByteArray(22));
                break;
            }
            case 1255: {
                outputStream.write(this.intToByteArray(255));
                break;
            }
            default: {
                if (this.listType < 1000) break;
                outputStream.write(this.intToByteArray(this.listType - 1000));
            }
        }
        outputStream.write(LIST_LEVEL_ALIGNMENT);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(LIST_LEVEL_ALIGNMENT_NEW);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(LIST_LEVEL_FOLOW);
        outputStream.write(this.intToByteArray(this.levelFollowValue));
        outputStream.write(LIST_LEVEL_START_AT);
        outputStream.write(this.intToByteArray(this.listStartAt));
        if (this.isTentative) {
            outputStream.write(LIST_LEVEL_TENTATIVE);
        }
        if (this.isLegal) {
            outputStream.write(LIST_LEVEL_LEGAL);
        }
        outputStream.write(LIST_LEVEL_SPACE);
        outputStream.write(this.intToByteArray(0));
        outputStream.write(LIST_LEVEL_INDENT);
        outputStream.write(this.intToByteArray(0));
        if (this.levelPicture != -1) {
            outputStream.write(LIST_LEVEL_PICTURE);
            outputStream.write(this.intToByteArray(this.levelPicture));
        }
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(LIST_LEVEL_TEXT);
        outputStream.write(LIST_LEVEL_TEMPLATE_ID);
        outputStream.write(this.intToByteArray(this.templateID));
        if (this.listType != 1023) {
            outputStream.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
            if (this.levelTextNumber < 10) {
                outputStream.write(this.intToByteArray(0));
            }
            outputStream.write(this.intToByteArray(this.levelTextNumber));
            outputStream.write(LIST_LEVEL_STYLE_NUMBERED_END);
        } else {
            outputStream.write(LIST_LEVEL_STYLE_BULLETED_BEGIN);
            this.document.filterSpecialChar(outputStream, this.bulletCharacter, false, false);
            outputStream.write(LIST_LEVEL_STYLE_BULLETED_END);
        }
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(LIST_LEVEL_NUMBERS_BEGIN);
        if (this.listType != 1023) {
            outputStream.write(LIST_LEVEL_NUMBERS_NUMBERED);
        }
        outputStream.write(LIST_LEVEL_NUMBERS_END);
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        outputStream.write(RtfFontList.FONT_NUMBER);
        if (this.listType != 1023) {
            outputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
        } else {
            outputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
        }
        outputStream.write(DocWriter.getISOBytes("\\cf"));
        outputStream.write(this.intToByteArray(this.document.getDocumentHeader().getColorNumber(new RtfColor(this.document, this.getFontNumber().getColor()))));
        this.writeIndentation(outputStream);
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    protected void writeListNumbers(OutputStream outputStream) throws IOException {
        if (this.listLevel > 0) {
            outputStream.write(RtfList.LIST_LEVEL_NUMBER);
            outputStream.write(this.intToByteArray(this.listLevel));
        }
    }

    public void writeIndentation(OutputStream outputStream) throws IOException {
        outputStream.write(LIST_LEVEL_FIRST_INDENT);
        outputStream.write(this.intToByteArray(this.firstIndent));
        outputStream.write(RtfParagraphStyle.INDENT_LEFT);
        outputStream.write(this.intToByteArray(this.leftIndent));
        outputStream.write(RtfParagraphStyle.INDENT_RIGHT);
        outputStream.write(this.intToByteArray(this.rightIndent));
        outputStream.write(LIST_LEVEL_SYMBOL_INDENT);
        outputStream.write(this.intToByteArray(this.leftIndent));
    }

    public void writeListBeginning(OutputStream outputStream) throws IOException {
        outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        if (this.inTable) {
            outputStream.write(RtfParagraph.IN_TABLE);
        }
        switch (this.alignment) {
            case 0: {
                outputStream.write(RtfParagraphStyle.ALIGN_LEFT);
                break;
            }
            case 2: {
                outputStream.write(RtfParagraphStyle.ALIGN_RIGHT);
                break;
            }
            case 1: {
                outputStream.write(RtfParagraphStyle.ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                outputStream.write(RtfParagraphStyle.ALIGN_JUSTIFY);
            }
        }
        this.writeIndentation(outputStream);
        outputStream.write(RtfFont.FONT_SIZE);
        outputStream.write(this.intToByteArray(this.fontNumber.getFontSize() * 2));
        if (this.symbolIndent > 0) {
            outputStream.write(LIST_LEVEL_SYMBOL_INDENT);
            outputStream.write(this.intToByteArray(this.leftIndent));
        }
    }

    protected void correctIndentation() {
        if (this.listLevelParent != null) {
            this.leftIndent = this.leftIndent + this.listLevelParent.getLeftIndent() + this.listLevelParent.getFirstIndent();
        }
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int n) {
        this.listLevel = n;
    }

    public String getBulletCharacter() {
        return this.bulletCharacter;
    }

    public int getListStartAt() {
        return this.listStartAt;
    }

    public void setListStartAt(int n) {
        this.listStartAt = n;
    }

    public int getFirstIndent() {
        return this.firstIndent;
    }

    public void setFirstIndent(int n) {
        this.firstIndent = n;
    }

    public int getLeftIndent() {
        return this.leftIndent;
    }

    public void setLeftIndent(int n) {
        this.leftIndent = n;
    }

    public int getRightIndent() {
        return this.rightIndent;
    }

    public void setRightIndent(int n) {
        this.rightIndent = n;
    }

    public int getSymbolIndent() {
        return this.symbolIndent;
    }

    public void setSymbolIndent(int n) {
        this.symbolIndent = n;
    }

    public RtfList getParent() {
        return this.parent;
    }

    public void setParent(RtfList rtfList) {
        this.parent = rtfList;
    }

    public void setBulletCharacter(String string) {
        this.bulletCharacter = string;
    }

    public void setBulletChunk(Chunk chunk) {
        this.bulletChunk = chunk;
    }

    public int getListType() {
        return this.listType;
    }

    public void setListType(int n) {
        this.listType = n;
    }

    public void setBulletFont(Font font) {
        this.fontBullet = new RtfFont(this.document, font);
    }

    public RtfFont getFontNumber() {
        return this.fontNumber;
    }

    public void setFontNumber(RtfFont rtfFont) {
        this.fontNumber = rtfFont;
    }

    public RtfFont getFontBullet() {
        return this.fontBullet;
    }

    public void setFontBullet(RtfFont rtfFont) {
        this.fontBullet = rtfFont;
    }

    public boolean isTentative() {
        return this.isTentative;
    }

    public void setTentative(boolean bl) {
        this.isTentative = bl;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public void setLegal(boolean bl) {
        this.isLegal = bl;
    }

    public int getLevelFollowValue() {
        return this.levelFollowValue;
    }

    public void setLevelFollowValue(int n) {
        this.levelFollowValue = n;
    }

    public int getLevelTextNumber() {
        return this.levelTextNumber;
    }

    public void setLevelTextNumber(int n) {
        this.levelTextNumber = n;
    }

    public RtfListLevel getListLevelParent() {
        return this.listLevelParent;
    }

    public void setListLevelParent(RtfListLevel rtfListLevel) {
        this.listLevelParent = rtfListLevel;
    }
}

