/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.graphic;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfAddableElement;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.graphic.RtfShapePosition;
import com.fr.third.com.lowagie.text.rtf.graphic.RtfShapeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class RtfShape
extends RtfAddableElement {
    public static final int SHAPE_PICTURE_FRAME = 75;
    public static final int SHAPE_FREEFORM = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_ROUND_RECTANGLE = 2;
    public static final int SHAPE_ELLIPSE = 3;
    public static final int SHAPE_DIAMOND = 4;
    public static final int SHAPE_TRIANGLE_ISOSCELES = 5;
    public static final int SHAPE_TRIANGLE_RIGHT = 6;
    public static final int SHAPE_PARALLELOGRAM = 7;
    public static final int SHAPE_TRAPEZOID = 8;
    public static final int SHAPE_HEXAGON = 9;
    public static final int SHAPE_OCTAGON = 10;
    public static final int SHAPE_STAR = 12;
    public static final int SHAPE_ARROW = 13;
    public static final int SHAPE_ARROR_THICK = 14;
    public static final int SHAPE_HOME_PLATE = 15;
    public static final int SHAPE_CUBE = 16;
    public static final int SHAPE_BALLOON = 17;
    public static final int SHAPE_SEAL = 18;
    public static final int SHAPE_ARC = 19;
    public static final int SHAPE_LINE = 20;
    public static final int SHAPE_CAN = 22;
    public static final int SHAPE_DONUT = 23;
    public static final int SHAPE_WRAP_NONE = 0;
    public static final int SHAPE_WRAP_TOP_BOTTOM = 1;
    public static final int SHAPE_WRAP_BOTH = 2;
    public static final int SHAPE_WRAP_LEFT = 3;
    public static final int SHAPE_WRAP_RIGHT = 4;
    public static final int SHAPE_WRAP_LARGEST = 5;
    public static final int SHAPE_WRAP_TIGHT_BOTH = 6;
    public static final int SHAPE_WRAP_TIGHT_LEFT = 7;
    public static final int SHAPE_WRAP_TIGHT_RIGHT = 8;
    public static final int SHAPE_WRAP_TIGHT_LARGEST = 9;
    public static final int SHAPE_WRAP_THROUGH = 10;
    private int shapeNr = 0;
    private int type = 0;
    private RtfShapePosition position = null;
    private HashMap properties = null;
    private int wrapping = 0;
    private String shapeText = "";

    public RtfShape(int n, RtfShapePosition rtfShapePosition) {
        this.type = n;
        this.position = rtfShapePosition;
        this.properties = new HashMap();
    }

    public void setProperty(RtfShapeProperty rtfShapeProperty) {
        rtfShapeProperty.setRtfDocument(this.doc);
        this.properties.put(rtfShapeProperty.getName(), rtfShapeProperty);
    }

    public void setShapeText(String string) {
        this.shapeText = string;
    }

    public void setWrapping(int n) {
        this.wrapping = n;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        this.shapeNr = this.doc.getRandomInt();
        this.properties.put("ShapeType", new RtfShapeProperty("ShapeType", this.type));
        if (this.position.isShapeBelowText()) {
            this.properties.put("fBehindDocument", new RtfShapeProperty("fBehindDocument", true));
        }
        if (this.inTable) {
            this.properties.put("fLayoutInCell", new RtfShapeProperty("fLayoutInCell", true));
        }
        if (this.properties.containsKey("posh")) {
            this.position.setIgnoreXRelative(true);
        }
        if (this.properties.containsKey("posv")) {
            this.position.setIgnoreYRelative(true);
        }
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(DocWriter.getISOBytes("\\shp"));
        outputStream.write(DocWriter.getISOBytes("\\shplid"));
        outputStream.write(this.intToByteArray(this.shapeNr));
        this.position.writeContent(outputStream);
        switch (this.wrapping) {
            case 0: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr3"));
                break;
            }
            case 1: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr1"));
                break;
            }
            case 2: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr2"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk0"));
                break;
            }
            case 3: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr2"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk1"));
                break;
            }
            case 4: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr2"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk2"));
                break;
            }
            case 5: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr2"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk3"));
                break;
            }
            case 6: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr4"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk0"));
                break;
            }
            case 7: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr4"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk1"));
                break;
            }
            case 8: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr4"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk2"));
                break;
            }
            case 9: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr4"));
                outputStream.write(DocWriter.getISOBytes("\\shpwrk3"));
                break;
            }
            case 10: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr5"));
                break;
            }
            default: {
                outputStream.write(DocWriter.getISOBytes("\\shpwr3"));
            }
        }
        if (this.inHeader) {
            outputStream.write(DocWriter.getISOBytes("\\shpfhdr1"));
        }
        this.doc.outputDebugLinebreak(outputStream);
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(DocWriter.getISOBytes("\\*\\shpinst"));
        Iterator iterator = this.properties.values().iterator();
        while (iterator.hasNext()) {
            RtfShapeProperty rtfShapeProperty = (RtfShapeProperty)iterator.next();
            rtfShapeProperty.setRtfDocument(this.doc);
            rtfShapeProperty.writeContent(outputStream);
        }
        if (!this.shapeText.equals("")) {
            outputStream.write(RtfBasicElement.OPEN_GROUP);
            outputStream.write(DocWriter.getISOBytes("\\shptxt"));
            outputStream.write(RtfBasicElement.DELIMITER);
            outputStream.write(DocWriter.getISOBytes(this.shapeText));
            outputStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        this.doc.outputDebugLinebreak(outputStream);
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
    }
}

