/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.field;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.field.RtfField;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTOCEntry
extends RtfField {
    private static final byte[] TEXT_HIDDEN_ON = DocWriter.getISOBytes("\\v");
    private static final byte[] TEXT_HIDDEN_OFF = DocWriter.getISOBytes("\\v0");
    private static final byte[] TOC_ENTRY_PAGE_NUMBER = DocWriter.getISOBytes("\\tc");
    private static final byte[] TOC_ENTRY_NO_PAGE_NUMBER = DocWriter.getISOBytes("\\tcn");
    private String entry = "";
    private boolean showPageNumber = true;

    public RtfTOCEntry(String string) {
        super((RtfDocument)null, new Font());
        if (string != null) {
            this.entry = string;
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(TEXT_HIDDEN_ON);
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        if (this.showPageNumber) {
            outputStream.write(TOC_ENTRY_PAGE_NUMBER);
        } else {
            outputStream.write(TOC_ENTRY_NO_PAGE_NUMBER);
        }
        outputStream.write(RtfBasicElement.DELIMITER);
        this.document.filterSpecialChar(outputStream, this.entry, true, false);
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        outputStream.write(TEXT_HIDDEN_OFF);
    }

    public void setShowPageNumber(boolean bl) {
        this.showPageNumber = bl;
    }

    protected void writeFieldInstContent(OutputStream outputStream) throws IOException {
    }

    protected void writeFieldResultContent(OutputStream outputStream) throws IOException {
    }
}

