/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.document.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class RtfByteArrayBuffer
extends OutputStream {
    private final List arrays = new ArrayList();
    private byte[] buffer;
    private int pos = 0;
    private int size = 0;

    public RtfByteArrayBuffer() {
        this(256);
    }

    public RtfByteArrayBuffer(int n) {
        int n2;
        if (n <= 0 || n > 0x40000000) {
            throw new IllegalArgumentException("bufferSize " + n);
        }
        for (n2 = 32; n2 < n; n2 <<= 1) {
        }
        this.buffer = new byte[n2];
    }

    public String toString() {
        return "RtfByteArrayBuffer: size=" + this.size() + " #arrays=" + this.arrays.size() + " pos=" + this.pos;
    }

    public void reset() {
        this.arrays.clear();
        this.pos = 0;
        this.size = 0;
    }

    public long size() {
        return this.size;
    }

    private void flushBuffer() {
        this.flushBuffer(1);
    }

    private void flushBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.pos == 0) {
            return;
        }
        if (this.pos == this.buffer.length) {
            this.arrays.add(this.buffer);
            int n2 = this.buffer.length;
            this.buffer = null;
            int n3 = Math.max(1, this.size >> 24) << 16;
            while (n2 < n3 && (n2 <<= 1) < n) {
            }
            this.buffer = new byte[n2];
        } else {
            byte[] byArray = new byte[this.pos];
            System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
            this.arrays.add(byArray);
        }
        this.pos = 0;
    }

    public void write(int n) {
        this.buffer[this.pos] = (byte)n;
        ++this.size;
        if (++this.pos == this.buffer.length) {
            this.flushBuffer();
        }
    }

    public void write(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length < this.buffer.length - this.pos) {
            System.arraycopy(byArray, 0, this.buffer, this.pos, byArray.length);
            this.pos += byArray.length;
            this.size += byArray.length;
            return;
        }
        this.writeLoop(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.writeLoop(byArray, n, n2);
    }

    private void writeLoop(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = this.buffer.length - this.pos;
            int n4 = n2 > n3 ? n3 : n2;
            System.arraycopy(byArray, n, this.buffer, this.pos, n4);
            n2 -= n4;
            n += n4;
            this.pos += n4;
            this.size += n4;
            if (this.pos != this.buffer.length) continue;
            this.flushBuffer(n2);
        }
    }

    public long write(InputStream inputStream) throws IOException {
        int n;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        long l = this.size;
        while ((n = inputStream.read(this.buffer, this.pos, this.buffer.length - this.pos)) >= 0) {
            this.pos += n;
            this.size += n;
            if (this.pos != this.buffer.length) continue;
            this.flushBuffer();
        }
        return (long)this.size - l;
    }

    public void append(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length == 0) {
            return;
        }
        if (byArray.length <= 8) {
            this.write(byArray, 0, byArray.length);
        } else if (byArray.length <= 16 && this.pos > 0 && this.buffer.length - this.pos > byArray.length) {
            this.write(byArray, 0, byArray.length);
        } else {
            this.flushBuffer();
            this.arrays.add(byArray);
            this.size += byArray.length;
        }
    }

    public void append(byte[][] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.append(byArray[i]);
        }
    }

    public byte[][] toByteArrayArray() {
        this.flushBuffer();
        return (byte[][])this.arrays.toArray((T[])new byte[this.arrays.size()][]);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        int n2 = this.arrays.size();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = (byte[])this.arrays.get(i);
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        if (this.pos > 0) {
            System.arraycopy(this.buffer, 0, byArray, n, this.pos);
        }
        return byArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        int n = this.arrays.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])this.arrays.get(i);
            outputStream.write(byArray);
        }
        if (this.pos > 0) {
            outputStream.write(this.buffer, 0, this.pos);
        }
    }
}

