/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.document;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.document.RtfInfoElement;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfInfoGroup
extends RtfElement {
    private static final byte[] INFO_GROUP = DocWriter.getISOBytes("\\info");
    private static final byte[] INFO_PASSWORD = DocWriter.getISOBytes("\\*\\password");
    ArrayList infoElements = new ArrayList();

    public RtfInfoGroup(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public void add(RtfInfoElement rtfInfoElement) {
        this.infoElements.add(rtfInfoElement);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(RtfBasicElement.OPEN_GROUP);
        outputStream.write(INFO_GROUP);
        for (int i = 0; i < this.infoElements.size(); ++i) {
            RtfInfoElement rtfInfoElement = (RtfInfoElement)this.infoElements.get(i);
            rtfInfoElement.writeContent(outputStream);
        }
        if (this.document.getDocumentSettings().isDocumentProtected()) {
            outputStream.write(RtfBasicElement.OPEN_GROUP);
            outputStream.write(INFO_PASSWORD);
            outputStream.write(RtfBasicElement.DELIMITER);
            outputStream.write(this.document.getDocumentSettings().getProtectionHashBytes());
            outputStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        outputStream.write(RtfBasicElement.CLOSE_GROUP);
        this.document.outputDebugLinebreak(outputStream);
    }
}

