/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.document;

import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.HeaderFooter;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfCodePage;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.document.RtfGenerator;
import com.fr.third.com.lowagie.text.rtf.document.RtfInfoElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfInfoGroup;
import com.fr.third.com.lowagie.text.rtf.document.RtfPageSetting;
import com.fr.third.com.lowagie.text.rtf.document.RtfProtectionSetting;
import com.fr.third.com.lowagie.text.rtf.document.output.RtfNilOutputStream;
import com.fr.third.com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.fr.third.com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.fr.third.com.lowagie.text.rtf.list.RtfList;
import com.fr.third.com.lowagie.text.rtf.list.RtfListTable;
import com.fr.third.com.lowagie.text.rtf.style.RtfColor;
import com.fr.third.com.lowagie.text.rtf.style.RtfColorList;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfFontList;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.fr.third.com.lowagie.text.rtf.style.RtfStylesheetList;
import java.io.IOException;
import java.io.OutputStream;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] TITLE_PAGE = DocWriter.getISOBytes("\\titlepg");
    private static final byte[] FACING_PAGES = DocWriter.getISOBytes("\\facingp");
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfListTable listTable = null;
    private RtfStylesheetList stylesheetList = null;
    private RtfGenerator generator = null;
    private RtfInfoGroup infoGroup = null;
    private RtfProtectionSetting protectionSetting = null;
    private RtfPageSetting pageSetting = null;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;

    protected RtfDocumentHeader(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.stylesheetList = new RtfStylesheetList(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.protectionSetting = new RtfProtectionSetting(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
        this.generator = new RtfGenerator(this.document);
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        try {
            this.writeSectionDefinition(new RtfNilOutputStream());
            this.codePage.writeDefinition(outputStream);
            this.fontList.writeDefinition(outputStream);
            this.colorList.writeDefinition(outputStream);
            this.stylesheetList.writeDefinition(outputStream);
            this.listTable.writeDefinition(outputStream);
            this.generator.writeContent(outputStream);
            this.infoGroup.writeContent(outputStream);
            this.protectionSetting.writeDefinition(outputStream);
            this.pageSetting.writeDefinition(outputStream);
            this.writeSectionDefinition(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeSectionDefinition(OutputStream outputStream) {
        try {
            RtfHeaderFooterGroup rtfHeaderFooterGroup = this.convertHeaderFooter(this.header, 1);
            RtfHeaderFooterGroup rtfHeaderFooterGroup2 = this.convertHeaderFooter(this.footer, 2);
            if (rtfHeaderFooterGroup.hasTitlePage() || rtfHeaderFooterGroup2.hasTitlePage()) {
                outputStream.write(TITLE_PAGE);
                rtfHeaderFooterGroup.setHasTitlePage();
                rtfHeaderFooterGroup2.setHasTitlePage();
            }
            if (rtfHeaderFooterGroup.hasFacingPages() || rtfHeaderFooterGroup2.hasFacingPages()) {
                outputStream.write(FACING_PAGES);
                rtfHeaderFooterGroup.setHasFacingPages();
                rtfHeaderFooterGroup2.setHasFacingPages();
            }
            rtfHeaderFooterGroup2.writeContent(outputStream);
            rtfHeaderFooterGroup.writeContent(outputStream);
            this.pageSetting.writeSectionDefinition(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getFontNumber(RtfFont rtfFont) {
        return this.fontList.getFontNumber(rtfFont);
    }

    public int getColorNumber(RtfColor rtfColor) {
        return this.colorList.getColorNumber(rtfColor);
    }

    public int getListNumber(RtfList rtfList) {
        return this.listTable.getListNumber(rtfList);
    }

    public RtfParagraphStyle getRtfParagraphStyle(String string) {
        return this.stylesheetList.getRtfParagraphStyle(string);
    }

    public void freeListNumber(RtfList rtfList) {
        this.listTable.freeListNumber(rtfList);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.stylesheetList.registerParagraphStyle(rtfParagraphStyle);
    }

    private RtfHeaderFooterGroup convertHeaderFooter(HeaderFooter headerFooter, int n) {
        if (headerFooter != null) {
            if (headerFooter instanceof RtfHeaderFooterGroup) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)headerFooter, n);
            }
            if (headerFooter instanceof RtfHeaderFooter) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)headerFooter, n);
            }
            return new RtfHeaderFooterGroup(this.document, headerFooter, n);
        }
        return new RtfHeaderFooterGroup(this.document, n);
    }

    public RtfListTable getListTable() {
        return this.listTable;
    }
}

