/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf;

import com.fr.third.com.lowagie.text.pdf.ByteBuffer;
import com.fr.third.com.lowagie.text.pdf.PRTokeniser;
import com.fr.third.com.lowagie.text.pdf.PdfObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class PdfName
extends PdfObject
implements Comparable {
    public static final PdfName _3D = new PdfName("3D");
    public static final PdfName A = new PdfName("A");
    public static final PdfName AA = new PdfName("AA");
    public static final PdfName ABSOLUTECOLORIMETRIC = new PdfName("AbsoluteColorimetric");
    public static final PdfName AC = new PdfName("AC");
    public static final PdfName ACROFORM = new PdfName("AcroForm");
    public static final PdfName ACTION = new PdfName("Action");
    public static final PdfName ACTIVATION = new PdfName("Activation");
    public static final PdfName ADBE = new PdfName("ADBE");
    public static final PdfName ACTUALTEXT = new PdfName("ActualText");
    public static final PdfName ADBE_PKCS7_DETACHED = new PdfName("adbe.pkcs7.detached");
    public static final PdfName ADBE_PKCS7_S4 = new PdfName("adbe.pkcs7.s4");
    public static final PdfName ADBE_PKCS7_S5 = new PdfName("adbe.pkcs7.s5");
    public static final PdfName ADBE_PKCS7_SHA1 = new PdfName("adbe.pkcs7.sha1");
    public static final PdfName ADBE_X509_RSA_SHA1 = new PdfName("adbe.x509.rsa_sha1");
    public static final PdfName ADOBE_PPKLITE = new PdfName("Adobe.PPKLite");
    public static final PdfName ADOBE_PPKMS = new PdfName("Adobe.PPKMS");
    public static final PdfName AESV2 = new PdfName("AESV2");
    public static final PdfName AIS = new PdfName("AIS");
    public static final PdfName ALLPAGES = new PdfName("AllPages");
    public static final PdfName ALT = new PdfName("Alt");
    public static final PdfName ALTERNATE = new PdfName("Alternate");
    public static final PdfName ANIMATION = new PdfName("Animation");
    public static final PdfName ANNOT = new PdfName("Annot");
    public static final PdfName ANNOTS = new PdfName("Annots");
    public static final PdfName ANTIALIAS = new PdfName("AntiAlias");
    public static final PdfName AP = new PdfName("AP");
    public static final PdfName APPDEFAULT = new PdfName("AppDefault");
    public static final PdfName ART = new PdfName("Art");
    public static final PdfName ARTBOX = new PdfName("ArtBox");
    public static final PdfName ASCENT = new PdfName("Ascent");
    public static final PdfName AS = new PdfName("AS");
    public static final PdfName ASCII85DECODE = new PdfName("ASCII85Decode");
    public static final PdfName ASCIIHEXDECODE = new PdfName("ASCIIHexDecode");
    public static final PdfName ASSET = new PdfName("Asset");
    public static final PdfName ASSETS = new PdfName("Assets");
    public static final PdfName AUTHEVENT = new PdfName("AuthEvent");
    public static final PdfName AUTHOR = new PdfName("Author");
    public static final PdfName B = new PdfName("B");
    public static final PdfName BACKGROUND = new PdfName("Background");
    public static final PdfName BASEENCODING = new PdfName("BaseEncoding");
    public static final PdfName BASEFONT = new PdfName("BaseFont");
    public static final PdfName BASEVERSION = new PdfName("BaseVersion");
    public static final PdfName BBOX = new PdfName("BBox");
    public static final PdfName BC = new PdfName("BC");
    public static final PdfName BG = new PdfName("BG");
    public static final PdfName BIBENTRY = new PdfName("BibEntry");
    public static final PdfName BIGFIVE = new PdfName("BigFive");
    public static final PdfName BINDING = new PdfName("Binding");
    public static final PdfName BINDINGMATERIALNAME = new PdfName("BindingMaterialName");
    public static final PdfName BITSPERCOMPONENT = new PdfName("BitsPerComponent");
    public static final PdfName BITSPERSAMPLE = new PdfName("BitsPerSample");
    public static final PdfName BL = new PdfName("Bl");
    public static final PdfName BLACKIS1 = new PdfName("BlackIs1");
    public static final PdfName BLACKPOINT = new PdfName("BlackPoint");
    public static final PdfName BLOCKQUOTE = new PdfName("BlockQuote");
    public static final PdfName BLEEDBOX = new PdfName("BleedBox");
    public static final PdfName BLINDS = new PdfName("Blinds");
    public static final PdfName BM = new PdfName("BM");
    public static final PdfName BORDER = new PdfName("Border");
    public static final PdfName BOUNDS = new PdfName("Bounds");
    public static final PdfName BOX = new PdfName("Box");
    public static final PdfName BS = new PdfName("BS");
    public static final PdfName BTN = new PdfName("Btn");
    public static final PdfName BYTERANGE = new PdfName("ByteRange");
    public static final PdfName C = new PdfName("C");
    public static final PdfName C0 = new PdfName("C0");
    public static final PdfName C1 = new PdfName("C1");
    public static final PdfName CA = new PdfName("CA");
    public static final PdfName ca = new PdfName("ca");
    public static final PdfName CALGRAY = new PdfName("CalGray");
    public static final PdfName CALRGB = new PdfName("CalRGB");
    public static final PdfName CAPHEIGHT = new PdfName("CapHeight");
    public static final PdfName CAPTION = new PdfName("Caption");
    public static final PdfName CATALOG = new PdfName("Catalog");
    public static final PdfName CATEGORY = new PdfName("Category");
    public static final PdfName CCITTFAXDECODE = new PdfName("CCITTFaxDecode");
    public static final PdfName CENTER = new PdfName("Center");
    public static final PdfName CENTERWINDOW = new PdfName("CenterWindow");
    public static final PdfName CERT = new PdfName("Cert");
    public static final PdfName CF = new PdfName("CF");
    public static final PdfName CFM = new PdfName("CFM");
    public static final PdfName CH = new PdfName("Ch");
    public static final PdfName CHARPROCS = new PdfName("CharProcs");
    public static final PdfName CI = new PdfName("CI");
    public static final PdfName CIDFONTTYPE0 = new PdfName("CIDFontType0");
    public static final PdfName CIDFONTTYPE2 = new PdfName("CIDFontType2");
    public static final PdfName CIDSET = new PdfName("CIDSet");
    public static final PdfName CIDSYSTEMINFO = new PdfName("CIDSystemInfo");
    public static final PdfName CIDTOGIDMAP = new PdfName("CIDToGIDMap");
    public static final PdfName CIRCLE = new PdfName("Circle");
    public static final PdfName CMD = new PdfName("CMD");
    public static final PdfName CO = new PdfName("CO");
    public static final PdfName CODE = new PdfName("Code");
    public static final PdfName COLORS = new PdfName("Colors");
    public static final PdfName COLORSPACE = new PdfName("ColorSpace");
    public static final PdfName COLLECTION = new PdfName("Collection");
    public static final PdfName COLLECTIONFIELD = new PdfName("CollectionField");
    public static final PdfName COLLECTIONITEM = new PdfName("CollectionItem");
    public static final PdfName COLLECTIONSCHEMA = new PdfName("CollectionSchema");
    public static final PdfName COLLECTIONSORT = new PdfName("CollectionSort");
    public static final PdfName COLLECTIONSUBITEM = new PdfName("CollectionSubitem");
    public static final PdfName COLUMNS = new PdfName("Columns");
    public static final PdfName CONDITION = new PdfName("Condition");
    public static final PdfName CONFIGURATION = new PdfName("Configuration");
    public static final PdfName CONFIGURATIONS = new PdfName("Configurations");
    public static final PdfName CONTACTINFO = new PdfName("ContactInfo");
    public static final PdfName CONTENT = new PdfName("Content");
    public static final PdfName CONTENTS = new PdfName("Contents");
    public static final PdfName COORDS = new PdfName("Coords");
    public static final PdfName COUNT = new PdfName("Count");
    public static final PdfName COURIER = new PdfName("Courier");
    public static final PdfName COURIER_BOLD = new PdfName("Courier-Bold");
    public static final PdfName COURIER_OBLIQUE = new PdfName("Courier-Oblique");
    public static final PdfName COURIER_BOLDOBLIQUE = new PdfName("Courier-BoldOblique");
    public static final PdfName CREATIONDATE = new PdfName("CreationDate");
    public static final PdfName CREATOR = new PdfName("Creator");
    public static final PdfName CREATORINFO = new PdfName("CreatorInfo");
    public static final PdfName CROPBOX = new PdfName("CropBox");
    public static final PdfName CRYPT = new PdfName("Crypt");
    public static final PdfName CS = new PdfName("CS");
    public static final PdfName CUEPOINT = new PdfName("CuePoint");
    public static final PdfName CUEPOINTS = new PdfName("CuePoints");
    public static final PdfName D = new PdfName("D");
    public static final PdfName DA = new PdfName("DA");
    public static final PdfName DATA = new PdfName("Data");
    public static final PdfName DC = new PdfName("DC");
    public static final PdfName DCTDECODE = new PdfName("DCTDecode");
    public static final PdfName DEACTIVATION = new PdfName("Deactivation");
    public static final PdfName DECODE = new PdfName("Decode");
    public static final PdfName DECODEPARMS = new PdfName("DecodeParms");
    public static final PdfName DEFAULT = new PdfName("Default");
    public static final PdfName DEFAULTCRYPTFILTER = new PdfName("DefaultCryptFilter");
    public static final PdfName DEFAULTCMYK = new PdfName("DefaultCMYK");
    public static final PdfName DEFAULTGRAY = new PdfName("DefaultGray");
    public static final PdfName DEFAULTRGB = new PdfName("DefaultRGB");
    public static final PdfName DESC = new PdfName("Desc");
    public static final PdfName DESCENDANTFONTS = new PdfName("DescendantFonts");
    public static final PdfName DESCENT = new PdfName("Descent");
    public static final PdfName DEST = new PdfName("Dest");
    public static final PdfName DESTOUTPUTPROFILE = new PdfName("DestOutputProfile");
    public static final PdfName DESTS = new PdfName("Dests");
    public static final PdfName DEVICEGRAY = new PdfName("DeviceGray");
    public static final PdfName DEVICERGB = new PdfName("DeviceRGB");
    public static final PdfName DEVICECMYK = new PdfName("DeviceCMYK");
    public static final PdfName DI = new PdfName("Di");
    public static final PdfName DIFFERENCES = new PdfName("Differences");
    public static final PdfName DISSOLVE = new PdfName("Dissolve");
    public static final PdfName DIRECTION = new PdfName("Direction");
    public static final PdfName DISPLAYDOCTITLE = new PdfName("DisplayDocTitle");
    public static final PdfName DIV = new PdfName("Div");
    public static final PdfName DM = new PdfName("Dm");
    public static final PdfName DOCMDP = new PdfName("DocMDP");
    public static final PdfName DOCOPEN = new PdfName("DocOpen");
    public static final PdfName DOCUMENT = new PdfName("Document");
    public static final PdfName DOMAIN = new PdfName("Domain");
    public static final PdfName DP = new PdfName("DP");
    public static final PdfName DR = new PdfName("DR");
    public static final PdfName DS = new PdfName("DS");
    public static final PdfName DUR = new PdfName("Dur");
    public static final PdfName DUPLEX = new PdfName("Duplex");
    public static final PdfName DUPLEXFLIPSHORTEDGE = new PdfName("DuplexFlipShortEdge");
    public static final PdfName DUPLEXFLIPLONGEDGE = new PdfName("DuplexFlipLongEdge");
    public static final PdfName DV = new PdfName("DV");
    public static final PdfName DW = new PdfName("DW");
    public static final PdfName E = new PdfName("E");
    public static final PdfName EARLYCHANGE = new PdfName("EarlyChange");
    public static final PdfName EF = new PdfName("EF");
    public static final PdfName EFF = new PdfName("EFF");
    public static final PdfName EFOPEN = new PdfName("EFOpen");
    public static final PdfName EMBEDDED = new PdfName("Embedded");
    public static final PdfName EMBEDDEDFILE = new PdfName("EmbeddedFile");
    public static final PdfName EMBEDDEDFILES = new PdfName("EmbeddedFiles");
    public static final PdfName ENCODE = new PdfName("Encode");
    public static final PdfName ENCODEDBYTEALIGN = new PdfName("EncodedByteAlign");
    public static final PdfName ENCODING = new PdfName("Encoding");
    public static final PdfName ENCRYPT = new PdfName("Encrypt");
    public static final PdfName ENCRYPTMETADATA = new PdfName("EncryptMetadata");
    public static final PdfName ENDOFBLOCK = new PdfName("EndOfBlock");
    public static final PdfName ENDOFLINE = new PdfName("EndOfLine");
    public static final PdfName EXTEND = new PdfName("Extend");
    public static final PdfName EXTENSIONS = new PdfName("Extensions");
    public static final PdfName EXTENSIONLEVEL = new PdfName("ExtensionLevel");
    public static final PdfName EXTGSTATE = new PdfName("ExtGState");
    public static final PdfName EXPORT = new PdfName("Export");
    public static final PdfName EXPORTSTATE = new PdfName("ExportState");
    public static final PdfName EVENT = new PdfName("Event");
    public static final PdfName F = new PdfName("F");
    public static final PdfName FAR = new PdfName("Far");
    public static final PdfName FB = new PdfName("FB");
    public static final PdfName FDECODEPARMS = new PdfName("FDecodeParms");
    public static final PdfName FDF = new PdfName("FDF");
    public static final PdfName FF = new PdfName("Ff");
    public static final PdfName FFILTER = new PdfName("FFilter");
    public static final PdfName FIELDS = new PdfName("Fields");
    public static final PdfName FIGURE = new PdfName("Figure");
    public static final PdfName FILEATTACHMENT = new PdfName("FileAttachment");
    public static final PdfName FILESPEC = new PdfName("Filespec");
    public static final PdfName FILTER = new PdfName("Filter");
    public static final PdfName FIRST = new PdfName("First");
    public static final PdfName FIRSTCHAR = new PdfName("FirstChar");
    public static final PdfName FIRSTPAGE = new PdfName("FirstPage");
    public static final PdfName FIT = new PdfName("Fit");
    public static final PdfName FITH = new PdfName("FitH");
    public static final PdfName FITV = new PdfName("FitV");
    public static final PdfName FITR = new PdfName("FitR");
    public static final PdfName FITB = new PdfName("FitB");
    public static final PdfName FITBH = new PdfName("FitBH");
    public static final PdfName FITBV = new PdfName("FitBV");
    public static final PdfName FITWINDOW = new PdfName("FitWindow");
    public static final PdfName FLAGS = new PdfName("Flags");
    public static final PdfName FLASH = new PdfName("Flash");
    public static final PdfName FLASHVARS = new PdfName("FlashVars");
    public static final PdfName FLATEDECODE = new PdfName("FlateDecode");
    public static final PdfName FO = new PdfName("Fo");
    public static final PdfName FONT = new PdfName("Font");
    public static final PdfName FONTBBOX = new PdfName("FontBBox");
    public static final PdfName FONTDESCRIPTOR = new PdfName("FontDescriptor");
    public static final PdfName FONTFILE = new PdfName("FontFile");
    public static final PdfName FONTFILE2 = new PdfName("FontFile2");
    public static final PdfName FONTFILE3 = new PdfName("FontFile3");
    public static final PdfName FONTMATRIX = new PdfName("FontMatrix");
    public static final PdfName FONTNAME = new PdfName("FontName");
    public static final PdfName FOREGROUND = new PdfName("Foreground");
    public static final PdfName FORM = new PdfName("Form");
    public static final PdfName FORMTYPE = new PdfName("FormType");
    public static final PdfName FORMULA = new PdfName("Formula");
    public static final PdfName FREETEXT = new PdfName("FreeText");
    public static final PdfName FRM = new PdfName("FRM");
    public static final PdfName FS = new PdfName("FS");
    public static final PdfName FT = new PdfName("FT");
    public static final PdfName FULLSCREEN = new PdfName("FullScreen");
    public static final PdfName FUNCTION = new PdfName("Function");
    public static final PdfName FUNCTIONS = new PdfName("Functions");
    public static final PdfName FUNCTIONTYPE = new PdfName("FunctionType");
    public static final PdfName GAMMA = new PdfName("Gamma");
    public static final PdfName GBK = new PdfName("GBK");
    public static final PdfName GLITTER = new PdfName("Glitter");
    public static final PdfName GOTO = new PdfName("GoTo");
    public static final PdfName GOTOE = new PdfName("GoToE");
    public static final PdfName GOTOR = new PdfName("GoToR");
    public static final PdfName GROUP = new PdfName("Group");
    public static final PdfName GTS_PDFA1 = new PdfName("GTS_PDFA1");
    public static final PdfName GTS_PDFX = new PdfName("GTS_PDFX");
    public static final PdfName GTS_PDFXVERSION = new PdfName("GTS_PDFXVersion");
    public static final PdfName H = new PdfName("H");
    public static final PdfName H1 = new PdfName("H1");
    public static final PdfName H2 = new PdfName("H2");
    public static final PdfName H3 = new PdfName("H3");
    public static final PdfName H4 = new PdfName("H4");
    public static final PdfName H5 = new PdfName("H5");
    public static final PdfName H6 = new PdfName("H6");
    public static final PdfName HALIGN = new PdfName("HAlign");
    public static final PdfName HEIGHT = new PdfName("Height");
    public static final PdfName HELV = new PdfName("Helv");
    public static final PdfName HELVETICA = new PdfName("Helvetica");
    public static final PdfName HELVETICA_BOLD = new PdfName("Helvetica-Bold");
    public static final PdfName HELVETICA_OBLIQUE = new PdfName("Helvetica-Oblique");
    public static final PdfName HELVETICA_BOLDOBLIQUE = new PdfName("Helvetica-BoldOblique");
    public static final PdfName HID = new PdfName("Hid");
    public static final PdfName HIDE = new PdfName("Hide");
    public static final PdfName HIDEMENUBAR = new PdfName("HideMenubar");
    public static final PdfName HIDETOOLBAR = new PdfName("HideToolbar");
    public static final PdfName HIDEWINDOWUI = new PdfName("HideWindowUI");
    public static final PdfName HIGHLIGHT = new PdfName("Highlight");
    public static final PdfName HOFFSET = new PdfName("HOffset");
    public static final PdfName I = new PdfName("I");
    public static final PdfName ICCBASED = new PdfName("ICCBased");
    public static final PdfName ID = new PdfName("ID");
    public static final PdfName IDENTITY = new PdfName("Identity");
    public static final PdfName IF = new PdfName("IF");
    public static final PdfName IMAGE = new PdfName("Image");
    public static final PdfName IMAGEB = new PdfName("ImageB");
    public static final PdfName IMAGEC = new PdfName("ImageC");
    public static final PdfName IMAGEI = new PdfName("ImageI");
    public static final PdfName IMAGEMASK = new PdfName("ImageMask");
    public static final PdfName INDEX = new PdfName("Index");
    public static final PdfName INDEXED = new PdfName("Indexed");
    public static final PdfName INFO = new PdfName("Info");
    public static final PdfName INK = new PdfName("Ink");
    public static final PdfName INKLIST = new PdfName("InkList");
    public static final PdfName INSTANCES = new PdfName("Instances");
    public static final PdfName IMPORTDATA = new PdfName("ImportData");
    public static final PdfName INTENT = new PdfName("Intent");
    public static final PdfName INTERPOLATE = new PdfName("Interpolate");
    public static final PdfName ISMAP = new PdfName("IsMap");
    public static final PdfName IRT = new PdfName("IRT");
    public static final PdfName ITALICANGLE = new PdfName("ItalicAngle");
    public static final PdfName ITXT = new PdfName("ITXT");
    public static final PdfName IX = new PdfName("IX");
    public static final PdfName JAVASCRIPT = new PdfName("JavaScript");
    public static final PdfName JBIG2DECODE = new PdfName("JBIG2Decode");
    public static final PdfName JBIG2GLOBALS = new PdfName("JBIG2Globals");
    public static final PdfName JPXDECODE = new PdfName("JPXDecode");
    public static final PdfName JS = new PdfName("JS");
    public static final PdfName K = new PdfName("K");
    public static final PdfName KEYWORDS = new PdfName("Keywords");
    public static final PdfName KIDS = new PdfName("Kids");
    public static final PdfName L = new PdfName("L");
    public static final PdfName L2R = new PdfName("L2R");
    public static final PdfName LANG = new PdfName("Lang");
    public static final PdfName LANGUAGE = new PdfName("Language");
    public static final PdfName LAST = new PdfName("Last");
    public static final PdfName LASTCHAR = new PdfName("LastChar");
    public static final PdfName LASTPAGE = new PdfName("LastPage");
    public static final PdfName LAUNCH = new PdfName("Launch");
    public static final PdfName LBL = new PdfName("Lbl");
    public static final PdfName LBODY = new PdfName("LBody");
    public static final PdfName LENGTH = new PdfName("Length");
    public static final PdfName LENGTH1 = new PdfName("Length1");
    public static final PdfName LI = new PdfName("LI");
    public static final PdfName LIMITS = new PdfName("Limits");
    public static final PdfName LINE = new PdfName("Line");
    public static final PdfName LINEAR = new PdfName("Linear");
    public static final PdfName LINK = new PdfName("Link");
    public static final PdfName LISTMODE = new PdfName("ListMode");
    public static final PdfName LOCATION = new PdfName("Location");
    public static final PdfName LOCK = new PdfName("Lock");
    public static final PdfName LOCKED = new PdfName("Locked");
    public static final PdfName LZWDECODE = new PdfName("LZWDecode");
    public static final PdfName M = new PdfName("M");
    public static final PdfName MATERIAL = new PdfName("Material");
    public static final PdfName MATRIX = new PdfName("Matrix");
    public static final PdfName MAC_EXPERT_ENCODING = new PdfName("MacExpertEncoding");
    public static final PdfName MAC_ROMAN_ENCODING = new PdfName("MacRomanEncoding");
    public static final PdfName MARKED = new PdfName("Marked");
    public static final PdfName MARKINFO = new PdfName("MarkInfo");
    public static final PdfName MASK = new PdfName("Mask");
    public static final PdfName MAX_LOWER_CASE = new PdfName("max");
    public static final PdfName MAX_CAMEL_CASE = new PdfName("Max");
    public static final PdfName MAXLEN = new PdfName("MaxLen");
    public static final PdfName MEDIABOX = new PdfName("MediaBox");
    public static final PdfName MCID = new PdfName("MCID");
    public static final PdfName MCR = new PdfName("MCR");
    public static final PdfName METADATA = new PdfName("Metadata");
    public static final PdfName MIN_LOWER_CASE = new PdfName("min");
    public static final PdfName MIN_CAMEL_CASE = new PdfName("Min");
    public static final PdfName MK = new PdfName("MK");
    public static final PdfName MMTYPE1 = new PdfName("MMType1");
    public static final PdfName MODDATE = new PdfName("ModDate");
    public static final PdfName N = new PdfName("N");
    public static final PdfName N0 = new PdfName("n0");
    public static final PdfName N1 = new PdfName("n1");
    public static final PdfName N2 = new PdfName("n2");
    public static final PdfName N3 = new PdfName("n3");
    public static final PdfName N4 = new PdfName("n4");
    public static final PdfName NAME = new PdfName("Name");
    public static final PdfName NAMED = new PdfName("Named");
    public static final PdfName NAMES = new PdfName("Names");
    public static final PdfName NAVIGATION = new PdfName("Navigation");
    public static final PdfName NAVIGATIONPANE = new PdfName("NavigationPane");
    public static final PdfName NEAR = new PdfName("Near");
    public static final PdfName NEEDAPPEARANCES = new PdfName("NeedAppearances");
    public static final PdfName NEWWINDOW = new PdfName("NewWindow");
    public static final PdfName NEXT = new PdfName("Next");
    public static final PdfName NEXTPAGE = new PdfName("NextPage");
    public static final PdfName NM = new PdfName("NM");
    public static final PdfName NONE = new PdfName("None");
    public static final PdfName NONFULLSCREENPAGEMODE = new PdfName("NonFullScreenPageMode");
    public static final PdfName NONSTRUCT = new PdfName("NonStruct");
    public static final PdfName NOTE = new PdfName("Note");
    public static final PdfName NUMCOPIES = new PdfName("NumCopies");
    public static final PdfName NUMS = new PdfName("Nums");
    public static final PdfName O = new PdfName("O");
    public static final PdfName OBJ = new PdfName("Obj");
    public static final PdfName OBJR = new PdfName("OBJR");
    public static final PdfName OBJSTM = new PdfName("ObjStm");
    public static final PdfName OC = new PdfName("OC");
    public static final PdfName OCG = new PdfName("OCG");
    public static final PdfName OCGS = new PdfName("OCGs");
    public static final PdfName OCMD = new PdfName("OCMD");
    public static final PdfName OCPROPERTIES = new PdfName("OCProperties");
    public static final PdfName Off = new PdfName("Off");
    public static final PdfName OFF = new PdfName("OFF");
    public static final PdfName ON = new PdfName("ON");
    public static final PdfName ONECOLUMN = new PdfName("OneColumn");
    public static final PdfName OPEN = new PdfName("Open");
    public static final PdfName OPENACTION = new PdfName("OpenAction");
    public static final PdfName OP = new PdfName("OP");
    public static final PdfName op = new PdfName("op");
    public static final PdfName OPM = new PdfName("OPM");
    public static final PdfName OPT = new PdfName("Opt");
    public static final PdfName ORDER = new PdfName("Order");
    public static final PdfName ORDERING = new PdfName("Ordering");
    public static final PdfName OSCILLATING = new PdfName("Oscillating");
    public static final PdfName OUTLINES = new PdfName("Outlines");
    public static final PdfName OUTPUTCONDITION = new PdfName("OutputCondition");
    public static final PdfName OUTPUTCONDITIONIDENTIFIER = new PdfName("OutputConditionIdentifier");
    public static final PdfName OUTPUTINTENT = new PdfName("OutputIntent");
    public static final PdfName OUTPUTINTENTS = new PdfName("OutputIntents");
    public static final PdfName P = new PdfName("P");
    public static final PdfName PAGE = new PdfName("Page");
    public static final PdfName PAGELABELS = new PdfName("PageLabels");
    public static final PdfName PAGELAYOUT = new PdfName("PageLayout");
    public static final PdfName PAGEMODE = new PdfName("PageMode");
    public static final PdfName PAGES = new PdfName("Pages");
    public static final PdfName PAINTTYPE = new PdfName("PaintType");
    public static final PdfName PANOSE = new PdfName("Panose");
    public static final PdfName PARAMS = new PdfName("Params");
    public static final PdfName PARENT = new PdfName("Parent");
    public static final PdfName PARENTTREE = new PdfName("ParentTree");
    public static final PdfName PARENTTREENEXTKEY = new PdfName("ParentTreeNextKey");
    public static final PdfName PART = new PdfName("Part");
    public static final PdfName PASSCONTEXTCLICK = new PdfName("PassContextClick");
    public static final PdfName PATTERN = new PdfName("Pattern");
    public static final PdfName PATTERNTYPE = new PdfName("PatternType");
    public static final PdfName PC = new PdfName("PC");
    public static final PdfName PDF = new PdfName("PDF");
    public static final PdfName PDFDOCENCODING = new PdfName("PDFDocEncoding");
    public static final PdfName PERCEPTUAL = new PdfName("Perceptual");
    public static final PdfName PERMS = new PdfName("Perms");
    public static final PdfName PG = new PdfName("Pg");
    public static final PdfName PI = new PdfName("PI");
    public static final PdfName PICKTRAYBYPDFSIZE = new PdfName("PickTrayByPDFSize");
    public static final PdfName PLAYCOUNT = new PdfName("PlayCount");
    public static final PdfName PO = new PdfName("PO");
    public static final PdfName POPUP = new PdfName("Popup");
    public static final PdfName POSITION = new PdfName("Position");
    public static final PdfName PREDICTOR = new PdfName("Predictor");
    public static final PdfName PREFERRED = new PdfName("Preferred");
    public static final PdfName PRESENTATION = new PdfName("Presentation");
    public static final PdfName PRESERVERB = new PdfName("PreserveRB");
    public static final PdfName PREV = new PdfName("Prev");
    public static final PdfName PREVPAGE = new PdfName("PrevPage");
    public static final PdfName PRINT = new PdfName("Print");
    public static final PdfName PRINTAREA = new PdfName("PrintArea");
    public static final PdfName PRINTCLIP = new PdfName("PrintClip");
    public static final PdfName PRINTPAGERANGE = new PdfName("PrintPageRange");
    public static final PdfName PRINTSCALING = new PdfName("PrintScaling");
    public static final PdfName PRINTSTATE = new PdfName("PrintState");
    public static final PdfName PRIVATE = new PdfName("Private");
    public static final PdfName PROCSET = new PdfName("ProcSet");
    public static final PdfName PRODUCER = new PdfName("Producer");
    public static final PdfName PROPERTIES = new PdfName("Properties");
    public static final PdfName PS = new PdfName("PS");
    public static final PdfName PUBSEC = new PdfName("Adobe.PubSec");
    public static final PdfName PV = new PdfName("PV");
    public static final PdfName Q = new PdfName("Q");
    public static final PdfName QUADPOINTS = new PdfName("QuadPoints");
    public static final PdfName QUOTE = new PdfName("Quote");
    public static final PdfName R = new PdfName("R");
    public static final PdfName R2L = new PdfName("R2L");
    public static final PdfName RANGE = new PdfName("Range");
    public static final PdfName RC = new PdfName("RC");
    public static final PdfName RBGROUPS = new PdfName("RBGroups");
    public static final PdfName REASON = new PdfName("Reason");
    public static final PdfName RECIPIENTS = new PdfName("Recipients");
    public static final PdfName RECT = new PdfName("Rect");
    public static final PdfName REFERENCE = new PdfName("Reference");
    public static final PdfName REGISTRY = new PdfName("Registry");
    public static final PdfName REGISTRYNAME = new PdfName("RegistryName");
    public static final PdfName RELATIVECOLORIMETRIC = new PdfName("RelativeColorimetric");
    public static final PdfName RENDITION = new PdfName("Rendition");
    public static final PdfName RESETFORM = new PdfName("ResetForm");
    public static final PdfName RESOURCES = new PdfName("Resources");
    public static final PdfName RI = new PdfName("RI");
    public static final PdfName RICHMEDIA = new PdfName("RichMedia");
    public static final PdfName RICHMEDIAACTIVATION = new PdfName("RichMediaActivation");
    public static final PdfName RICHMEDIAANIMATION = new PdfName("RichMediaAnimation");
    public static final PdfName RICHMEDIACOMMAND = new PdfName("RichMediaCommand");
    public static final PdfName RICHMEDIACONFIGURATION = new PdfName("RichMediaConfiguration");
    public static final PdfName RICHMEDIACONTENT = new PdfName("RichMediaContent");
    public static final PdfName RICHMEDIADEACTIVATION = new PdfName("RichMediaDeactivation");
    public static final PdfName RICHMEDIAEXECUTE = new PdfName("RichMediaExecute");
    public static final PdfName RICHMEDIAINSTANCE = new PdfName("RichMediaInstance");
    public static final PdfName RICHMEDIAPARAMS = new PdfName("RichMediaParams");
    public static final PdfName RICHMEDIAPOSITION = new PdfName("RichMediaPosition");
    public static final PdfName RICHMEDIAPRESENTATION = new PdfName("RichMediaPresentation");
    public static final PdfName RICHMEDIASETTINGS = new PdfName("RichMediaSettings");
    public static final PdfName RICHMEDIAWINDOW = new PdfName("RichMediaWindow");
    public static final PdfName ROLEMAP = new PdfName("RoleMap");
    public static final PdfName ROOT = new PdfName("Root");
    public static final PdfName ROTATE = new PdfName("Rotate");
    public static final PdfName ROWS = new PdfName("Rows");
    public static final PdfName RUBY = new PdfName("Ruby");
    public static final PdfName RUNLENGTHDECODE = new PdfName("RunLengthDecode");
    public static final PdfName RV = new PdfName("RV");
    public static final PdfName S = new PdfName("S");
    public static final PdfName SATURATION = new PdfName("Saturation");
    public static final PdfName SCHEMA = new PdfName("Schema");
    public static final PdfName SCREEN = new PdfName("Screen");
    public static final PdfName SCRIPTS = new PdfName("Scripts");
    public static final PdfName SECT = new PdfName("Sect");
    public static final PdfName SEPARATION = new PdfName("Separation");
    public static final PdfName SETOCGSTATE = new PdfName("SetOCGState");
    public static final PdfName SETTINGS = new PdfName("Settings");
    public static final PdfName SHADING = new PdfName("Shading");
    public static final PdfName SHADINGTYPE = new PdfName("ShadingType");
    public static final PdfName SHIFT_JIS = new PdfName("Shift-JIS");
    public static final PdfName SIG = new PdfName("Sig");
    public static final PdfName SIGFLAGS = new PdfName("SigFlags");
    public static final PdfName SIGREF = new PdfName("SigRef");
    public static final PdfName SIMPLEX = new PdfName("Simplex");
    public static final PdfName SINGLEPAGE = new PdfName("SinglePage");
    public static final PdfName SIZE = new PdfName("Size");
    public static final PdfName SMASK = new PdfName("SMask");
    public static final PdfName SORT = new PdfName("Sort");
    public static final PdfName SOUND = new PdfName("Sound");
    public static final PdfName SPAN = new PdfName("Span");
    public static final PdfName SPEED = new PdfName("Speed");
    public static final PdfName SPLIT = new PdfName("Split");
    public static final PdfName SQUARE = new PdfName("Square");
    public static final PdfName SQUIGGLY = new PdfName("Squiggly");
    public static final PdfName ST = new PdfName("St");
    public static final PdfName STAMP = new PdfName("Stamp");
    public static final PdfName STANDARD = new PdfName("Standard");
    public static final PdfName STATE = new PdfName("State");
    public static final PdfName STDCF = new PdfName("StdCF");
    public static final PdfName STEMV = new PdfName("StemV");
    public static final PdfName STMF = new PdfName("StmF");
    public static final PdfName STRF = new PdfName("StrF");
    public static final PdfName STRIKEOUT = new PdfName("StrikeOut");
    public static final PdfName STRUCTPARENT = new PdfName("StructParent");
    public static final PdfName STRUCTPARENTS = new PdfName("StructParents");
    public static final PdfName STRUCTTREEROOT = new PdfName("StructTreeRoot");
    public static final PdfName STYLE = new PdfName("Style");
    public static final PdfName SUBFILTER = new PdfName("SubFilter");
    public static final PdfName SUBJECT = new PdfName("Subject");
    public static final PdfName SUBMITFORM = new PdfName("SubmitForm");
    public static final PdfName SUBTYPE = new PdfName("Subtype");
    public static final PdfName SUPPLEMENT = new PdfName("Supplement");
    public static final PdfName SV = new PdfName("SV");
    public static final PdfName SW = new PdfName("SW");
    public static final PdfName SYMBOL = new PdfName("Symbol");
    public static final PdfName T = new PdfName("T");
    public static final PdfName TA = new PdfName("TA");
    public static final PdfName TABLE = new PdfName("Table");
    public static final PdfName TABS = new PdfName("Tabs");
    public static final PdfName TBODY = new PdfName("TBody");
    public static final PdfName TD = new PdfName("TD");
    public static final PdfName TEXT = new PdfName("Text");
    public static final PdfName TFOOT = new PdfName("TFoot");
    public static final PdfName TH = new PdfName("TH");
    public static final PdfName THEAD = new PdfName("THead");
    public static final PdfName THUMB = new PdfName("Thumb");
    public static final PdfName THREADS = new PdfName("Threads");
    public static final PdfName TI = new PdfName("TI");
    public static final PdfName TIME = new PdfName("Time");
    public static final PdfName TILINGTYPE = new PdfName("TilingType");
    public static final PdfName TIMES_ROMAN = new PdfName("Times-Roman");
    public static final PdfName TIMES_BOLD = new PdfName("Times-Bold");
    public static final PdfName TIMES_ITALIC = new PdfName("Times-Italic");
    public static final PdfName TIMES_BOLDITALIC = new PdfName("Times-BoldItalic");
    public static final PdfName TITLE = new PdfName("Title");
    public static final PdfName TK = new PdfName("TK");
    public static final PdfName TM = new PdfName("TM");
    public static final PdfName TOC = new PdfName("TOC");
    public static final PdfName TOCI = new PdfName("TOCI");
    public static final PdfName TOGGLE = new PdfName("Toggle");
    public static final PdfName TOOLBAR = new PdfName("Toolbar");
    public static final PdfName TOUNICODE = new PdfName("ToUnicode");
    public static final PdfName TP = new PdfName("TP");
    public static final PdfName TABLEROW = new PdfName("TR");
    public static final PdfName TRANS = new PdfName("Trans");
    public static final PdfName TRANSFORMPARAMS = new PdfName("TransformParams");
    public static final PdfName TRANSFORMMETHOD = new PdfName("TransformMethod");
    public static final PdfName TRANSPARENCY = new PdfName("Transparency");
    public static final PdfName TRANSPARENT = new PdfName("Transparent");
    public static final PdfName TRAPPED = new PdfName("Trapped");
    public static final PdfName TRIMBOX = new PdfName("TrimBox");
    public static final PdfName TRUETYPE = new PdfName("TrueType");
    public static final PdfName TU = new PdfName("TU");
    public static final PdfName TWOCOLUMNLEFT = new PdfName("TwoColumnLeft");
    public static final PdfName TWOCOLUMNRIGHT = new PdfName("TwoColumnRight");
    public static final PdfName TWOPAGELEFT = new PdfName("TwoPageLeft");
    public static final PdfName TWOPAGERIGHT = new PdfName("TwoPageRight");
    public static final PdfName TX = new PdfName("Tx");
    public static final PdfName TYPE = new PdfName("Type");
    public static final PdfName TYPE0 = new PdfName("Type0");
    public static final PdfName TYPE1 = new PdfName("Type1");
    public static final PdfName TYPE3 = new PdfName("Type3");
    public static final PdfName U = new PdfName("U");
    public static final PdfName UF = new PdfName("UF");
    public static final PdfName UHC = new PdfName("UHC");
    public static final PdfName UNDERLINE = new PdfName("Underline");
    public static final PdfName UR = new PdfName("UR");
    public static final PdfName UR3 = new PdfName("UR3");
    public static final PdfName URI = new PdfName("URI");
    public static final PdfName URL = new PdfName("URL");
    public static final PdfName USAGE = new PdfName("Usage");
    public static final PdfName USEATTACHMENTS = new PdfName("UseAttachments");
    public static final PdfName USENONE = new PdfName("UseNone");
    public static final PdfName USEOC = new PdfName("UseOC");
    public static final PdfName USEOUTLINES = new PdfName("UseOutlines");
    public static final PdfName USER = new PdfName("User");
    public static final PdfName USERPROPERTIES = new PdfName("UserProperties");
    public static final PdfName USERUNIT = new PdfName("UserUnit");
    public static final PdfName USETHUMBS = new PdfName("UseThumbs");
    public static final PdfName V = new PdfName("V");
    public static final PdfName V2 = new PdfName("V2");
    public static final PdfName VALIGN = new PdfName("VAlign");
    public static final PdfName VERISIGN_PPKVS = new PdfName("VeriSign.PPKVS");
    public static final PdfName VERSION = new PdfName("Version");
    public static final PdfName VIDEO = new PdfName("Video");
    public static final PdfName VIEW = new PdfName("View");
    public static final PdfName VIEWS = new PdfName("Views");
    public static final PdfName VIEWAREA = new PdfName("ViewArea");
    public static final PdfName VIEWCLIP = new PdfName("ViewClip");
    public static final PdfName VIEWERPREFERENCES = new PdfName("ViewerPreferences");
    public static final PdfName VIEWSTATE = new PdfName("ViewState");
    public static final PdfName VISIBLEPAGES = new PdfName("VisiblePages");
    public static final PdfName VOFFSET = new PdfName("VOffset");
    public static final PdfName W = new PdfName("W");
    public static final PdfName W2 = new PdfName("W2");
    public static final PdfName WARICHU = new PdfName("Warichu");
    public static final PdfName WC = new PdfName("WC");
    public static final PdfName WIDGET = new PdfName("Widget");
    public static final PdfName WIDTH = new PdfName("Width");
    public static final PdfName WIDTHS = new PdfName("Widths");
    public static final PdfName WIN = new PdfName("Win");
    public static final PdfName WIN_ANSI_ENCODING = new PdfName("WinAnsiEncoding");
    public static final PdfName WINDOW = new PdfName("Window");
    public static final PdfName WINDOWED = new PdfName("Windowed");
    public static final PdfName WIPE = new PdfName("Wipe");
    public static final PdfName WHITEPOINT = new PdfName("WhitePoint");
    public static final PdfName WP = new PdfName("WP");
    public static final PdfName WS = new PdfName("WS");
    public static final PdfName X = new PdfName("X");
    public static final PdfName XA = new PdfName("XA");
    public static final PdfName XD = new PdfName("XD");
    public static final PdfName XFA = new PdfName("XFA");
    public static final PdfName XML = new PdfName("XML");
    public static final PdfName XOBJECT = new PdfName("XObject");
    public static final PdfName XSTEP = new PdfName("XStep");
    public static final PdfName XREF = new PdfName("XRef");
    public static final PdfName XREFSTM = new PdfName("XRefStm");
    public static final PdfName XYZ = new PdfName("XYZ");
    public static final PdfName YSTEP = new PdfName("YStep");
    public static final PdfName ZADB = new PdfName("ZaDb");
    public static final PdfName ZAPFDINGBATS = new PdfName("ZapfDingbats");
    public static final PdfName ZOOM = new PdfName("Zoom");
    public static Map staticNames;
    private int hash = 0;
    static /* synthetic */ Class class$com$fr$third$com$lowagie$text$pdf$PdfName;

    public PdfName(String string) {
        this(string, true);
    }

    public PdfName(String string, boolean bl) {
        super(4);
        int n = string.length();
        if (bl && n > 127) {
            throw new IllegalArgumentException("The name '" + string + "' is too long (" + n + " characters).");
        }
        this.bytes = PdfName.encodeName(string);
    }

    public PdfName(byte[] byArray) {
        super(4, byArray);
    }

    public int compareTo(Object object) {
        PdfName pdfName = (PdfName)object;
        byte[] byArray = this.bytes;
        byte[] byArray2 = pdfName.bytes;
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] > byArray2[i]) {
                return 1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return -1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PdfName) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            int n3 = this.bytes.length;
            for (int i = 0; i < n3; ++i) {
                n = 31 * n + (this.bytes[n2++] & 0xFF);
            }
            this.hash = n;
        }
        return n;
    }

    public static byte[] encodeName(String string) {
        int n = string.length();
        ByteBuffer byteBuffer = new ByteBuffer(n + 20);
        byteBuffer.append('/');
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < n; ++i) {
            char c = (char)(cArray[i] & 0xFF);
            switch (c) {
                case ' ': 
                case '#': 
                case '%': 
                case '(': 
                case ')': 
                case '/': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    byteBuffer.append('#');
                    byteBuffer.append(Integer.toString(c, 16));
                    continue block3;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        byteBuffer.append(c);
                        continue block3;
                    }
                    byteBuffer.append('#');
                    if (c < '\u0010') {
                        byteBuffer.append('0');
                    }
                    byteBuffer.append(Integer.toString(c, 16));
                }
            }
        }
        return byteBuffer.toByteArray();
    }

    public static String decodeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '#') {
                    char c2 = string.charAt(i + 1);
                    char c3 = string.charAt(i + 2);
                    c = (char)((PRTokeniser.getHex(c2) << 4) + PRTokeniser.getHex(c3));
                    i += 2;
                }
                stringBuffer.append(c);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Field[] fieldArray = (class$com$fr$third$com$lowagie$text$pdf$PdfName == null ? (class$com$fr$third$com$lowagie$text$pdf$PdfName = PdfName.class$("com.fr.third.com.lowagie.text.pdf.PdfName")) : class$com$fr$third$com$lowagie$text$pdf$PdfName).getDeclaredFields();
        staticNames = new HashMap(fieldArray.length);
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if ((field.getModifiers() & 0x19) != 25 || !field.getType().equals(class$com$fr$third$com$lowagie$text$pdf$PdfName == null ? PdfName.class$("com.fr.third.com.lowagie.text.pdf.PdfName") : class$com$fr$third$com$lowagie$text$pdf$PdfName)) continue;
                PdfName pdfName = (PdfName)field.get(null);
                staticNames.put(PdfName.decodeName(pdfName.toString()), pdfName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

