/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetWorkflowExecutionHistoryRequestMarshaller
implements Marshaller<Request<GetWorkflowExecutionHistoryRequest>, GetWorkflowExecutionHistoryRequest> {
    public Request<GetWorkflowExecutionHistoryRequest> marshall(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) {
        if (getWorkflowExecutionHistoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getWorkflowExecutionHistoryRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.GetWorkflowExecutionHistory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (getWorkflowExecutionHistoryRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(getWorkflowExecutionHistoryRequest.getDomain());
            }
            if (getWorkflowExecutionHistoryRequest.getExecution() != null) {
                jsonGenerator.writeFieldName("execution");
                WorkflowExecutionJsonMarshaller.getInstance().marshall(getWorkflowExecutionHistoryRequest.getExecution(), jsonGenerator);
            }
            if (getWorkflowExecutionHistoryRequest.getNextPageToken() != null) {
                jsonGenerator.writeFieldName("nextPageToken").writeValue(getWorkflowExecutionHistoryRequest.getNextPageToken());
            }
            if (getWorkflowExecutionHistoryRequest.getMaximumPageSize() != null) {
                jsonGenerator.writeFieldName("maximumPageSize").writeValue(getWorkflowExecutionHistoryRequest.getMaximumPageSize().intValue());
            }
            if (getWorkflowExecutionHistoryRequest.getReverseOrder() != null) {
                jsonGenerator.writeFieldName("reverseOrder").writeValue(getWorkflowExecutionHistoryRequest.getReverseOrder().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

