/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.quartz.job;

import cn.dreampie.quartz.QuartzKey;
import cn.dreampie.quartz.QuartzKit;
import cn.dreampie.quartz.job.JobState;
import cn.dreampie.quartz.job.QuartzJob;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzOnceJob
extends QuartzJob {
    private Date startTime;

    public QuartzOnceJob(QuartzKey quartzKey, Date startTime, Class<? extends Job> jobClass) {
        this.quartzKey = quartzKey;
        this.startTime = startTime;
        this.jobClass = jobClass;
        this.state = JobState.INITED;
    }

    @Override
    public void start(boolean force) {
        QuartzJob quartzJob = QuartzKit.getJob(this.quartzKey);
        if (quartzJob != null) {
            if (force) {
                quartzJob.stop();
            } else {
                return;
            }
        }
        long id = this.quartzKey.getId();
        String name = this.quartzKey.getName();
        String group = this.quartzKey.getGroup();
        SchedulerFactory factory = QuartzKit.getSchedulerFactory();
        try {
            if (factory != null) {
                Scheduler sched = factory.getScheduler();
                JobDetail job = JobBuilder.newJob((Class)this.jobClass).withIdentity("job_" + name + "_" + id, "group_" + group + "_" + id).requestRecovery().build();
                JobDataMap jobMap = job.getJobDataMap();
                jobMap.put(group + "_" + name, id);
                if (this.params != null && this.params.size() > 0) {
                    jobMap.putAll(this.params);
                }
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger_" + name + "_" + id, "group_" + group + "_" + id).startAt(this.startTime).build();
                this.scheduleTime = sched.scheduleJob(job, trigger);
                sched.start();
                this.state = JobState.STARTED;
                QuartzKit.addQuartzJob(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't start once job.", e);
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
}

