/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.quartz.job;

import cn.dreampie.quartz.QuartzKey;
import cn.dreampie.quartz.QuartzKit;
import cn.dreampie.quartz.job.JobState;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuartzJob {
    protected QuartzKey quartzKey;
    protected JobState state;
    protected Class<? extends Job> jobClass;
    protected Date scheduleTime;
    protected Map<String, Object> params = Maps.newHashMap();
    protected static final String TRIGGER_MARK = "trigger";
    protected static final String GROUP_MARK = "group";
    protected static final String JOB_MARK = "job";
    protected static final String SEPARATOR = "_";

    public void start() {
        this.start(false);
    }

    public abstract void start(boolean var1);

    public void stop() {
        long id = this.quartzKey.getId();
        String name = this.quartzKey.getName();
        String group = this.quartzKey.getGroup();
        SchedulerFactory factory = QuartzKit.getSchedulerFactory();
        try {
            TriggerKey triggerKey;
            Scheduler scheduler;
            Trigger trigger;
            if (factory != null && (trigger = (scheduler = factory.getScheduler()).getTrigger(triggerKey = TriggerKey.triggerKey((String)("trigger_" + name + SEPARATOR + id), (String)("group_" + group + SEPARATOR + id)))) != null) {
                scheduler.pauseTrigger(triggerKey);
                scheduler.unscheduleJob(triggerKey);
                scheduler.deleteJob(trigger.getJobKey());
                this.state = JobState.STOPED;
                QuartzKit.removeQuartzJob(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't stop job.", e);
        }
    }

    public void pause() {
        long id = this.quartzKey.getId();
        String name = this.quartzKey.getName();
        String group = this.quartzKey.getGroup();
        SchedulerFactory factory = QuartzKit.getSchedulerFactory();
        try {
            TriggerKey triggerKey;
            Scheduler scheduler;
            Trigger trigger;
            if (factory != null && (trigger = (scheduler = factory.getScheduler()).getTrigger(triggerKey = TriggerKey.triggerKey((String)("trigger_" + name + SEPARATOR + id), (String)("group_" + group + SEPARATOR + id)))) != null) {
                scheduler.pauseTrigger(triggerKey);
                this.state = JobState.PAUSED;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't pause job.", e);
        }
    }

    public void resume() {
        long id = this.quartzKey.getId();
        String name = this.quartzKey.getName();
        String group = this.quartzKey.getGroup();
        SchedulerFactory factory = QuartzKit.getSchedulerFactory();
        try {
            TriggerKey triggerKey;
            Scheduler scheduler;
            Trigger trigger;
            if (factory != null && (trigger = (scheduler = factory.getScheduler()).getTrigger(triggerKey = TriggerKey.triggerKey((String)("trigger_" + name + SEPARATOR + id), (String)("group_" + group + SEPARATOR + id)))) != null) {
                scheduler.resumeJob(trigger.getJobKey());
                this.state = JobState.RESUMED;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't resume job.", e);
        }
    }

    public QuartzKey getQuartzKey() {
        return this.quartzKey;
    }

    public void setQuartzKey(QuartzKey quartzKey) {
        this.quartzKey = quartzKey;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(Class<? extends Job> jobClass) {
        this.jobClass = jobClass;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public QuartzJob addParam(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    public QuartzJob addParams(Map<String, Object> values) {
        this.params.putAll(values);
        return this;
    }
}

