/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.quartz.job;

import cn.dreampie.quartz.QuartzKey;
import cn.dreampie.quartz.QuartzKit;
import cn.dreampie.quartz.job.JobState;
import cn.dreampie.quartz.job.QuartzJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzCronJob
extends QuartzJob {
    private String cron;

    public QuartzCronJob(QuartzKey quartzKey, String cron, Class<? extends Job> jobClass) {
        this.quartzKey = quartzKey;
        this.state = JobState.INITED;
        this.cron = cron;
        this.jobClass = jobClass;
    }

    @Override
    public void start(boolean force) {
        QuartzJob quartzJob = QuartzKit.getJob(this.quartzKey);
        if (quartzJob != null) {
            if (force) {
                quartzJob.stop();
            } else {
                return;
            }
        }
        long id = this.quartzKey.getId();
        String name = this.quartzKey.getName();
        String group = this.quartzKey.getGroup();
        SchedulerFactory factory = QuartzKit.getSchedulerFactory();
        try {
            if (factory != null) {
                Scheduler sched = factory.getScheduler();
                JobDetail job = JobBuilder.newJob((Class)this.jobClass).withIdentity("job_" + name + "_" + id, "group_" + group + "_" + id).requestRecovery().build();
                JobDataMap jobMap = job.getJobDataMap();
                jobMap.put(group + "_" + name, id);
                if (this.params != null && this.params.size() > 0) {
                    jobMap.putAll(this.params);
                }
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name + "_" + id, "group_" + group + "_" + id).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron)).build();
                this.scheduleTime = sched.scheduleJob(job, (Trigger)trigger);
                sched.start();
                this.state = JobState.STARTED;
                QuartzKit.addQuartzJob(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't start cron job.", e);
        }
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }
}

