/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.quartz;

import cn.dreampie.PropertiesKit;
import cn.dreampie.quartz.QuartzKey;
import cn.dreampie.quartz.QuartzKit;
import cn.dreampie.quartz.job.QuartzCronJob;
import cn.dreampie.quartz.job.QuartzJob;
import com.jfinal.plugin.IPlugin;
import java.util.Enumeration;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String dsName = "main";
    public static boolean dsAlone = false;
    private String config = "quartz/quartz.properties";
    private String jobs = "quartz/jobs.properties";

    public QuartzPlugin() {
    }

    public QuartzPlugin(String dsName) {
        QuartzPlugin.dsName = dsName;
    }

    public boolean start() {
        try {
            Properties properties = PropertiesKit.me().loadPropertyFile(this.config);
            QuartzKit.setSchedulerFactory((SchedulerFactory)new StdSchedulerFactory(properties));
            Scheduler sched = QuartzKit.getSchedulerFactory().getScheduler();
            sched.start();
            this.startPropertiesJobs();
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't start quartz plugin.", e);
        }
    }

    public boolean stop() {
        try {
            QuartzKit.getSchedulerFactory().getScheduler().shutdown();
            QuartzKit.setSchedulerFactory(null);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't stop quartz plugin.", e);
        }
    }

    public void startPropertiesJobs() {
        if (PropertiesKit.exist((String)this.jobs)) {
            Properties properties = PropertiesKit.me().loadPropertyFile(this.jobs);
            Enumeration<Object> enums = properties.keys();
            while (enums.hasMoreElements()) {
                Class<?> clazz;
                String key = enums.nextElement() + "";
                if (!key.startsWith("job")) continue;
                String[] keyArr = key.split("\\.");
                String jobClassKey = key.replace(keyArr[2], "class");
                String idKey = key.replace(keyArr[2], "id");
                String groupKey = key.replace(keyArr[2], "group");
                String cronKey = key.replace(keyArr[2], "cron");
                String enable = key.replace(keyArr[2], "enable");
                if (!Boolean.valueOf(properties.getProperty(enable)).booleanValue()) continue;
                Integer id = Integer.parseInt(properties.getProperty(idKey));
                String group = properties.getProperty(groupKey);
                QuartzKey quartzKey = new QuartzKey(id.intValue(), keyArr[1], group == null ? keyArr[1] : group);
                QuartzJob quartzJob = QuartzKit.getJob(quartzKey);
                if (quartzJob != null) {
                    this.logger.info("This  job  has started," + quartzKey);
                    continue;
                }
                String jobCron = properties.getProperty(cronKey);
                String jobClassName = properties.getProperty(jobClassKey);
                try {
                    clazz = Class.forName(jobClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                new QuartzCronJob(quartzKey, jobCron, clazz).start();
            }
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getJobs() {
        return this.jobs;
    }

    public void setJobs(String jobs) {
        this.jobs = jobs;
    }

    public static boolean isDsAlone() {
        return dsAlone;
    }

    public static void setDsAlone(boolean dsAlone) {
        QuartzPlugin.dsAlone = dsAlone;
    }
}

