SELECT
	a.id AS id,
	IFNULL(a.nickname, '') AS nickname,
	a.content AS content,
	a.fromusername AS fromusername,
	a.tousername AS tousername,
	a.msgType AS msgType,
	IFNULL(a.rescontent, '') AS rescontent,
	a.response AS response,
	a.createtime AS createtime
FROM
	weixin_receivetext AS a,
	(
		SELECT
			fromusername AS fromusername,
			MAX(createtime) AS createtime
		FROM
			weixin_receivetext
		WHERE
		 response = 0
		 <#if receiveText.accountId ?exists && receiveText.accountId?length gt 0>
	         and accountId = :receiveText.accountId
         </#if>
		GROUP BY
			fromusername
	) AS b
WHERE
	a.fromusername = b.fromusername
AND a.createtime = b.createtime
AND a.response = 0
<#if receiveText.accountId ?exists && receiveText.accountId?length gt 0>
 and a.accountId = :receiveText.accountId
</#if>
<#if receiveText.nickName ?exists && receiveText.nickName?length gt 0>
	and a.nickName = :receiveText.nickName
</#if>
<#if receiveText.fromUserName ?exists && receiveText.fromUserName?length gt 0>
	and a.fromusername = :receiveText.fromUserName
</#if>
ORDER BY
	a.createtime DESC