/*
 * Decompiled with CFR 0.152.
 */
package weixin.wall.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.constant.WeiXinConstant;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.model.GzUserInfo;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.service.WeixinVipMemberServiceI;
import weixin.wall.entity.WeixinWallEntity;
import weixin.wall.entity.WeixinWallMessageEntity;
import weixin.wall.service.WeixinWallMessageServiceI;
import weixin.wall.service.WeixinWallServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinWallMessageController"})
public class WeixinWallMessageController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinWallMessageController.class);
    private static final String HEADIMGURL = "plug-in/weixin/wall/images/common/default.jpg";
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private WeixinWallMessageServiceI weixinWallMessageService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private WeixinWallServiceI weixinWallService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinWallMessage"})
    public ModelAndView weixinWallMessage(HttpServletRequest request) {
        return new ModelAndView("weixin/wall/weixinWallMessageList");
    }

    @RequestMapping(params={"wallAuthstr"})
    public ModelAndView wallAuthstr(HttpServletRequest request) {
        request.setAttribute("wall_status", (Object)WeiXinConstant.WALL_TYPE_WALLAUTHSTR);
        return new ModelAndView("weixin/wall/weixinWallMessageList");
    }

    @RequestMapping(params={"wallAudited"})
    public ModelAndView wallAudited(HttpServletRequest request) {
        request.setAttribute("wall_status", (Object)WeiXinConstant.WALL_TYPE_WALLAUDITED);
        return new ModelAndView("weixin/wall/weixinWallMessageList");
    }

    @RequestMapping(params={"wallNoAudit"})
    public ModelAndView wallNoAudit(HttpServletRequest request) {
        request.setAttribute("wall_status", (Object)WeiXinConstant.WALL_TYPE_WALLNOAUDIT);
        return new ModelAndView("weixin/wall/weixinWallMessageList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinWallMessageEntity weixinWallMessage, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinWallMessageEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        String status = request.getParameter("wall_status");
        if (status != null && !"".equals(status)) {
            cq.eq("status", (Object)status);
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinWallMessage, (Map)request.getParameterMap());
        this.weixinWallMessageService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinWallMessageEntity weixinWallMessage, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinWallMessage = (WeixinWallMessageEntity)this.systemService.getEntity(WeixinWallMessageEntity.class, (Serializable)((Object)weixinWallMessage.getId()));
        this.message = "\u5fae\u4fe1\u5899\u4fe1\u606f\u5220\u9664\u6210\u529f";
        this.weixinWallMessageService.delete(weixinWallMessage);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinWallMessageEntity weixinWallMessage, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (weixinWallMessage.getOpenid() == null || weixinWallMessage.getAccountid() == null || weixinWallMessage.getAccountid() == null) {
            this.message = "\u7528\u6237\u8eab\u4efd\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5173\u95ed\u9875\u9762\u91cd\u65b0\u8bbf\u95ee";
            j.setMsg(this.message);
            j.setSuccess(false);
            return j;
        }
        TSUser u = (TSUser)this.systemService.findUniqueByProperty(TSUser.class, "openid", (Object)weixinWallMessage.getOpenid());
        if (u == null) {
            this.message = "\u7528\u6237\u8eab\u4efd\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u5173\u95ed\u9875\u9762\u91cd\u65b0\u8bbf\u95ee";
            j.setMsg(this.message);
            j.setSuccess(false);
            return j;
        }
        WeixinWallEntity wall = (WeixinWallEntity)this.systemService.findUniqueByProperty(WeixinWallEntity.class, "id", (Object)weixinWallMessage.getWallid());
        if (wall == null) {
            this.message = "\u5927\u5c4f\u5e55\u5df2\u5173\u95ed,\u6d3b\u52a8\u7ed3\u675f";
            j.setMsg(this.message);
            j.setSuccess(false);
            return j;
        }
        GzUserInfo userinfo = this.gzUserInfoService.getGzUserInfo(weixinWallMessage.getOpenid(), weixinWallMessage.getAccountid());
        if (userinfo == null) {
            this.message = "\u7528\u6237\u8eab\u4efd\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5173\u95ed\u9875\u9762\u91cd\u65b0\u8bbf\u95ee";
            j.setMsg(this.message);
            j.setSuccess(false);
            return j;
        }
        if (WeiXinConstant.WALL_TYPE_AUDIT.equals(wall.getType())) {
            weixinWallMessage.setStatus(WeiXinConstant.WALL_TYPE_WALLAUTHSTR);
        } else if (WeiXinConstant.WALL_TYPE_NOAUDIT.equals(wall.getType())) {
            weixinWallMessage.setStatus(WeiXinConstant.WALL_TYPE_WALLAUDITED);
        }
        weixinWallMessage.setCreatetime(new Date());
        weixinWallMessage.setHeadimgurl(userinfo.getHeadimgurl());
        weixinWallMessage.setNickname(userinfo.getNickname());
        weixinWallMessage.setUserid(u.getId());
        try {
            this.weixinWallMessageService.save(weixinWallMessage);
        }
        catch (Exception e) {
            this.message = "\u53d1\u8868\u5931\u8d25";
            j.setSuccess(false);
        }
        j.setMsg(this.message);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinWallMessageEntity weixinWallMessage, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinWallMessage.getId())) {
            weixinWallMessage = (WeixinWallMessageEntity)this.weixinWallMessageService.getEntity(WeixinWallMessageEntity.class, (Serializable)((Object)weixinWallMessage.getId()));
            req.setAttribute("weixinWallMessagePage", (Object)weixinWallMessage);
        }
        return new ModelAndView("weixin/wall/weixinWallMessage");
    }

    @RequestMapping(params={"auditMember"})
    @ResponseBody
    public AjaxJson auditMember(WeixinWallMessageEntity weixinWallMessage, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinWallMessage.getId())) {
            this.message = "\u5fae\u4fe1\u5899\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
            WeixinWallMessageEntity t = (WeixinWallMessageEntity)this.weixinWallMessageService.get(WeixinWallMessageEntity.class, (Serializable)((Object)weixinWallMessage.getId()));
            try {
                if (t != null) {
                    String falg = request.getParameter("falg");
                    if (WeiXinConstant.WALL_TYPE_WALLAUDITED.equals(falg)) {
                        t.setStatus(WeiXinConstant.WALL_TYPE_WALLAUDITED);
                    } else if (WeiXinConstant.WALL_TYPE_WALLNOAUDIT.equals(falg)) {
                        t.setStatus(WeiXinConstant.WALL_TYPE_WALLNOAUDIT);
                    }
                    this.message = "\u5ba1\u6838\u64cd\u4f5c\u6210\u529f";
                    this.weixinWallMessageService.saveOrUpdate(t);
                } else {
                    this.message = "\u5ba1\u6838\u5931\u8d25,\u975e\u6cd5\u6570\u636e";
                }
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u4fe1\u5899\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5ba1\u6838\u5931\u8d25,\u975e\u6cd5\u6570\u636e";
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goWallPC"})
    public ModelAndView goWallPC(HttpServletRequest request) {
        WeixinWallEntity wall = (WeixinWallEntity)this.weixinWallService.findUniqueByProperty(WeixinWallEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        List allmessage = this.weixinWallMessageService.findByProperty(WeixinWallMessageEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        request.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        request.setAttribute("count", (Object)allmessage.size());
        if (wall != null) {
            request.setAttribute("logo", (Object)wall.getLogo());
            request.setAttribute("qrcode", (Object)wall.getQrCode());
            request.setAttribute("time", (Object)(wall.getTimer() * 1000));
        }
        return new ModelAndView("weixin/wall/weixinWallPC");
    }

    @RequestMapping(params={"getMessage"})
    @ResponseBody
    public JSONObject getMessage(HttpServletRequest request, int page, String accountid, int lastid) {
        JSONArray json = new JSONArray();
        CriteriaQuery cq = new CriteriaQuery(WeixinWallMessageEntity.class);
        cq.eq("accountid", (Object)accountid);
        cq.setPageSize(1);
        cq.setCurPage(Integer.valueOf(page));
        cq.add();
        List message = this.weixinWallMessageService.getListByCriteriaQuery(cq, true);
        JSONObject jo = new JSONObject();
        if (message.size() != 0) {
            List memberlist;
            String openid = ((WeixinWallMessageEntity)message.get(0)).getOpenid();
            GzUserInfoYw userinfo = this.gzUserInfoService.getLocalUserinfoAll(openid, accountid);
            if (userinfo != null) {
                WeixinVipMemberEntity memb;
                if (!StringUtil.isEmpty((String)userinfo.getNickname())) {
                    jo.put("nickname", (Object)new String(WeixinUtil.decode(userinfo.getNickname())));
                } else {
                    memberlist = this.weixinVipMemberService.findByProperty(WeixinVipMemberEntity.class, "openid", openid);
                    if (memberlist.size() != 0) {
                        memb = (WeixinVipMemberEntity)memberlist.get(0);
                        if (!StringUtil.isEmpty((String)memb.getMemberRealName())) {
                            jo.put("nickname", (Object)memb.getMemberRealName());
                        } else {
                            jo.put("nickname", (Object)"\u533f\u540d\u7528\u6237");
                        }
                    } else {
                        jo.put("nickname", (Object)"\u533f\u540d\u7528\u6237");
                    }
                }
                if (!StringUtil.isEmpty((String)userinfo.getHeadimgurl())) {
                    jo.put("avatar", (Object)userinfo.getHeadimgurl());
                } else {
                    memberlist = this.weixinVipMemberService.findByProperty(WeixinVipMemberEntity.class, "openid", openid);
                    if (memberlist.size() != 0) {
                        memb = (WeixinVipMemberEntity)memberlist.get(0);
                        if (!StringUtil.isEmpty((String)memb.getMemberPhoto())) {
                            jo.put("avatar", (Object)memb.getMemberPhoto());
                        } else {
                            jo.put("avatar", (Object)HEADIMGURL);
                        }
                    } else {
                        jo.put("avatar", (Object)HEADIMGURL);
                    }
                }
            } else {
                memberlist = this.weixinVipMemberService.findByProperty(WeixinVipMemberEntity.class, "openid", openid);
                if (memberlist.size() != 0) {
                    WeixinVipMemberEntity memb = (WeixinVipMemberEntity)memberlist.get(0);
                    if (!StringUtil.isEmpty((String)memb.getMemberPhoto())) {
                        jo.put("avatar", (Object)memb.getMemberPhoto());
                    } else {
                        jo.put("avatar", (Object)HEADIMGURL);
                    }
                    if (!StringUtil.isEmpty((String)memb.getMemberRealName())) {
                        jo.put("nickname", (Object)memb.getMemberRealName());
                    } else {
                        jo.put("nickname", (Object)"\u533f\u540d\u7528\u6237");
                    }
                } else {
                    jo.put("avatar", (Object)HEADIMGURL);
                    jo.put("nickname", (Object)"\u533f\u540d\u7528\u6237");
                }
            }
            List allmessage = this.weixinWallMessageService.findByProperty(WeixinWallMessageEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
            jo.put("count", (Object)allmessage);
            jo.put("num", (Object)(message.size() + lastid));
            jo.put("content", (Object)((WeixinWallMessageEntity)message.get(0)).getContent());
            json.add((Object)jo);
        }
        JSONObject data = new JSONObject();
        data.put("data", (Object)json);
        return data;
    }
}

