/*
 * Decompiled with CFR 0.152.
 */
package weixin.vip.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.vip.entity.WeixinVipInfoEntity;
import weixin.vip.entity.WeixinVipIntegralType;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.entity.WeixinVipMemberIntegralEntity;
import weixin.vip.service.WeixinVipInfoServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Service(value="weixinVipMemberService")
@Transactional
public class WeixinVipMemberServiceImpl
extends CommonServiceImpl
implements WeixinVipMemberServiceI {
    @Autowired
    private WeixinVipInfoServiceI weixinVipInfoService;

    @Override
    public void saveMemberByVip(TSUser user) {
        WeixinVipMemberEntity member = new WeixinVipMemberEntity();
        WeixinVipInfoEntity vipinfo = (WeixinVipInfoEntity)this.weixinVipInfoService.get(WeixinVipInfoEntity.class, (Serializable)((Object)"402881e5479afd0101479b7d792e002f"));
        member.setTsuer(user);
        member.setVipInfo(vipinfo);
        member.setCreateTime(new Date());
        member.setMemberName(user.getUserName());
        super.save((Object)member);
    }

    @Override
    public Boolean updateMemberIntegral(String userid, String accountid, Integer integral) {
        Boolean flag = false;
        try {
            List list = this.weixinVipInfoService.findByQueryString("from WeixinVipInfoEntity vipinfo where vipinfo.accountid='" + accountid + "' order by vipinfo.levelId asc");
            String ids = "";
            for (WeixinVipInfoEntity v : list) {
                ids = String.valueOf(ids) + "'" + v.getId() + "',";
            }
            List memberlist = this.findByQueryString("from WeixinVipMemberEntity m where m.vipInfo in (" + (ids = ids.substring(0, ids.length() - 1)) + ") and m.tsuer = '" + userid + "'");
            if (memberlist != null && memberlist.size() > 0) {
                WeixinVipMemberEntity membervip = (WeixinVipMemberEntity)memberlist.get(0);
                if (integral > 0) {
                    membervip.setMemberIntegral(membervip.getMemberIntegral() + integral);
                } else if (membervip.getMemberIntegral() + integral >= 0) {
                    membervip.setMemberIntegral(membervip.getMemberIntegral() + integral);
                }
                this.saveOrUpdate(membervip);
                flag = true;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    @Override
    public WeixinVipMemberEntity checkMemberExits(WeixinVipMemberEntity member) {
        String query = "from WeixinVipMemberEntity u where u.memberName = :memberName and u.password=:passowrd";
        Query queryObject = this.getSession().createQuery(query);
        queryObject.setParameter("memberName", (Object)member.getMemberName());
        queryObject.setParameter("passowrd", (Object)member.getPassword());
        List members = queryObject.list();
        if (members != null && members.size() > 0) {
            return (WeixinVipMemberEntity)members.get(0);
        }
        return null;
    }

    @Override
    public Boolean updateMemberIntegral(String openid, String userid, String accountid, int integral, WeixinVipIntegralType integralType, String detailtype, String remark) {
        WeixinVipMemberEntity member = this.checkMemberGetOrNot(accountid, openid, userid);
        if (member != null) {
            if ("0".equals(detailtype)) {
                member.setMemberIntegral(member.getMemberIntegral() + integral);
            }
            if ("1".equals(detailtype)) {
                member.setMemberIntegral(member.getMemberIntegral() - integral);
            }
            WeixinVipMemberIntegralEntity integraldetail = new WeixinVipMemberIntegralEntity();
            integraldetail.setCreateTime(new Date());
            integraldetail.setDetailtype(detailtype);
            integraldetail.setIntegral(String.valueOf(integral));
            integraldetail.setRemark(remark);
            integraldetail.setMember(member);
            integraldetail.setIntegralType(integralType);
            integraldetail.setAccountid(accountid);
            this.save(integraldetail);
            this.updateEntitie(member);
            return true;
        }
        return false;
    }

    @Override
    public WeixinVipMemberEntity checkMemberGetOrNot(String accountid, String openid, String userid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipMemberEntity.class);
        try {
            cq.eq("accountid", (Object)accountid);
            if (oConvertUtils.isNotEmpty((Object)openid)) {
                cq.eq("openid", (Object)openid);
            } else {
                cq.eq("tsuer.id", (Object)userid);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List memberlist = this.getListByCriteriaQuery(cq, false);
        if (memberlist.size() != 0) {
            return (WeixinVipMemberEntity)memberlist.get(0);
        }
        return null;
    }

    @Override
    public List<WeixinVipMemberIntegralEntity> getIntegeraDetail(String memberid, String detailtype) {
        String hql = " FROM WeixinVipMemberIntegralEntity mi WHERE mi.member.id ='" + memberid + "' ";
        if (!StringUtil.isEmpty((String)detailtype)) {
            hql = String.valueOf(hql) + " AND  mi.detailtype = '" + detailtype + "'";
        }
        return this.findByQueryString(hql);
    }

    @Override
    public WeixinVipIntegralType getIntegraltype(String accountid, String typename) {
        String hql = " FROM WeixinVipIntegralType it WHERE it.accountid ='" + accountid + "' AND integral_type ='" + typename + "'";
        List typelist = this.findByQueryString(hql);
        if (typelist.size() != 0) {
            return (WeixinVipIntegralType)typelist.get(0);
        }
        return null;
    }

    @Override
    public WeixinVipMemberEntity checkMemberUnique(String memberName) {
        String query = "from WeixinVipMemberEntity u where u.memberName = :memberName";
        Query queryObject = this.getSession().createQuery(query);
        queryObject.setParameter("memberName", (Object)memberName);
        List members = queryObject.list();
        if (members != null && members.size() > 0) {
            return (WeixinVipMemberEntity)members.get(0);
        }
        return null;
    }

    @Override
    public List<WeixinVipMemberEntity> getAllDateEndVipInfo(String dateTime) {
        String hql = "from WeixinVipMemberEntity u where u.effectiveDate ='" + dateTime + "' and u.memberStatus!='\u5f85\u7eed\u7ea6'";
        List listMember = this.findByQueryString(hql);
        return listMember;
    }

    @Override
    public Long getAllScore(String memberId) {
        String sql = "SELECT sum(INTEGRAL) AS totalScore FROM weixin_vip_integral WHERE member_id = ?";
        return this.getCountForJdbcParam(sql, new String[]{memberId});
    }
}

