/*
 * Decompiled with CFR 0.152.
 */
package weixin.vip.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.SendMsgUtils;
import weixin.huodong.entity.WxZhongjiangEntity;
import weixin.huodong.service.WxZhongjiangServiceI;
import weixin.idea.huodong.entity.PrizeRecordEntity;
import weixin.idea.huodong.service.PrizeRecordServiceI;
import weixin.promotion.entity.MemberCouponEntity;
import weixin.promotion.entity.PromotionCouponEntity;
import weixin.promotion.service.MemberCouponServiceI;
import weixin.promotion.service.PromotionCouponServiceI;
import weixin.shop.base.entity.WeixinShopAddressEntity;
import weixin.shop.base.entity.WeixinShopIntegralGoodsEntity;
import weixin.shop.base.service.WeixinShopAddressServiceI;
import weixin.shop.base.service.WeixinShopIntegralGoodsServiceI;
import weixin.vip.entity.WeixinVipExchangeRecordEntity;
import weixin.vip.entity.WeixinVipInfoEntity;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.entity.WeixinVipMemberIntegralEntity;
import weixin.vip.entity.WeixinVipMemberValidCodeEntity;
import weixin.vip.service.WeixinVipExchangeRecordServiceI;
import weixin.vip.service.WeixinVipInfoServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;
import weixin.vip.view.VipMyAwardView;

@Controller
@RequestMapping(value={"/weixinVipController"})
public class WeixinVipController
extends BaseController {
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private WeixinAccountServiceI weixinAccountServiceI;
    @Autowired
    private WeixinVipInfoServiceI weixinVipInfoService;
    @Autowired
    private PromotionCouponServiceI promotionCouponService;
    @Autowired
    private UserService userService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinShopAddressServiceI weixinShopAddressService;
    @Autowired
    private WeixinShopIntegralGoodsServiceI weixinShopIntegralGoodsService;
    @Autowired
    private WeixinVipExchangeRecordServiceI weixinVipExchangeRecordService;
    @Autowired
    private WxZhongjiangServiceI wxZhongjiangService;
    @Autowired
    private PrizeRecordServiceI prizeRecordService;
    @Autowired
    private MemberCouponServiceI memberCouponService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        ResourceUtil.initQianTaiRequestAccountId((HttpServletRequest)request);
        String accountid = ResourceUtil.getQianTaiAccountId();
        String openid = request.getParameter("openid");
        if (oConvertUtils.isEmpty((Object)openid)) {
            openid = ResourceUtil.getUserOpenId();
        }
        boolean flag = false;
        HashMap<String, Object> paras = new HashMap<String, Object>();
        String defaultUrl = "/template/vip/default";
        if (!flag) {
            defaultUrl = String.valueOf(defaultUrl) + "/ftl/";
        }
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        WeixinVipMemberEntity vipmember = this.weixinVipMemberService.checkMemberGetOrNot(accountid, openid, ResourceUtil.getSessionUserName().getId());
        if ("bindingMemberPhone".equals(page)) {
            this.loadMemberinfo(paras, accountid, openid, ResourceUtil.getSessionUserName().getId());
        } else if (!"memberinfo".equals(page) && vipmember == null) {
            page = "getvip";
        }
        if ("getvip".equals(page)) {
            this.loadGetvip(paras, accountid, openid, ResourceUtil.getSessionUserName().getId());
        }
        if ("memberinfo".equals(page)) {
            this.loadMemberinfo(paras, accountid, openid, ResourceUtil.getSessionUserName().getId());
        }
        if ("membercard".equals(page)) {
            this.loadMemberCard(paras, vipmember);
        }
        if ("mymembercard".equals(page)) {
            this.loadMyMemberCard(paras, vipmember);
        }
        if ("integraldetail".equals(page)) {
            this.loadIntegraldetal(paras, vipmember, request);
        }
        if ("integralsort".equals(page)) {
            this.loadIntegralsort(paras, vipmember, request);
        }
        if ("exchangelist".equals(page)) {
            this.loadExchangelist(paras, vipmember, request);
        }
        if ("goodsexchange".equals(page)) {
            this.loadGoodsExchange(paras, vipmember, request);
        }
        if ("exchangedlist".equals(page)) {
            this.loadExchangedlist(paras, vipmember, request);
        }
        if ("myawardlist".equals(page)) {
            this.loadMyawardlist(paras, vipmember, request);
        }
        if ("memberinfoupdate".equals(page)) {
            this.loadUpatemember(paras, vipmember, request);
        }
        if ("index".equals(page)) {
            page = "membercard";
            this.loadMemberCard(paras, vipmember);
        }
        if ("member".equals(page)) {
            String accountId = ResourceUtil.getQianTaiAccountId();
            paras.put("WEIXIN_QIANTAI_ACCOUNTID", accountId);
            TSUser user = ResourceUtil.getSessionUserName();
            TSUser u = (TSUser)this.userService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
            user = ResourceUtil.setSessionUserName((TSUser)u);
            paras.put("member", user);
        }
        if ("awarddetail".equals(page)) {
            this.loadAwarddetail(paras, vipmember, request);
        }
        if ("couponlist".equals(page)) {
            this.loadCouponlist(paras, vipmember, request);
        }
        if ("mycouponlist".equals(page)) {
            this.loadMyCouponlist(paras, vipmember, request);
        }
        String pageUrl = String.valueOf(defaultUrl) + page + ".ftl";
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, paras);
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadMyCouponlist(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        List<MemberCouponEntity> mycouponlist = this.memberCouponService.loadMyCouponList(vipmember.getId());
        paras.put("couponlist", mycouponlist);
        paras.put("member", vipmember);
    }

    @RequestMapping(params={"getCoupon"})
    @ResponseBody
    private AjaxJson getCoupon(HttpServletRequest request, String memberid, String couponid) {
        AjaxJson json = new AjaxJson();
        PromotionCouponEntity coupon = (PromotionCouponEntity)this.promotionCouponService.get(PromotionCouponEntity.class, (Serializable)((Object)couponid));
        if (coupon.getQuantity() == 0) {
            json.setSuccess(false);
            json.setMsg("\u4f18\u60e0\u5238\u5df2\u7ecf\u88ab\u9886\u5b8c\uff0c\u4e0d\u80fd\u518d\u9886\u53d6\u3002");
            return json;
        }
        MemberCouponEntity mc = this.memberCouponService.getMemberCouponEntity(memberid, couponid);
        if (mc != null) {
            mc.setQuantity(mc.getQuantity() + 1);
            PromotionCouponEntity pcoupon = (PromotionCouponEntity)this.promotionCouponService.get(PromotionCouponEntity.class, (Serializable)((Object)couponid));
            pcoupon.setQuantity(pcoupon.getQuantity() - 1);
            this.promotionCouponService.updateEntitie(pcoupon);
        } else {
            mc = new MemberCouponEntity();
            PromotionCouponEntity pcoupon = (PromotionCouponEntity)this.promotionCouponService.get(PromotionCouponEntity.class, (Serializable)((Object)couponid));
            coupon.setId(couponid);
            mc.setCoupon(pcoupon);
            WeixinVipMemberEntity vipmember = new WeixinVipMemberEntity();
            vipmember.setId(memberid);
            mc.setMemberVip(vipmember);
            mc.setQuantity(1);
            pcoupon.setQuantity(pcoupon.getQuantity() - 1);
            this.memberCouponService.save(mc);
            this.promotionCouponService.updateEntitie(pcoupon);
        }
        json.setSuccess(true);
        json.setMsg("\u9886\u53d6\u6210\u529f");
        return json;
    }

    private void loadCouponlist(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        List<PromotionCouponEntity> couponlist = this.promotionCouponService.findAllCouponEntity(vipmember.getAccountid());
        paras.put("member", vipmember);
        paras.put("couponlist", couponlist);
    }

    private void loadAwarddetail(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        Serializable record;
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String awardid = request.getParameter("awardid");
        String classname = request.getParameter("classname");
        VipMyAwardView view = new VipMyAwardView();
        TSTypegroup group = this.systemService.getTypeGroupByCode("express");
        List lst = group.getTSTypes();
        if (PrizeRecordEntity.class.toString().equals(classname)) {
            record = (PrizeRecordEntity)this.systemService.get(PrizeRecordEntity.class, (Serializable)((Object)awardid));
            view.setId(((PrizeRecordEntity)record).getId());
            view.setAddress(((PrizeRecordEntity)record).getAddress());
            view.setExpress(((PrizeRecordEntity)record).getExpressname());
            view.setExpressnumber(((PrizeRecordEntity)record).getExpressnumber());
            view.setGoodsname(((PrizeRecordEntity)record).getPrize());
            view.setRealname(((PrizeRecordEntity)record).getUsername());
            view.setSendstatus(((PrizeRecordEntity)record).getSendstatus());
            view.setTel(((PrizeRecordEntity)record).getMobile());
            view.setClassname(PrizeRecordEntity.class.toString());
            for (TSType t : lst) {
                if (!t.getTypecode().equals(view.getExpress())) continue;
                view.setExpressname(t.getTypename());
                break;
            }
            view.setType("\u6d3b\u52a8\u5956\u54c1");
        }
        if (WxZhongjiangEntity.class.toString().equals(classname)) {
            record = (WxZhongjiangEntity)this.systemService.get(WxZhongjiangEntity.class, (Serializable)((Object)awardid));
            view.setId(((WxZhongjiangEntity)record).getId());
            view.setAddress(((WxZhongjiangEntity)record).getUserAddress());
            view.setExpress(((WxZhongjiangEntity)record).getExpressname());
            view.setExpressnumber(((WxZhongjiangEntity)record).getExpressnumber());
            view.setGoodsname(((WxZhongjiangEntity)record).getJpName());
            view.setRealname(((WxZhongjiangEntity)record).getUserAnme());
            view.setSendstatus(((WxZhongjiangEntity)record).getSendstatus());
            view.setTel(((WxZhongjiangEntity)record).getUserTelphone());
            view.setClassname(WxZhongjiangEntity.class.toString());
            for (TSType t : lst) {
                if (!t.getTypecode().equals(view.getExpress())) continue;
                view.setExpressname(t.getTypename());
                break;
            }
            view.setType("\u6d3b\u52a8\u5956\u54c1");
        }
        if (WeixinVipExchangeRecordEntity.class.toString().equals(classname)) {
            record = (WeixinVipExchangeRecordEntity)this.systemService.get(WeixinVipExchangeRecordEntity.class, (Serializable)((Object)awardid));
            view.setAddress(String.valueOf(((WeixinVipExchangeRecordEntity)record).getProvince()) + " " + ((WeixinVipExchangeRecordEntity)record).getCity() + " " + ((WeixinVipExchangeRecordEntity)record).getArea() + " " + ((WeixinVipExchangeRecordEntity)record).getDetailaddress());
            view.setExpress(((WeixinVipExchangeRecordEntity)record).getExpressname());
            view.setExpressnumber(((WeixinVipExchangeRecordEntity)record).getExpressnumber());
            view.setGoodsname(((WeixinVipExchangeRecordEntity)record).getGoodstitle());
            view.setRealname(((WeixinVipExchangeRecordEntity)record).getRealname());
            view.setSendstatus(((WeixinVipExchangeRecordEntity)record).getSendstatus());
            view.setTel(((WeixinVipExchangeRecordEntity)record).getMobilenumber());
            view.setId(((WeixinVipExchangeRecordEntity)record).getId());
            view.setClassname(WeixinVipExchangeRecordEntity.class.toString());
            for (TSType t : lst) {
                if (!t.getTypecode().equals(view.getExpress())) continue;
                view.setExpressname(t.getTypename());
                break;
            }
            view.setType("\u6d3b\u52a8\u5956\u54c1");
        }
        paras.put("domain", bundler.getString("domain"));
        String url = "";
        try {
            url = URLEncoder.encode(String.valueOf(bundler.getString("domain")) + "/weixinVipController.do?goPage&page=awarddetail&awardid=" + view.getId() + "&classname=" + classname, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        paras.put("record", view);
        paras.put("url", url);
    }

    private void loadUpatemember(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        paras.put("member", vipmember);
    }

    private void loadMyawardlist(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        ArrayList<Object> viewlist = new ArrayList<Object>();
        String userid = vipmember.getTsuer().getId();
        List zhongjianglist = this.systemService.findByProperty(WxZhongjiangEntity.class, "user.id", (Object)userid);
        for (WxZhongjiangEntity z : zhongjianglist) {
            VipMyAwardView view = new VipMyAwardView();
            view.setId(z.getId());
            view.setClassname(WxZhongjiangEntity.class.toString());
            view.setGoodsname(z.getJpName());
            view.setRealname(z.getUserAnme());
            view.setSendstatus(z.getSendstatus());
            view.setTel(z.getUserTelphone());
            view.setType("\u7ebf\u4e0a\u5151\u5956");
            view.setExpress(z.getExpressname());
            view.setExpressnumber(z.getExpressnumber());
            viewlist.add(view);
        }
        List addresslist = this.weixinShopAddressService.findByProperty(WeixinShopAddressEntity.class, "userid", userid);
        for (WeixinShopAddressEntity addr : addresslist) {
            String hql = " FROM WxZhongjiangEntity zj WHERE zj.userAnme ='" + addr.getRealname() + "' AND zj.userTelphone = '" + addr.getTel() + "'";
            List zhongjianglist2 = this.systemService.findByQueryString(hql);
            block2: for (WxZhongjiangEntity z2 : zhongjianglist2) {
                for (WxZhongjiangEntity z : zhongjianglist) {
                    if (z2.getId().equals(z.getId())) continue block2;
                    VipMyAwardView view = new VipMyAwardView();
                    view.setClassname(WxZhongjiangEntity.class.toString());
                    view.setGoodsname(z2.getJpName());
                    view.setRealname(z2.getUserAnme());
                    view.setSendstatus(z2.getSendstatus());
                    view.setTel(z2.getUserTelphone());
                    view.setType("\u7ebf\u4e0b\u5151\u5956");
                    view.setExpress(z2.getExpressname());
                    view.setExpressnumber(z2.getExpressnumber());
                    view.setId(z2.getId());
                    viewlist.add(view);
                }
            }
        }
        List exchangerecordlist = this.weixinVipExchangeRecordService.findByProperty(WeixinVipExchangeRecordEntity.class, "member.id", vipmember.getId());
        for (WeixinVipExchangeRecordEntity record : exchangerecordlist) {
            VipMyAwardView view = new VipMyAwardView();
            view.setClassname(WeixinVipExchangeRecordEntity.class.toString());
            view.setGoodsname(record.getGoodstitle());
            view.setRealname(record.getRealname());
            view.setSendstatus(record.getSendstatus());
            view.setTel(record.getMobilenumber());
            view.setType("\u79ef\u5206\u5151\u6362");
            view.setExpress(record.getExpressname());
            view.setExpressnumber(record.getExpressnumber());
            view.setId(record.getId());
            viewlist.add(view);
        }
        List<PrizeRecordEntity> prizelist = this.prizeRecordService.listRecord(vipmember.getOpenid(), vipmember.getAccountid());
        for (PrizeRecordEntity record : prizelist) {
            VipMyAwardView view = new VipMyAwardView();
            view.setClassname(PrizeRecordEntity.class.toString());
            view.setGoodsname(record.getPrize());
            view.setRealname(record.getUsername());
            view.setSendstatus(record.getSendstatus());
            view.setTel(record.getMobile());
            view.setType("\u6d3b\u52a8\u5956\u54c1");
            view.setId(record.getId());
            view.setExpress(record.getExpressname());
            view.setExpressnumber(record.getExpressnumber());
            viewlist.add(view);
        }
        paras.put("awardlist", viewlist);
        paras.put("member", vipmember);
    }

    private void loadExchangedlist(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        String memberid = request.getParameter("memberid");
        List recordlist = this.weixinVipExchangeRecordService.findByProperty(WeixinVipExchangeRecordEntity.class, "member.id", memberid);
        paras.put("recordlist", recordlist);
        paras.put("member", vipmember);
    }

    private void loadGoodsExchange(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        String memberid = request.getParameter("memberid");
        String goodsid = request.getParameter("goodsid");
        String needintegral = request.getParameter("needintegral");
        String recordid = request.getParameter("recordid");
        WeixinShopIntegralGoodsEntity goods = (WeixinShopIntegralGoodsEntity)this.systemService.get(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)goodsid));
        WeixinVipExchangeRecordEntity record = (WeixinVipExchangeRecordEntity)this.weixinVipMemberService.get(WeixinVipExchangeRecordEntity.class, (Serializable)((Object)recordid));
        List addresslist = this.weixinShopAddressService.findByProperty(WeixinShopAddressEntity.class, "userid", ResourceUtil.getSessionUserName().getId());
        paras.put("addresslist", addresslist);
        paras.put("member", vipmember);
        paras.put("goods", goods);
        paras.put("record", record);
    }

    private void loadExchangelist(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        List<WeixinShopIntegralGoodsEntity> goodslist = this.weixinShopIntegralGoodsService.getIntegralGoods(vipmember);
        paras.put("member", vipmember);
        paras.put("goodslist", goodslist);
    }

    private void loadIntegralsort(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        List memberlist = this.weixinVipMemberService.findByQueryString(" FROM WeixinVipMemberEntity m WHERE m.accountid='" + vipmember.getAccountid() + "' order by memberIntegral DESC ");
        paras.put("memberlist", memberlist);
        paras.put("member", vipmember);
    }

    private void loadIntegraldetal(Map<String, Object> paras, WeixinVipMemberEntity vipmember, HttpServletRequest request) {
        String detailtype = request.getParameter("detailtype") != null ? request.getParameter("detailtype").toString() : "";
        List<WeixinVipMemberIntegralEntity> integrallist = this.weixinVipMemberService.getIntegeraDetail(vipmember.getId(), detailtype);
        paras.put("integrallist", integrallist);
        paras.put("member", vipmember);
        paras.put("detailtype", detailtype);
    }

    private void loadMyMemberCard(Map<String, Object> paras, WeixinVipMemberEntity vipmember) {
        paras.put("member", vipmember);
        paras.put("vipcard", vipmember.getVipInfo());
    }

    private void loadMemberCard(Map<String, Object> paras, WeixinVipMemberEntity member) {
        paras.put("member", member);
        paras.put("vipcard", member.getVipInfo());
        String orderhql = " FROM WeixinVipMemberEntity m where m.accountid='" + member.getAccountid() + "' ORDER BY m.memberIntegral desc ";
        List memberlist = this.weixinVipMemberService.findByQueryString(orderhql);
        int location = 0;
        for (WeixinVipMemberEntity m : memberlist) {
            ++location;
            if (m.getId().equals(member.getId())) break;
        }
        paras.put("location", location);
    }

    private void loadMemberinfo(Map<String, Object> paras, String accountid, String openid, String userid) {
        paras.put("accountid", accountid);
        paras.put("openid", openid);
        paras.put("userid", userid);
        WeixinVipMemberEntity memberEntity = (WeixinVipMemberEntity)this.systemService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", (Object)openid);
        if (memberEntity != null) {
            paras.put("isBinding", memberEntity.getBindingMemberPhoneStatus());
            paras.put("bindingMobile", memberEntity.getMemberMobile());
        } else {
            paras.put("isBinding", "N");
            paras.put("bindingMobile", "");
        }
    }

    private void loadGetvip(Map<String, Object> paras, String accountid, String openid, String userid) {
        paras.put("accountid", accountid);
        paras.put("openid", openid);
        paras.put("userid", userid);
    }

    @RequestMapping(params={"addVipMember"})
    @ResponseBody
    public AjaxJson addMemberNew(HttpServletRequest request, WeixinVipMemberEntity member) {
        AjaxJson json = new AjaxJson();
        String userid = request.getParameter("userid");
        TSUser user = new TSUser();
        user.setId(userid);
        member.setTsuer(user);
        WeixinVipInfoEntity defaultvipinfo = this.weixinVipInfoService.getDefaultVipCard(member.getAccountid());
        if (defaultvipinfo != null) {
            member.setVipInfo(defaultvipinfo);
            member.setCreateTime(new Date());
            member.setVipInfo(defaultvipinfo);
            member.setMemberIntegral(0);
            member.setMemberPhoto("template/vip/default/css/new/images/defaulthead.png");
            member.setAccountid(member.getAccountid());
            this.weixinVipMemberService.saveOrUpdate(member);
            json.setSuccess(true);
            json.setMsg("\u4f1a\u5458\u5361\u9886\u53d6\u6210\u529f\u3002");
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("url", "weixinVipController.do?goPage&page=index&accountid=" + member.getAccountid() + "&openid=" + member.getOpenid() + "&userid=" + member.getTsuer().getId());
            json.setAttributes(attrs);
        } else {
            json.setSuccess(false);
            json.setMsg("\u5546\u5bb6\u672a\u914d\u7f6e\u4f1a\u5458\u5361\u4fe1\u606f\uff0c\u4e0d\u80fd\u9886\u53d6\u4f1a\u5458\u5361\u3002");
        }
        return json;
    }

    @RequestMapping(params={"updateVipMember"})
    @ResponseBody
    public AjaxJson updateVipMember(HttpServletRequest request, WeixinVipMemberEntity member) {
        AjaxJson json = new AjaxJson();
        WeixinVipMemberEntity memberupdate = (WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)member.getId()));
        memberupdate.setMemberRealName(member.getMemberRealName());
        memberupdate.setMemberEmail(member.getMemberEmail());
        memberupdate.setMemberMobile(member.getMemberMobile());
        this.weixinVipMemberService.updateEntitie(memberupdate);
        json.setSuccess(true);
        json.setMsg("\u4f1a\u5458\u4fe1\u606f\u4fee\u6539\u6210\u529f");
        return json;
    }

    private WeixinVipMemberEntity loadIndex() {
        TSUser user = ResourceUtil.getSessionUserName();
        String hql = "from WeixinVipMemberEntity where tsuer='" + user.getId() + "'";
        List weixinShopCategoryList = this.weixinVipMemberService.findByQueryString(hql);
        if (weixinShopCategoryList != null && weixinShopCategoryList.size() > 0) {
            return (WeixinVipMemberEntity)weixinShopCategoryList.get(0);
        }
        return null;
    }

    @RequestMapping(params={"vipInfo"})
    @ResponseBody
    public AjaxJson vipInfo(HttpServletRequest request) {
        List list;
        AjaxJson j = new AjaxJson();
        String accountid = request.getParameter("accountid");
        if (accountid == null || "".equals(accountid)) {
            j.setMsg("accountid_error");
        }
        if ((list = this.weixinVipInfoService.findByProperty(WeixinVipInfoEntity.class, "accountid", accountid)) == null || list.size() == 0) {
            j.setMsg("vip_zero");
        } else {
            List memberlist;
            TSUser user = ResourceUtil.getSessionUserName();
            if (user == null) {
                j.setMsg("user_error");
            }
            if ((memberlist = this.weixinVipMemberService.findByQueryString("from WeixinVipMemberEntity member where member.vipInfo.id in (" + list.toArray() + ") and member.tsuer.id = " + user.getId())) == null || memberlist.size() == 0) {
                j.setMsg("vip_not_exist");
            } else {
                j.setMsg("vip_exist");
                j.setObj(memberlist.get(0));
            }
        }
        return j;
    }

    @RequestMapping(params={"addvipInfo"})
    @ResponseBody
    public AjaxJson addMemberVip(HttpServletRequest request) {
        List list;
        AjaxJson j = new AjaxJson();
        String accountid = request.getParameter("accountid");
        if (accountid == null || "".equals(accountid)) {
            j.setMsg("accountid_error");
        }
        if ((list = this.weixinVipInfoService.findByQueryString("from WeixinVipInfoEntity vipinfo where vipinfo.accountid='" + accountid + "' order by vipinfo.levelId asc")) == null || list.size() == 0) {
            j.setMsg("vip_zero");
        } else {
            TSUser user = ResourceUtil.getSessionUserName();
            if (user == null) {
                j.setMsg("user_error");
            }
            String ids = "";
            for (WeixinVipInfoEntity v : list) {
                ids = String.valueOf(ids) + "'" + v.getId() + "',";
            }
            List memberlist = this.weixinVipMemberService.findByQueryString("from WeixinVipMemberEntity m where m.vipInfo in (" + (ids = ids.substring(0, ids.length() - 1)) + ") and m.tsuer = '" + user.getId() + "'");
            if (memberlist == null || memberlist.size() == 0) {
                j.setMsg("vip_not_exist");
                WeixinVipMemberEntity memberobj = new WeixinVipMemberEntity();
                memberobj.setMemberBalance(new BigDecimal("0.00"));
                memberobj.setMemberIntegral(0);
                memberobj.setTsuer(user);
                memberobj.setVipInfo((WeixinVipInfoEntity)list.get(0));
                memberobj.setCreateTime(new Date());
                memberobj.setMemberName(user.getUserName());
                this.weixinVipMemberService.save(memberobj);
                this.message = String.valueOf(user.getUserName()) + "\u52a0\u5165\u4f1a\u5458\u6210\u529f!";
                j.setMsg("add_ok");
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            } else {
                j.setMsg("vip_exist");
                j.setObj(memberlist.get(0));
            }
        }
        return j;
    }

    @RequestMapping(params={"updatMember"})
    @ResponseBody
    public AjaxJson updatMember(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            j.setSuccess(Boolean.FALSE.booleanValue());
            String name = request.getParameter("username");
            String email = request.getParameter("email");
            String phone = request.getParameter("phone");
            String userid = request.getParameter("userid");
            TSUser u = (TSUser)this.userService.getEntity(TSUser.class, (Serializable)((Object)userid));
            u.setRealName(name);
            u.setEmail(email);
            u.setMobilePhone(phone);
            this.userService.saveOrUpdate((Object)u);
            List memberlist = this.weixinVipMemberService.findByProperty(WeixinVipMemberEntity.class, "tsuer.id", userid);
            if (memberlist != null && memberlist.size() > 0) {
                for (WeixinVipMemberEntity m : memberlist) {
                    m.setMemberName(name);
                    this.weixinVipMemberService.saveOrUpdate(m);
                }
            }
            j.setSuccess(Boolean.TRUE.booleanValue());
            j.setMsg("\u4f1a\u5458\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            j.setMsg("\u4f1a\u5458\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            j.setSuccess(Boolean.FALSE.booleanValue());
        }
        return j;
    }

    @RequestMapping(params={"updateMemberIntegral"})
    @ResponseBody
    public AjaxJson updateMemberIntegral(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            j.setSuccess(Boolean.FALSE.booleanValue());
            String userid = request.getParameter("userid");
            ResourceUtil.initQianTaiRequestAccountId((HttpServletRequest)request);
            String accountid = ResourceUtil.getQianTaiAccountId();
            Integer integral = Integer.parseInt(request.getParameter("integral"));
            List list = this.weixinVipInfoService.findByQueryString("from WeixinVipInfoEntity vipinfo where vipinfo.accountid='" + accountid + "' order by vipinfo.levelId asc");
            String ids = "";
            for (WeixinVipInfoEntity v : list) {
                ids = String.valueOf(ids) + "'" + v.getId() + "',";
            }
            List memberlist = this.weixinVipMemberService.findByQueryString("from WeixinVipMemberEntity m where m.vipInfo in (" + (ids = ids.substring(0, ids.length() - 1)) + ") and m.tsuer = '" + userid + "'");
            if (memberlist != null && memberlist.size() > 0) {
                WeixinVipMemberEntity membervip = (WeixinVipMemberEntity)memberlist.get(0);
                if (integral > 0) {
                    membervip.setMemberIntegral(membervip.getMemberIntegral() + integral);
                } else if (membervip.getMemberIntegral() + integral >= 0) {
                    membervip.setMemberIntegral(membervip.getMemberIntegral() + integral);
                }
                this.weixinVipMemberService.saveOrUpdate(membervip);
            }
            j.setSuccess(Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            j.setSuccess(Boolean.FALSE.booleanValue());
        }
        return j;
    }

    @RequestMapping(params={"sendValidCodeToPhone"})
    @ResponseBody
    public AjaxJson sendValidCodeToPhone(HttpServletRequest request, HttpServletResponse response, WeixinVipMemberEntity member) {
        AjaxJson json = new AjaxJson();
        String userid = request.getParameter("userid");
        String memberMobile = member.getMemberMobile();
        TSUser user = new TSUser();
        user.setId(userid);
        member.setTsuer(user);
        List memberEntities = this.weixinVipMemberService.findHql("from WeixinVipMemberEntity where openid = ?", new Object[]{member.getOpenid()});
        if (memberEntities.size() > 0) {
            member = (WeixinVipMemberEntity)memberEntities.get(0);
            if ("Y".equals(member.getBindingMemberPhoneStatus())) {
                json.setSuccess(true);
                json.setMsg("\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u7ed1\u5b9a\uff0c\u65e0\u9700\u91cd\u590d\u7ed1\u5b9a");
                return json;
            }
        } else {
            WeixinVipInfoEntity defaultvipinfo = this.weixinVipInfoService.getDefaultVipCard(member.getAccountid());
            if (defaultvipinfo != null) {
                member.setVipInfo(defaultvipinfo);
                member.setCreateTime(new Date());
                member.setMemberIntegral(0);
                member.setBindingMemberPhoneStatus("N");
                member.setMemberPhoto("template/vip/default/css/new/images/defaulthead.png");
                this.weixinVipMemberService.saveOrUpdate(member);
            } else {
                json.setSuccess(false);
                json.setMsg("\u5546\u5bb6\u672a\u914d\u7f6e\u4f1a\u5458\u4fe1\u606f\uff0c\u4e0d\u80fd\u53d1\u9001\u9a8c\u8bc1\u7801\u3002");
                return json;
            }
        }
        String validCode = String.valueOf((int)(Math.random() * 9000.0 + 1000.0));
        LogUtil.info((Object)("\u7ed9" + memberMobile + "\u53d1\u9001\u9a8c\u8bc1\u7801\uff1a" + validCode));
        try {
            SendMsgUtils.sendSMS("\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a" + validCode + ",\u5341\u5206\u949f\u5185\u56de\u590d\u6709\u6548", memberMobile);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg("\u77ed\u4e9b\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return json;
        }
        WeixinVipMemberValidCodeEntity validCodeEntity = new WeixinVipMemberValidCodeEntity();
        validCodeEntity.setValidCode(validCode);
        validCodeEntity.setEfficientTime(DataUtils.getDateAfterSecond((Date)new Date(), (int)600));
        validCodeEntity.setOpenid(member.getOpenid());
        validCodeEntity.setVipMemberId(member.getId());
        this.weixinVipMemberService.saveOrUpdate(validCodeEntity);
        member.setMemberMobile(memberMobile);
        this.systemService.saveOrUpdate((Object)member);
        json.setObj((Object)member.getId());
        json.setSuccess(true);
        json.setMsg("\u9a8c\u8bc1\u7801\u5df2\u7ecf\u53d1\u9001\u8bf7\u67e5\u6536");
        return json;
    }

    @RequestMapping(params={"bindingMemberPhone"})
    @ResponseBody
    public AjaxJson bindingMemberPhone(HttpServletRequest request, HttpServletResponse response, String vipMemberId, String openId, String validCode) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        List codeEntities = this.weixinVipMemberService.findHql("from WeixinVipMemberValidCodeEntity where vipMemberId = ? and openid= ? and efficientTime>= ? ORDER BY efficientTime desc", new Object[]{vipMemberId, openId, new Date()});
        if (codeEntities.size() > 0) {
            WeixinVipMemberValidCodeEntity codeEntity = (WeixinVipMemberValidCodeEntity)codeEntities.get(0);
            if (validCode.equals(codeEntity.getValidCode())) {
                WeixinVipMemberEntity vipMemberEntity = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)vipMemberId));
                vipMemberEntity.setBindingMemberPhoneStatus("Y");
                this.weixinVipMemberService.saveOrUpdate(vipMemberEntity);
                json.setMsg("\u60a8\u7684\u624b\u673a\u53f7\u7801\u7ed1\u5b9a\u6210\u529f");
            } else {
                json.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        } else {
            json.setSuccess(false);
            json.setMsg("\u9a8c\u8bc1\u7801\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\u53d1\u9001");
        }
        return json;
    }

    @RequestMapping(params={"unBindingMemberPhone"})
    @ResponseBody
    public AjaxJson unBindingMemberPhone(HttpServletRequest request, HttpServletResponse response, String openId) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        WeixinVipMemberEntity vipMemberEntity = (WeixinVipMemberEntity)this.weixinVipMemberService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", openId);
        if (vipMemberEntity != null) {
            vipMemberEntity.setMemberMobile("");
            vipMemberEntity.setBindingMemberPhoneStatus("N");
            this.weixinVipMemberService.saveOrUpdate(vipMemberEntity);
            json.setMsg("\u89e3\u7ed1\u6210\u529f");
        } else {
            json.setSuccess(false);
            json.setMsg("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u7ed1\u5b9a");
        }
        return json;
    }
}

