/*
 * Decompiled with CFR 0.152.
 */
package weixin.vip.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.entity.WeixinVipRenewalEntity;
import weixin.vip.service.WeixinVipMemberServiceI;
import weixin.vip.service.WeixinVipRenewalServiceI;

@Controller
@RequestMapping(value={"/weixinVipRenewalController"})
public class WeixinVipRenewalController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVipRenewalController.class);
    @Autowired
    private WeixinVipRenewalServiceI weixinVipRenewalService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVipRenewal"})
    public ModelAndView weixinVipRenewal(HttpServletRequest request) {
        return new ModelAndView("weixin/vip/weixinVipMemberSelect");
    }

    @RequestMapping(params={"detail"})
    public ModelAndView memberSelect(WeixinVipMemberEntity memberEntity, HttpServletRequest request) {
        request.setAttribute("memberid", (Object)memberEntity.getId());
        return new ModelAndView("weixin/vip/weixinVipRenewalList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVipRenewalEntity weixinVipRenewal, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipRenewalEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVipRenewal, (Map)request.getParameterMap());
        String memberId = request.getParameter("memberid");
        cq.eq("member.id", (Object)memberId);
        cq.add();
        this.weixinVipRenewalService.getDataGridReturn(cq, true);
        ArrayList list = new ArrayList();
        for (WeixinVipRenewalEntity entity : dataGrid.getResults()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("memberName", entity.getMember().getMemberName());
            m.put("memberRealName", entity.getMember().getMemberRealName());
            m.put("id", entity.getId());
            m.put("amount", entity.getAmount());
            m.put("memberid", entity.getMember().getId());
            m.put("createDate", DateFormatUtils.format((Date)entity.getCreateDate(), (String)"yyyy-MM-dd"));
            list.add(m);
        }
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinVipRenewalEntity weixinVipRenewal, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVipRenewal = (WeixinVipRenewalEntity)this.systemService.getEntity(WeixinVipRenewalEntity.class, (Serializable)((Object)weixinVipRenewal.getId()));
        this.message = "\u4f1a\u5458\u7eed\u8d39\u5220\u9664\u6210\u529f";
        try {
            this.weixinVipRenewalService.delete(weixinVipRenewal);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4f1a\u5458\u7eed\u8d39\u5220\u9664\u5931\u8d25";
            j.setSuccess(false);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4f1a\u5458\u7eed\u8d39\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinVipRenewalEntity weixinVipRenewal = (WeixinVipRenewalEntity)this.systemService.getEntity(WeixinVipRenewalEntity.class, (Serializable)((Object)id));
                this.weixinVipRenewalService.delete(weixinVipRenewal);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4f1a\u5458\u7eed\u8d39\u5220\u9664\u5931\u8d25";
            j.setSuccess(false);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinVipRenewalEntity weixinVipRenewal, WeixinVipMemberEntity member, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4f1a\u5458\u7eed\u8d39\u6dfb\u52a0\u6210\u529f";
        String memberId = request.getParameter("memberid");
        try {
            WeixinVipMemberEntity membernew = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)memberId));
            membernew.setMemberStatus("\u6d3b\u8dc3");
            membernew.setMemberBalance(membernew.getMemberBalance().add(BigDecimal.valueOf(weixinVipRenewal.getAmount())));
            weixinVipRenewal.setMember(membernew);
            this.weixinVipRenewalService.save(weixinVipRenewal);
            this.weixinVipMemberService.save(membernew);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4f1a\u5458\u7eed\u8d39\u6dfb\u52a0\u5931\u8d25";
            j.setSuccess(false);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinVipRenewalEntity weixinVipRenewal, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4f1a\u5458\u7eed\u8d39\u66f4\u65b0\u6210\u529f";
        WeixinVipRenewalEntity t = (WeixinVipRenewalEntity)this.weixinVipRenewalService.get(WeixinVipRenewalEntity.class, (Serializable)((Object)weixinVipRenewal.getId()));
        String memberId = request.getParameter("memberid");
        WeixinVipMemberEntity member = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)memberId));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVipRenewal, (Object)t);
            t.setMember(member);
            this.weixinVipRenewalService.saveOrUpdate(t);
            member.setMemberStatus("\u6d3b\u8dc3");
            this.weixinVipMemberService.save(member);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4f1a\u5458\u7eed\u8d39\u66f4\u65b0\u5931\u8d25";
            j.setMsg(this.message);
            j.setSuccess(false);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinVipMemberEntity memberEntity, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)memberEntity.getId())) {
            WeixinVipMemberEntity member = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)memberEntity.getId()));
            req.setAttribute("member", (Object)member);
        }
        return new ModelAndView("weixin/vip/weixinVipRenewal-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinVipRenewalEntity weixinVipRenewal, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVipRenewal.getId())) {
            weixinVipRenewal = (WeixinVipRenewalEntity)this.weixinVipRenewalService.getEntity(WeixinVipRenewalEntity.class, (Serializable)((Object)weixinVipRenewal.getId()));
            req.setAttribute("weixinVipRenewalPage", (Object)weixinVipRenewal);
            req.setAttribute("memberid", (Object)weixinVipRenewal.getMember().getId());
        }
        return new ModelAndView("weixin/vip/weixinVipRenewal-update");
    }
}

