/*
 * Decompiled with CFR 0.152.
 */
package weixin.vip.controller;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.RoletoJson;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import weixin.cms.entity.OrderPersonsEntity;
import weixin.cms.entity.OrderTicketEntity;
import weixin.shop.base.entity.WeixinShopAddressEntity;
import weixin.shop.base.entity.WeixinShopIntegralGoodsEntity;
import weixin.vip.entity.WeixinVipExchangeRecordEntity;
import weixin.vip.entity.WeixinVipInfoEntity;
import weixin.vip.entity.WeixinVipIntegralType;
import weixin.vip.entity.WeixinVipMemberDetailEntity;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.entity.WeixinVipMemberIntegralEntity;
import weixin.vip.entity.WeixinVipMemberLog;
import weixin.vip.entity.WeixinVipMembersType;
import weixin.vip.service.WeixinVipExchangeRecordServiceI;
import weixin.vip.service.WeixinVipInfoServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Controller
@RequestMapping(value={"/weixinVipMemberController"})
public class WeixinVipMemberController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVipMemberController.class);
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private WeixinVipInfoServiceI weixinVipInfoService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinVipExchangeRecordServiceI weixinVipExchangeRecordService;
    private String message;
    private static final String POINT = ".";

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVipExchangeRecord"})
    public ModelAndView weixinVipExchangeRecord(HttpServletRequest request) {
        return new ModelAndView("weixin/vip/weixinVipExchangeRecordList");
    }

    @RequestMapping(params={"exchangeRecordDatagrid"})
    public void exchangeRecordDatagrid(WeixinVipExchangeRecordEntity record, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipExchangeRecordEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)record, (Map)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        this.weixinVipMemberService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"weixinVipMember"})
    public ModelAndView weixinVipMember(HttpServletRequest request) {
        List memberTypeList = this.systemService.getList(WeixinVipMembersType.class);
        request.setAttribute("memTypeReplace", (Object)RoletoJson.listToReplaceStr((List)memberTypeList, (String)"members_type", (String)"id"));
        for (WeixinVipMembersType weixinVipMembersType : memberTypeList) {
            if (!weixinVipMembersType.getMembers_type().equals("\u5fd7\u613f\u8005")) continue;
            request.setAttribute("memberType_id", (Object)weixinVipMembersType.getId());
        }
        return new ModelAndView("weixin/vip/weixinVipMemberList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVipMemberEntity weixinVipMember, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipMemberEntity.class, dataGrid);
        weixinVipMember.setAccountid(ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVipMember, (Map)request.getParameterMap());
        this.weixinVipMemberService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinVipMemberEntity weixinVipMember, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVipMember = (WeixinVipMemberEntity)this.systemService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)weixinVipMember.getId()));
        this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u548c\u7528\u6237\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f";
        this.weixinVipMemberService.delete(weixinVipMember);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinVipMemberEntity weixinVipMember, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVipMember.setTsuer(ResourceUtil.getSessionUserName());
        if (StringUtil.isNotEmpty((Object)weixinVipMember.getId())) {
            this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u548c\u7528\u6237\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f";
            WeixinVipMemberEntity t = (WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)weixinVipMember.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVipMember, (Object)t);
                this.weixinVipMemberService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u548c\u7528\u6237\u5173\u7cfb\u8868\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u548c\u7528\u6237\u5173\u7cfb\u8868\u6dfb\u52a0\u6210\u529f";
            WeixinVipMembersType type = (WeixinVipMembersType)this.weixinVipMemberService.getEntity(WeixinVipMembersType.class, (Serializable)((Object)weixinVipMember.getMemberType().getId()));
            if (type.getMembers_type().equals("\u4e34\u65f6\u4f1a\u5458")) {
                weixinVipMember.setVerifyStatus("3");
            } else {
                weixinVipMember.setVerifyStatus("0");
            }
            this.weixinVipMemberService.save(weixinVipMember);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinVipMemberEntity weixinVipMember, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVipMember.getId())) {
            weixinVipMember = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)weixinVipMember.getId()));
            req.setAttribute("weixinVipMemberPage", (Object)weixinVipMember);
        }
        List vipMembersTypeList = this.systemService.findHql("from WeixinVipMembersType t where t.accountid = ?", new Object[]{ResourceUtil.getShangJiaAccountId()});
        List weixinVipInfoList = this.systemService.findHql("from WeixinVipInfoEntity t where t.accountid = ?", new Object[]{ResourceUtil.getShangJiaAccountId()});
        req.setAttribute("memberTypes", (Object)vipMembersTypeList);
        req.setAttribute("LEVEL", (Object)weixinVipInfoList);
        return new ModelAndView("weixin/vip/weixinVipMember");
    }

    @RequestMapping(params={"addorupdateDetailInfo"})
    public ModelAndView addorupdateDetailInfo(HttpServletRequest req) {
        String memberId = req.getParameter("memberId");
        req.setAttribute("memberId", (Object)memberId);
        if (StringUtil.isNotEmpty((Object)memberId)) {
            WeixinVipMemberDetailEntity weixinVipMemberDetail = (WeixinVipMemberDetailEntity)this.weixinVipMemberService.findUniqueByProperty(WeixinVipMemberDetailEntity.class, "member.id", memberId);
            req.setAttribute("weixinVipMemberDetail", (Object)weixinVipMemberDetail);
        }
        return new ModelAndView("weixin/vip/weixinVipMemberDetailInfo");
    }

    @RequestMapping(params={"addorupdateDetailSave"})
    @ResponseBody
    public AjaxJson addorupdateDetailSave(WeixinVipMemberDetailEntity weixinVipMemberDetail, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        weixinVipMemberDetail.setMember((WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)req.getParameter("memberId"))));
        if (StringUtil.isNotEmpty((Object)weixinVipMemberDetail.getId())) {
            this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u66f4\u65b0\u6210\u529f";
            WeixinVipMemberDetailEntity t = (WeixinVipMemberDetailEntity)this.weixinVipMemberService.get(WeixinVipMemberDetailEntity.class, (Serializable)((Object)weixinVipMemberDetail.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVipMemberDetail, (Object)t);
                this.weixinVipMemberService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u6dfb\u52a0\u6210\u529f";
            this.weixinVipMemberService.save(weixinVipMemberDetail);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"verify"})
    public ModelAndView verify(HttpServletRequest req) {
        String memberId = req.getParameter("memberId");
        req.setAttribute("member", this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)memberId)));
        return new ModelAndView("weixin/vip/weixinVipMemberVerify");
    }

    @RequestMapping(params={"doVerify"})
    @ResponseBody
    public AjaxJson doVerify(HttpServletRequest req) {
        WeixinVipMemberLog memberLog = new WeixinVipMemberLog();
        String memberId = req.getParameter("memberId");
        String memberVipCode = req.getParameter("memberVipCode");
        String memberRemarks = req.getParameter("memberRemarks");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, 1);
        String value = req.getParameter("value");
        AjaxJson j = new AjaxJson();
        this.message = "\u64cd\u4f5c\u6210\u529f";
        WeixinVipMemberEntity weixinVipMember = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)memberId));
        weixinVipMember.setMemberVipCode(memberVipCode);
        weixinVipMember.setVerifyStatus(value);
        weixinVipMember.setDealDate(new Date());
        weixinVipMember.setEffectiveDate(calendar.getTime());
        weixinVipMember.setMemberRemarks(memberRemarks);
        weixinVipMember.setOperator(ResourceUtil.getSessionUserName());
        if ("1".equals(value)) {
            weixinVipMember.setMemberStatus("\u6d3b\u8dc3");
            memberLog.setOp_detail("\u4f1a\u5458\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7\u3002");
        } else {
            memberLog.setOp_detail("\u4f1a\u5458\u7533\u8bf7\u5ba1\u6838\u4e0d\u901a\u8fc7\u3002");
        }
        this.weixinVipMemberService.saveOrUpdate(weixinVipMember);
        memberLog.setMember(weixinVipMember);
        memberLog.setUser(ResourceUtil.getSessionUserName());
        memberLog.setOp_time(new Date());
        this.weixinVipMemberService.save(memberLog);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"changeCredent"})
    @ResponseBody
    public AjaxJson changeCredent(HttpServletRequest req) {
        WeixinVipMemberLog memberLog = new WeixinVipMemberLog();
        String memberId = req.getParameter("memberId");
        String value = req.getParameter("value");
        AjaxJson j = new AjaxJson();
        this.message = "\u64cd\u4f5c\u6210\u529f";
        WeixinVipMemberEntity weixinVipMember = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)memberId));
        weixinVipMember.setDealDate(new Date());
        weixinVipMember.setOperator(ResourceUtil.getSessionUserName());
        if ("1".equals(value)) {
            weixinVipMember.setMemberStatus("\u8d44\u683c\u53d6\u6d88");
            memberLog.setOp_detail("\u4f1a\u5458\u8d44\u683c\u53d6\u6d88");
        } else {
            weixinVipMember.setMemberStatus("\u6d3b\u8dc3");
            memberLog.setOp_detail("\u4f1a\u5458\u8d44\u683c\u6062\u590d");
        }
        this.weixinVipMemberService.saveOrUpdate(weixinVipMember);
        memberLog.setMember(weixinVipMember);
        memberLog.setUser(ResourceUtil.getSessionUserName());
        memberLog.setOp_time(new Date());
        this.weixinVipMemberService.save(memberLog);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"wxVipMemberVerifyList"})
    public ModelAndView wxVipMemberVerifyList(HttpServletRequest request) {
        List memberTypeList = this.systemService.getList(WeixinVipMembersType.class);
        request.setAttribute("memTypeReplace", (Object)RoletoJson.listToReplaceStr((List)memberTypeList, (String)"members_type", (String)"id"));
        return new ModelAndView("weixin/vip/wxVipMemberVerifyList");
    }

    @RequestMapping(params={"wxVipMemberCredentList"})
    public ModelAndView wxVipMemberCredentList(HttpServletRequest request) {
        return new ModelAndView("weixin/vip/wxVipMemberCredentList");
    }

    @RequestMapping(params={"wxVipMemberIntegralList"})
    public ModelAndView wxVipMemberIntegralList(HttpServletRequest request) {
        List intypeList = this.systemService.getList(WeixinVipIntegralType.class);
        List memberList = this.systemService.getList(WeixinVipMemberEntity.class);
        request.setAttribute("typeReplace", (Object)RoletoJson.listToReplaceStr((List)intypeList, (String)"integral_type", (String)"id"));
        request.setAttribute("membReplace", (Object)RoletoJson.listToReplaceStr((List)memberList, (String)"memberName", (String)"id"));
        return new ModelAndView("weixin/vip/wxVipMemberIntegralList");
    }

    @RequestMapping(params={"addorupdateIntegral"})
    public ModelAndView addorupdateIntegral(HttpServletRequest req, WeixinVipMemberIntegralEntity IntegralEntity) {
        if (StringUtil.isNotEmpty((Object)IntegralEntity.getId())) {
            WeixinVipMemberIntegralEntity weixinVipMemberIntegral = (WeixinVipMemberIntegralEntity)this.weixinVipMemberService.get(WeixinVipMemberIntegralEntity.class, (Serializable)((Object)IntegralEntity.getId()));
            req.setAttribute("weixinVipMemberIntegral", (Object)weixinVipMemberIntegral);
        }
        List vipMembersTypeList = this.systemService.findHql("from WeixinVipIntegralType t where t.accountid = ?", new Object[]{ResourceUtil.getShangJiaAccountId()});
        List weixinvipmemberList = this.systemService.findHql("from WeixinVipMemberEntity t where t.accountid = ?", new Object[]{ResourceUtil.getShangJiaAccountId()});
        req.setAttribute("integralType", (Object)vipMembersTypeList);
        req.setAttribute("members", (Object)weixinvipmemberList);
        return new ModelAndView("weixin/vip/weixinVipMemberIntegral");
    }

    @RequestMapping(params={"integralDatagrid"})
    public void integralDatagrid(WeixinVipMemberIntegralEntity weixinVipIntegral, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipMemberIntegralEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVipIntegral, (Map)request.getParameterMap());
        this.weixinVipMemberService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"integralForFrontDatagrid"})
    public void integralForFrontDatagrid(WeixinVipMemberIntegralEntity weixinVipIntegral, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String memberId = request.getParameter("memberId");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)memberId)) {
            memberId = "-1";
        }
        CriteriaQuery cq = new CriteriaQuery(WeixinVipMemberIntegralEntity.class, dataGrid);
        cq.eq("member.id", (Object)memberId);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVipIntegral, (Map)request.getParameterMap());
        this.weixinVipMemberService.getDataGridReturn(cq, true);
        ArrayList list = new ArrayList();
        for (WeixinVipMemberIntegralEntity entity : dataGrid.getResults()) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("createTime", entity.getCreateTime() == null ? "" : DateFormatUtils.format((Date)entity.getCreateTime(), (String)"yyyy-MM-dd"));
            m.put("integral", entity.getIntegral());
            m.put("integralType", entity.getIntegralType().getIntegral_type());
            list.add(m);
        }
        dataGrid.setResults(list);
        Long totalScore = this.weixinVipMemberService.getAllScore(memberId);
        String footer = "totalScore:" + totalScore;
        cq.getDataGrid().setFooter(footer);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"integralSave"})
    @ResponseBody
    public AjaxJson integralSave(WeixinVipMemberIntegralEntity integralEntity, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        WeixinVipMemberEntity member = (WeixinVipMemberEntity)this.weixinVipMemberService.getEntity(WeixinVipMemberEntity.class, (Serializable)((Object)integralEntity.getMember().getId()));
        int integral = member.getMemberIntegral() + Integer.parseInt(integralEntity.getIntegral());
        member.setMemberIntegral(integral);
        if (StringUtil.isNotEmpty((Object)integralEntity.getId())) {
            this.message = "\u4f1a\u5458\u79ef\u5206\u66f4\u65b0\u6210\u529f";
            WeixinVipMemberIntegralEntity t = (WeixinVipMemberIntegralEntity)this.weixinVipMemberService.get(WeixinVipMemberIntegralEntity.class, (Serializable)((Object)integralEntity.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)integralEntity, (Object)t);
                this.weixinVipMemberService.saveOrUpdate(t);
                this.weixinVipMemberService.saveOrUpdate(member);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4f1a\u5458\u79ef\u5206\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u4f1a\u5458\u79ef\u5206\u6dfb\u52a0\u6210\u529f";
            this.weixinVipMemberService.save(integralEntity);
            this.weixinVipMemberService.saveOrUpdate(member);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doMemberLogin"})
    public ModelAndView doMemberLogin(HttpServletRequest request) {
        WeixinVipMemberEntity t = (WeixinVipMemberEntity)request.getSession().getAttribute("memberSession");
        String accountid = t == null ? "" : t.getAccountid();
        String pageUrl = "rest/cmsController/page/memberCenter";
        return new ModelAndView((View)new RedirectView(pageUrl));
    }

    @RequestMapping(params={"isMemberLogin"})
    @ResponseBody
    public AjaxJson isMemberLogin(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinVipMemberEntity t = (WeixinVipMemberEntity)request.getSession().getAttribute("memberSession");
        if (t != null) {
            j.setSuccess(true);
        } else {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"checkMemberLogin"})
    @ResponseBody
    public AjaxJson checkMemberLogin(HttpServletRequest request, WeixinVipMemberEntity member) {
        AjaxJson j = new AjaxJson();
        member.setMemberName(request.getParameter("memberName"));
        member.setPassword(request.getParameter("password"));
        if (StringUtils.isBlank((String)member.getMemberName())) {
            j.setMsg("cms.login.membername.isnull");
            j.setSuccess(false);
            return j;
        }
        if (StringUtils.isBlank((String)member.getPassword())) {
            j.setMsg("cms.login.password.isnull");
            j.setSuccess(false);
            return j;
        }
        int members = this.systemService.getList(WeixinVipMemberEntity.class).size();
        if (members == 0) {
            j.setMsg("cms.login.memberuser.isnotexist");
            j.setSuccess(false);
        } else {
            WeixinVipMemberEntity t = this.weixinVipMemberService.checkMemberExits(member);
            if (t != null) {
                request.getSession().setAttribute("memberSession", (Object)t);
            } else {
                j.setMsg("cms.login.membernameorpass.iserror");
                j.setSuccess(false);
            }
        }
        return j;
    }

    @RequestMapping(params={"doMemberRegister"})
    @ResponseBody
    public AjaxJson doMemberRegister(HttpServletRequest request, WeixinVipMemberEntity member) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4f1a\u5458\u6ce8\u518c";
        try {
            WeixinVipMemberEntity t = this.weixinVipMemberService.checkMemberUnique(member.getMemberName());
            if (t != null) {
                j.setMsg("cms.register.username.isexist");
                j.setSuccess(false);
                return j;
            }
            WeixinVipMembersType type = (WeixinVipMembersType)this.weixinVipMemberService.getEntity(WeixinVipMembersType.class, (Serializable)((Object)member.getMemberType().getId()));
            if (type.getMembers_type().equals("\u4e34\u65f6\u4f1a\u5458")) {
                member.setMemberStatus("\u6d3b\u8dc3");
                member.setVerifyStatus("3");
            } else {
                member.setMemberStatus("\u7533\u8bf7\u4e2d");
                member.setVerifyStatus("0");
            }
            member.setVipInfo((WeixinVipInfoEntity)this.weixinVipMemberService.findUniqueByProperty(WeixinVipInfoEntity.class, "vipName", "\u666e\u901a\u4f1a\u5458\u5361"));
            member.setMemberType(type);
            member.setCreateTime(new Date());
            member.setMemberIntegral(0);
            this.weixinVipMemberService.save(member);
            request.getSession().setAttribute("memberSession", (Object)member);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            j.setMsg("cms.register.fail");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(params={"doMemberLogOut"})
    public ModelAndView doMemberLogOut(HttpServletRequest request, WeixinVipMemberEntity member) {
        request.getSession().removeAttribute("memberSession");
        return new ModelAndView((View)new RedirectView("cmsController.do?goPage&page=index"));
    }

    @RequestMapping(params={"doUpdateMemberInfo"})
    public ModelAndView doUpdateMemberInfo(HttpServletRequest request, WeixinVipMemberEntity member, WeixinVipMemberDetailEntity weixinVipMemberDetail) {
        String memberId = request.getParameter("memberId");
        if (StringUtil.isNotEmpty((Object)memberId)) {
            this.message = "\u4f1a\u5458\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
            WeixinVipMemberEntity t = (WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)memberId));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)member, (Object)t);
                this.weixinVipMemberService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                if ("\u5fd7\u613f\u8005".equals(t.getMemberType().getMembers_type())) {
                    String detailId = request.getParameter("detailId");
                    if (StringUtil.isNotEmpty((Object)detailId)) {
                        this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u66f4\u65b0\u6210\u529f";
                        WeixinVipMemberDetailEntity td = (WeixinVipMemberDetailEntity)this.weixinVipMemberService.get(WeixinVipMemberDetailEntity.class, (Serializable)((Object)detailId));
                        try {
                            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVipMemberDetail, (Object)td);
                            this.weixinVipMemberService.saveOrUpdate(td);
                            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u66f4\u65b0\u5931\u8d25";
                        }
                    } else {
                        this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u6dfb\u52a0\u6210\u529f";
                        weixinVipMemberDetail.setId("");
                        weixinVipMemberDetail.setMember(t);
                        this.weixinVipMemberService.save(weixinVipMemberDetail);
                        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4f1a\u5458\u8be6\u7ec6\u8868\u66f4\u65b0\u5931\u8d25";
            }
        }
        return new ModelAndView((View)new RedirectView("cmsController.do?goPage&page=memberCenter"));
    }

    @RequestMapping(params={"saveOrderTicketAndPer"})
    public ModelAndView saveOrderTicketAndPer(HttpServletRequest request, OrderTicketEntity ticket, OrderPersonsEntity persons) {
        AjaxJson j = new AjaxJson();
        this.message = "\u9884\u7ea6\u8ba2\u7968\u6dfb\u52a0\u6210\u529f";
        String memberid = request.getParameter("memberId");
        ticket.setMember((WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)memberid)));
        ticket.setCreateTime(new Date());
        String ticketId = request.getParameter("ticketId");
        if (ticketId == null || ticketId.equals("")) {
            this.weixinVipMemberService.save(ticket);
        } else {
            ticket.setId(ticketId);
            this.weixinVipMemberService.updateEntitie(ticket);
        }
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        String[] ids = persons.getId().toString().split(",");
        String[] names = persons.getOrderPersonName().toString().split(",");
        String[] ages = persons.getOrderPersonAge().toString().split(",");
        String[] sexs = persons.getOrderPersonSex().toString().split(",");
        String[] phones = persons.getOrderPersonPhone().toString().split(",");
        String[] idents = persons.getOrderPersonIdent().toString().split(",");
        int i = 0;
        while (i < names.length) {
            OrderPersonsEntity person = !ids[i].equals("nameval") ? (OrderPersonsEntity)this.weixinVipMemberService.get(OrderPersonsEntity.class, (Serializable)((Object)ids[i])) : new OrderPersonsEntity();
            if (!names[i].equals("nameval")) {
                person.setOrderPersonName(names[i]);
            }
            if (!ages[i].equals("nameval")) {
                person.setOrderPersonAge(ages[i]);
            }
            if (!sexs[i].equals("nameval")) {
                person.setOrderPersonSex(sexs[i]);
            }
            if (!phones[i].equals("nameval")) {
                person.setOrderPersonPhone(phones[i]);
            }
            if (!idents[i].equals("nameval")) {
                person.setOrderPersonIdent(idents[i]);
            }
            if (person != null && !"".equals(person.getOrderPersonName()) && person.getOrderPersonName() != null) {
                person.setOrderTicket(ticket);
                if (!ids[i].equals("nameval")) {
                    this.weixinVipMemberService.updateEntitie(person);
                    this.systemService.addLog("\u9884\u7ea6\u4eba\u66f4\u65b0\u6210\u529f", Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
                } else {
                    this.weixinVipMemberService.save(person);
                    this.systemService.addLog("\u9884\u7ea6\u4eba\u6dfb\u52a0\u6210\u529f", Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
                }
            }
            ++i;
        }
        j.setMsg("\u64cd\u4f5c\u5b8c\u6210!");
        return new ModelAndView((View)new RedirectView("cmsController.do?goPage&page=orderTicketInfo"));
    }

    @RequestMapping(params={"deleteOrderTicketAndPer"})
    public ModelAndView deleteOrderTicketAndPer(HttpServletRequest request) {
        OrderTicketEntity ticket;
        AjaxJson j = new AjaxJson();
        this.message = "\u5220\u9664\u8ba2\u7968\u6210\u529f";
        String ticketid = request.getParameter("ticketid");
        if (ticketid != null && !ticketid.equals("") && (ticket = (OrderTicketEntity)this.weixinVipMemberService.get(OrderTicketEntity.class, (Serializable)((Object)ticketid))) != null) {
            this.weixinVipMemberService.delete(ticket);
            List list = this.weixinVipMemberService.findByProperty(OrderPersonsEntity.class, "orderTicket.id", ticketid);
            int i = 0;
            while (i < list.size()) {
                this.weixinVipMemberService.delete((OrderPersonsEntity)list.get(i));
                ++i;
            }
        }
        j.setMsg("\u64cd\u4f5c\u5b8c\u6210!");
        return new ModelAndView((View)new RedirectView("cmsController.do?goPage&page=orderTicketInfo"));
    }

    @RequestMapping(params={"queryTicketPerson"})
    @ResponseBody
    public AjaxJson queryTicketPerson(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String ticketId = request.getParameter("id");
        List list = this.weixinVipMemberService.findByProperty(OrderPersonsEntity.class, "orderTicket.id", ticketId);
        j.setObj((Object)list);
        return j;
    }

    @RequestMapping(params={"deleteTicketPerson"})
    @ResponseBody
    public AjaxJson deleteTicketPerson(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String personId = request.getParameter("id");
        OrderPersonsEntity pe = (OrderPersonsEntity)this.weixinVipMemberService.get(OrderPersonsEntity.class, (Serializable)((Object)personId));
        this.weixinVipMemberService.delete(pe);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"customerRegister"})
    public ModelAndView customerRegister(HttpServletRequest request, WeixinVipMemberEntity member1) {
        String openid = request.getParameter("openid");
        WeixinVipMemberEntity mem = (WeixinVipMemberEntity)this.weixinVipMemberService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", openid);
        if (mem != null) {
            Map map;
            request.setAttribute("member", (Object)mem);
            if (mem.getMemberVipType() != null && !"".equals(mem.getMemberVipType()) && (map = this.weixinVipMemberService.findOneForJdbc("select * from t_s_type where typecode ='" + mem.getMemberVipType() + "'", new Object[0])) != null) {
                request.setAttribute("memberType", map.get("typename"));
            }
            return new ModelAndView("weixin/vip/registerDetail");
        }
        request.setAttribute("openid", (Object)openid);
        request.setAttribute("accountid", (Object)request.getParameter("accountid"));
        request.setAttribute("memberType", (Object)this.systemService.getTypeGroupByCode("memberType"));
        return new ModelAndView("weixin/vip/register");
    }

    @RequestMapping(params={"doCustomerRegister"})
    public ModelAndView doCustomerRegister(HttpServletRequest request, WeixinVipMemberEntity member, @RequestParam(value="file") CommonsMultipartFile[] files) {
        Map map;
        String contextUploadPath = "upload" + File.separator + "weixinqrcode";
        String path = request.getSession().getServletContext().getRealPath(contextUploadPath);
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isEmpty()) {
                    try {
                        String originalFilename = files[i].getOriginalFilename();
                        String kname = StringUtils.substringAfterLast((String)originalFilename, (String)POINT);
                        String fileName = String.valueOf(UUIDGenerator.generate()) + POINT + kname;
                        String filePath = String.valueOf(contextUploadPath) + File.separator + fileName;
                        File targetFile = new File(path, fileName);
                        if (!targetFile.exists()) {
                            targetFile.mkdirs();
                        }
                        files[i].transferTo(targetFile);
                        if (i == 0) {
                            member.setMemberPhoto(filePath.replaceAll("\\\\", "/"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogUtil.info((Object)"\u4e0a\u4f20\u51fa\u9519");
                    }
                }
                ++i;
            }
        }
        member.setCreateTime(new Date());
        this.weixinVipMemberService.save(member);
        request.setAttribute("member", (Object)member);
        if (member.getMemberVipType() != null && !"".equals(member.getMemberVipType()) && (map = this.weixinVipMemberService.findOneForJdbc("select * from t_s_type where typecode ='" + member.getMemberVipType() + "'", new Object[0])) != null) {
            request.setAttribute("memberType", map.get("typename"));
        }
        return new ModelAndView("weixin/vip/registerDetail");
    }

    @RequestMapping(params={"checkIntegral"})
    @ResponseBody
    public AjaxJson checkIntegral(HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        String memberid = request.getParameter("memberid");
        String goodsid = request.getParameter("goodsid");
        WeixinVipMemberEntity member = (WeixinVipMemberEntity)this.weixinVipMemberService.get(WeixinVipMemberEntity.class, (Serializable)((Object)memberid));
        WeixinShopIntegralGoodsEntity goods = (WeixinShopIntegralGoodsEntity)this.systemService.get(WeixinShopIntegralGoodsEntity.class, (Serializable)((Object)goodsid));
        if (member.getMemberIntegral() < goods.getNeedintegral()) {
            json.setSuccess(false);
            json.setMsg("\u79ef\u5206\u4e0d\u8db3\uff0c\u4e0d\u80fd\u8fdb\u884c\u5151\u6362!");
            return json;
        }
        if (goods.getStorecount().intValue() == 0) {
            json.setSuccess(false);
            json.setMsg("\u6ca1\u6709\u8db3\u591f\u7684\u5546\u54c1\u53ef\u5151\u6362\uff0c\u6d3b\u52a8\u7ed3\u675f\u3002");
            return json;
        }
        WeixinVipExchangeRecordEntity record = new WeixinVipExchangeRecordEntity();
        record.setAccountid(member.getAccountid());
        record.setCreatetime(new Date());
        record.setGoodsimg(goods.getTitleImg());
        record.setGoodstitle(goods.getTitle());
        record.setIntegral(goods.getNeedintegral());
        record.setMember(member);
        record.setMobilenumber(member.getMemberMobile());
        record.setRealname(member.getMemberRealName());
        record.setGoodsid(goods.getId());
        this.weixinVipExchangeRecordService.save(record, goods);
        json.setSuccess(true);
        json.setMsg("\u5151\u6362\u6210\u529f\uff0c\u8bf7\u7ee7\u7eed\u586b\u5199\u53d1\u8d27\u5730\u5740!");
        json.setObj((Object)record.getId());
        return json;
    }

    @RequestMapping(params={"doExchange"})
    @ResponseBody
    public AjaxJson doExchange(HttpServletRequest request, WeixinVipExchangeRecordEntity record) {
        AjaxJson json = new AjaxJson();
        WeixinVipExchangeRecordEntity updaterecord = (WeixinVipExchangeRecordEntity)this.weixinVipMemberService.get(WeixinVipExchangeRecordEntity.class, (Serializable)((Object)record.getId()));
        if (request.getParameter("selectaddress").equals("other")) {
            updaterecord.setArea(record.getArea());
            updaterecord.setProvince(record.getProvince());
            updaterecord.setCity(record.getCity());
            updaterecord.setArea(record.getArea());
            updaterecord.setProvincecode(record.getProvincecode());
            updaterecord.setCitycode(record.getCitycode());
            updaterecord.setAreacode(record.getAreacode());
            updaterecord.setDetailaddress(record.getDetailaddress());
            updaterecord.setSendstatus("0");
        } else {
            String selectid = request.getParameter("selectaddress");
            WeixinShopAddressEntity address = (WeixinShopAddressEntity)this.systemService.get(WeixinShopAddressEntity.class, (Serializable)((Object)selectid));
            updaterecord.setArea(address.getArea());
            updaterecord.setProvince(address.getProvince());
            updaterecord.setCity(address.getCity());
            updaterecord.setProvincecode(address.getProvincecode());
            updaterecord.setCitycode(address.getCitycode());
            updaterecord.setAreacode(address.getAreacode());
            updaterecord.setDetailaddress(address.getAddress());
            updaterecord.setSendstatus("0");
        }
        this.weixinVipMemberService.updateEntitie(updaterecord);
        json.setMsg("\u6536\u8d27\u4fe1\u606f\u63d0\u4ea4\u6210\u529f\u3002");
        json.setSuccess(true);
        return json;
    }
}

