/*
 * Decompiled with CFR 0.152.
 */
package weixin.vip.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.util.DateUtils;
import weixin.vip.common.WeixinVipEnum;
import weixin.vip.entity.WeixinVipInfoEntity;
import weixin.vip.service.WeixinVipInfoServiceI;
import weixin.vip.service.WeixinVipMemberServiceI;

@Controller
@RequestMapping(value={"/weixinVipInfoController"})
public class WeixinVipInfoController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVipInfoController.class);
    @Autowired
    private WeixinVipInfoServiceI weixinVipInfoService;
    @Autowired
    private WeixinVipMemberServiceI weixinVipMemberService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVipInfo"})
    public ModelAndView weixinVipInfo(HttpServletRequest request) {
        return new ModelAndView("weixin/vip/weixinVipInfoList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVipInfoEntity weixinVipInfo, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVipInfoEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVipInfo, (Map)request.getParameterMap());
        this.weixinVipInfoService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinVipInfoEntity weixinVipInfo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVipInfo = (WeixinVipInfoEntity)this.systemService.getEntity(WeixinVipInfoEntity.class, (Serializable)((Object)weixinVipInfo.getId()));
        List wlist = this.systemService.findHql("from WeixinVipMemberEntity where VIP_ID = ?", new Object[]{weixinVipInfo});
        if (wlist.size() > 0) {
            this.message = "\u5df2\u7ecf\u5173\u8054\u4f1a\u5458\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
        } else {
            this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u8868\u5220\u9664\u6210\u529f";
            this.weixinVipInfoService.delete(weixinVipInfo);
        }
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinVipInfoEntity weixinVipInfo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinVipInfo.getId())) {
            this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u8868\u66f4\u65b0\u6210\u529f";
            WeixinVipInfoEntity t = (WeixinVipInfoEntity)this.weixinVipInfoService.get(WeixinVipInfoEntity.class, (Serializable)((Object)weixinVipInfo.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVipInfo, (Object)t);
                this.weixinVipInfoService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u8868\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5fae\u4fe1\u4f1a\u5458\u5361\u8868\u6dfb\u52a0\u6210\u529f";
            this.weixinVipInfoService.save(weixinVipInfo);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinVipInfoEntity weixinVipInfo, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVipInfo.getId())) {
            weixinVipInfo = (WeixinVipInfoEntity)this.weixinVipInfoService.getEntity(WeixinVipInfoEntity.class, (Serializable)((Object)weixinVipInfo.getId()));
            req.setAttribute("weixinVipInfoPage", (Object)weixinVipInfo);
        }
        req.setAttribute("LEVEL", (Object)WeixinVipEnum.values());
        return new ModelAndView("weixin/vip/weixinVipInfo");
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("ok");
        j.setAttributes(attributes);
        return j;
    }
}

