/*
 * Decompiled with CFR 0.152.
 */
package weixin.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import weixin.guanjia.core.entity.message.resp.Article;
import weixin.util.BaiduPlace;

public class BaiduMapUtil {
    public static List<BaiduPlace> searchPlace(String query, String lng, String lat) throws Exception {
        String requestUrl = "http://api.map.baidu.com/place/v2/search?&query=QUERY&location=LAT,LNG&radius=2000&output=xml&scope=2&page_size=10&page_num=0&ak=TUzxb2CYvB5jbLWPByFFvUAG";
        requestUrl = requestUrl.replace("QUERY", URLEncoder.encode(query, "UTF-8"));
        requestUrl = requestUrl.replace("LAT", lat);
        requestUrl = requestUrl.replace("LNG", lng);
        String respXml = BaiduMapUtil.httpRequest(requestUrl);
        System.out.println(respXml);
        List<BaiduPlace> placeList = BaiduMapUtil.parsePlaceXml(respXml);
        return placeList;
    }

    public static String httpRequest(String requestUrl) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoInput(true);
            httpUrlConn.setRequestMethod("GET");
            httpUrlConn.connect();
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private static List<BaiduPlace> parsePlaceXml(String xml) {
        ArrayList<BaiduPlace> placeList = null;
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Element resultsElement = root.element("results");
            List resultElementList = resultsElement.elements("result");
            if (resultElementList.size() > 0) {
                placeList = new ArrayList<BaiduPlace>();
                Element nameElement = null;
                Element addressElement = null;
                Element locationElement = null;
                Element telephoneElement = null;
                Element detailInfoElement = null;
                Element distanceElement = null;
                for (Element resultElement : resultElementList) {
                    nameElement = resultElement.element("name");
                    addressElement = resultElement.element("address");
                    locationElement = resultElement.element("location");
                    telephoneElement = resultElement.element("telephone");
                    detailInfoElement = resultElement.element("detail_info");
                    BaiduPlace place = new BaiduPlace();
                    place.setName(nameElement.getText());
                    place.setAddress(addressElement.getText());
                    place.setLng(locationElement.element("lng").getText());
                    place.setLat(locationElement.element("lat").getText());
                    if (telephoneElement != null) {
                        place.setTelephone(telephoneElement.getText());
                    }
                    if (detailInfoElement != null && (distanceElement = detailInfoElement.element("distance")) != null) {
                        place.setDistance(Integer.parseInt(distanceElement.getText()));
                    }
                    placeList.add(place);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return placeList;
    }

    public static List<Article> makeArticleList(List<BaiduPlace> placeList, String faceImageUrl) {
        String domain = ResourceBundle.getBundle("sysConfig").getString("domain");
        ArrayList<Article> list = new ArrayList<Article>();
        BaiduPlace place = null;
        int i = 0;
        while (i < placeList.size()) {
            place = placeList.get(i);
            Article article = new Article();
            article.setTitle(String.valueOf(place.getName()) + "\n\u8ddd\u79bb\u7ea6" + place.getDistance() + "\u7c73");
            article.setUrl(String.format(String.valueOf(domain) + "/locationController.do?goLocationUnicomBusinessHall&name=" + place.getName() + "&latitude=" + place.getLat() + "&longitude=" + place.getLng(), new Object[0]));
            if (i == 0) {
                article.setPicUrl(String.valueOf(domain) + "/" + faceImageUrl);
            }
            list.add(article);
            ++i;
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            List<BaiduPlace> list = BaiduMapUtil.searchPlace("\u9644\u8fd1\u8054\u901a\u8425\u4e1a\u5385", "113.636942", "34.834008");
            List<Article> arts = BaiduMapUtil.makeArticleList(list, null);
            for (Article art : arts) {
                System.out.println(String.valueOf(art.getTitle()) + art.getUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

