/*
 * Decompiled with CFR 0.152.
 */
package weixin.trigger.config.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.trigger.config.entity.WeixinCodePointConfigEntity;
import weixin.trigger.config.service.WeixinCodePointConfigServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCodePointConfigController"})
public class WeixinCodePointConfigController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCodePointConfigController.class);
    @Autowired
    private WeixinCodePointConfigServiceI weixinCodePointConfigService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCodePointConfig"})
    public ModelAndView weixinCodePointConfig(HttpServletRequest request) {
        return new ModelAndView("weixin/trigger/config/weixinCodePointConfigList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCodePointConfigEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCodePointConfig, (Map)request.getParameterMap());
        cq.add();
        this.weixinCodePointConfigService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCodePointConfig = (WeixinCodePointConfigEntity)this.systemService.getEntity(WeixinCodePointConfigEntity.class, (Serializable)((Object)weixinCodePointConfig.getId()));
        this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            this.weixinCodePointConfigService.delete(weixinCodePointConfig);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinCodePointConfigEntity weixinCodePointConfig = (WeixinCodePointConfigEntity)this.systemService.getEntity(WeixinCodePointConfigEntity.class, (Serializable)((Object)id));
                this.weixinCodePointConfigService.delete(weixinCodePointConfig);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinCodePointConfigService.save(weixinCodePointConfig);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u66f4\u65b0\u6210\u529f";
        WeixinCodePointConfigEntity t = (WeixinCodePointConfigEntity)this.weixinCodePointConfigService.get(WeixinCodePointConfigEntity.class, (Serializable)((Object)weixinCodePointConfig.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCodePointConfig, (Object)t);
            this.weixinCodePointConfigService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCodePointConfig.getId())) {
            weixinCodePointConfig = (WeixinCodePointConfigEntity)this.weixinCodePointConfigService.getEntity(WeixinCodePointConfigEntity.class, (Serializable)((Object)weixinCodePointConfig.getId()));
            req.setAttribute("weixinCodePointConfigPage", (Object)weixinCodePointConfig);
        }
        return new ModelAndView("weixin/trigger/config/weixinCodePointConfig-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCodePointConfig.getId())) {
            weixinCodePointConfig = (WeixinCodePointConfigEntity)this.weixinCodePointConfigService.getEntity(WeixinCodePointConfigEntity.class, (Serializable)((Object)weixinCodePointConfig.getId()));
            req.setAttribute("weixinCodePointConfigPage", (Object)weixinCodePointConfig);
        }
        return new ModelAndView("weixin/trigger/config/weixinCodePointConfig-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/trigger/config/weixinCodePointConfigUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinCodePointConfigEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCodePointConfig, (Map)request.getParameterMap());
                List weixinCodePointConfigs = this.weixinCodePointConfigService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCodePointConfigEntity.class, (Collection)weixinCodePointConfigs);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinCodePointConfigEntity weixinCodePointConfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u4e1a\u52a1\u4ee3\u7801\u5d4c\u5165\u70b9\u914d\u7f6e\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCodePointConfigEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinCodePointConfigEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinCodePointConfigEntity.class, (ImportParams)params);
                    for (WeixinCodePointConfigEntity weixinCodePointConfig : listWeixinCodePointConfigEntitys) {
                        this.weixinCodePointConfigService.save(weixinCodePointConfig);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

