/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.util.msg.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jeecgframework.core.util.LogUtil;

public class MsgUtils {
    private static int sequenceId = 0;

    public static int getSequence() {
        if (++sequenceId > 255) {
            sequenceId = 0;
        }
        return sequenceId;
    }

    public static String getTimestamp() {
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        return format.format(new Date());
    }

    public static byte[] getAuthenticatorSource(String spId, String secret) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] data = (String.valueOf(spId) + "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000" + secret + MsgUtils.getTimestamp()).getBytes();
            return md5.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.info((Object)("SP\u94fe\u63a5\u5230ISMG\u62fc\u63a5AuthenticatorSource\u5931\u8d25\uff1a" + e.getMessage()));
            return null;
        }
    }

    public static void writeString(DataOutputStream dous, String s, int len) {
        try {
            byte[] data = s.getBytes("gb2312");
            if (data.length > len) {
                LogUtil.info((Object)("\u5411\u6d41\u4e2d\u5199\u5165\u7684\u5b57\u7b26\u4e32\u8d85\u957f\uff01\u8981\u5199" + len + " \u5b57\u7b26\u4e32\u662f:" + s));
            }
            int srcLen = data.length;
            dous.write(data);
            while (srcLen < len) {
                dous.write(0);
                ++srcLen;
            }
        }
        catch (IOException e) {
            LogUtil.info((Object)("\u5411\u6d41\u4e2d\u5199\u5165\u6307\u5b9a\u5b57\u8282\u957f\u5ea6\u7684\u5b57\u7b26\u4e32\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public static String readString(DataInputStream ins, int len) {
        byte[] b = new byte[len];
        try {
            ins.read(b);
            String s = new String(b);
            s = s.trim();
            return s;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static byte[] getMsgBytes(byte[] msg, int start, int end) {
        byte[] msgByte = new byte[end - start];
        int j = 0;
        int i = start;
        while (i < end) {
            msgByte[j] = msg[i];
            ++j;
            ++i;
        }
        return msgByte;
    }

    public static String decodeUCS2(String src) {
        byte[] bytes = new byte[src.length() / 2];
        int i = 0;
        while (i < src.length()) {
            bytes[i / 2] = (byte)Integer.parseInt(src.substring(i, i + 2), 16);
            i += 2;
        }
        String reValue = "";
        try {
            reValue = new String(bytes, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            reValue = "";
        }
        return reValue;
    }

    public static String encodeUCS2(String src) {
        byte[] bytes;
        try {
            bytes = src.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            bytes = new byte[]{};
        }
        StringBuffer reValue = new StringBuffer();
        StringBuffer tem = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            tem.delete(0, tem.length());
            tem.append(Integer.toHexString(bytes[i] & 0xFF));
            if (tem.length() == 1) {
                tem.insert(0, '0');
            }
            reValue.append(tem);
            ++i;
        }
        return reValue.toString().toUpperCase();
    }
}

