/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.util.msg.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import weixin.sms.util.msg.domain.MsgConnect;
import weixin.sms.util.msg.domain.MsgHead;
import weixin.sms.util.msg.domain.MsgSubmit;
import weixin.sms.util.msg.util.CmppSender;
import weixin.sms.util.msg.util.MsgConfig;
import weixin.sms.util.msg.util.MsgUtils;

public class MsgContainer {
    private static Logger logger = Logger.getLogger(MsgContainer.class);
    private static Socket msgSocket;
    private static DataInputStream in;
    private static DataOutputStream out;

    public static DataInputStream getSocketDIS() {
        if (in == null || msgSocket == null || msgSocket.isClosed() || !msgSocket.isConnected()) {
            try {
                in = new DataInputStream(MsgContainer.getSocketInstance().getInputStream());
            }
            catch (IOException e) {
                in = null;
            }
        }
        return in;
    }

    public static DataOutputStream getSocketDOS() {
        if (out == null || msgSocket == null || msgSocket.isClosed() || !msgSocket.isConnected()) {
            try {
                out = new DataOutputStream(MsgContainer.getSocketInstance().getOutputStream());
            }
            catch (IOException e) {
                out = null;
            }
        }
        return out;
    }

    public static Socket getSocketInstance() {
        if (msgSocket == null || msgSocket.isClosed() || !msgSocket.isConnected()) {
            try {
                in = null;
                out = null;
                msgSocket = new Socket(MsgConfig.getIsmgIp(), MsgConfig.getIsmgPort());
                msgSocket.setKeepAlive(true);
                in = MsgContainer.getSocketDIS();
                out = MsgContainer.getSocketDOS();
                int count = 0;
                boolean result = MsgContainer.connectISMG();
                logger.info((Object)("result" + result));
                while (!result) {
                    result = MsgContainer.connectISMG();
                    if (++count < MsgConfig.getConnectCount() - 1) {
                        continue;
                    }
                    break;
                }
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Socket\u94fe\u63a5\u77ed\u4fe1\u7f51\u5173\u7aef\u53e3\u53f7\u4e0d\u6b63\u786e\uff1a" + e.getMessage()));
            }
            catch (IOException e) {
                logger.error((Object)("Socket\u94fe\u63a5\u77ed\u4fe1\u7f51\u5173\u5931\u8d25\uff1a" + e.getMessage()));
            }
        }
        return msgSocket;
    }

    private static boolean connectISMG() {
        MsgConnect connect = new MsgConnect();
        connect.setTotalLength(39);
        connect.setCommandId(1);
        connect.setSequenceId(MsgUtils.getSequence());
        connect.setSourceAddr(MsgConfig.getSpId());
        connect.setAuthenticatorSource(MsgUtils.getAuthenticatorSource(MsgConfig.getSpId(), MsgConfig.getSpSharedSecret()));
        connect.setTimestamp(Integer.parseInt(MsgUtils.getTimestamp()));
        connect.setVersion((byte)48);
        logger.error((Object)("\u6d88\u606f\u957f\u5ea6:" + connect.getTotalLength()));
        logger.error((Object)("\u6807\u8bc6:" + connect.getCommandId()));
        logger.error((Object)("\u5e8f\u5217:" + connect.getSequenceId()));
        logger.error((Object)("\u4f01\u4e1aid:" + connect.getSourceAddr()));
        logger.error((Object)("md5:" + connect.getAuthenticatorSource().length));
        logger.error((Object)("\u65f6\u95f4\u6233:" + connect.getTimestamp()));
        logger.error((Object)("\u7248\u672c\u53f7:" + connect.getVersion()));
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        dataList.add(connect.toByteArry());
        CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
        try {
            sender.start();
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            return false;
        }
    }

    public static boolean sendMsg(String msg, String cusMsisdn) {
        try {
            if (msg.getBytes("utf-8").length < 140) {
                boolean result = MsgContainer.sendShortMsg(msg, cusMsisdn);
                int count = 0;
                while (!result) {
                    result = MsgContainer.sendShortMsg(msg, cusMsisdn);
                    if (++count >= MsgConfig.getConnectCount() - 1) break;
                }
                return result;
            }
            boolean result = MsgContainer.sendLongMsg(msg, cusMsisdn);
            int count = 0;
            while (!result) {
                result = MsgContainer.sendLongMsg(msg, cusMsisdn);
                if (++count >= MsgConfig.getConnectCount() - 1) break;
            }
            return result;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            return false;
        }
    }

    public static boolean sendWapPushMsg(String url, String desc, String cusMsisdn) {
        try {
            int msgContent = 30 + url.getBytes("utf-8").length + 3 + desc.getBytes("utf-8").length + 3;
            if (msgContent < 140) {
                boolean result = MsgContainer.sendShortWapPushMsg(url, desc, cusMsisdn);
                int count = 0;
                while (!result) {
                    result = MsgContainer.sendShortWapPushMsg(url, desc, cusMsisdn);
                    if (++count >= MsgConfig.getConnectCount() - 1) break;
                }
                return result;
            }
            boolean result = MsgContainer.sendLongWapPushMsg(url, desc, cusMsisdn);
            int count = 0;
            while (!result) {
                result = MsgContainer.sendLongWapPushMsg(url, desc, cusMsisdn);
                if (++count >= MsgConfig.getConnectCount() - 1) break;
            }
            return result;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u53d1\u9001web push\u77ed\u4fe1:" + e.getMessage()));
            return false;
        }
    }

    private static boolean sendShortMsg(String msg, String cusMsisdn) {
        try {
            int seq = MsgUtils.getSequence();
            MsgSubmit submit = new MsgSubmit();
            submit.setTotalLength(175 + msg.length() * 2 + 20);
            submit.setCommandId(4);
            submit.setSequenceId(seq);
            submit.setPkTotal((byte)1);
            submit.setPkNumber((byte)1);
            submit.setRegisteredDelivery((byte)0);
            submit.setMsgLevel((byte)1);
            submit.setFeeUserType((byte)0);
            submit.setFeeTerminalId("");
            submit.setFeeTerminalType((byte)0);
            submit.setTpPId((byte)0);
            submit.setTpUdhi((byte)0);
            submit.setMsgFmt((byte)15);
            submit.setMsgSrc(MsgConfig.getSpId());
            submit.setSrcId(MsgConfig.getSpCode());
            submit.setDestTerminalId(cusMsisdn);
            submit.setMsgLength((byte)(msg.length() * 2));
            submit.setMsgContent(msg.getBytes("gb2312"));
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            dataList.add(submit.toByteArry());
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            logger.info((Object)("\u6570\u636e\u4e50\u56ed\u4e8e" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u5411" + cusMsisdn + "\u4e0b\u53d1\u77ed\u77ed\u4fe1\uff0c\u5e8f\u5217\u53f7\u4e3a:" + seq));
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u53d1\u9001\u77ed\u77ed\u4fe1" + e.getMessage()));
            return false;
        }
    }

    private static boolean sendLongMsg(String msg, String cusMsisdn) {
        try {
            byte[] allByte = msg.getBytes("UTF-16BE");
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            int msgLength = allByte.length;
            int maxLength = 140;
            int msgSendCount = msgLength % (maxLength - 6) == 0 ? msgLength / (maxLength - 6) : msgLength / (maxLength - 6) + 1;
            byte[] msgHead = new byte[]{5, 0, 3, (byte)MsgUtils.getSequence(), (byte)msgSendCount, 1};
            int seqId = MsgUtils.getSequence();
            int i = 0;
            while (i < msgSendCount) {
                int end;
                int start;
                msgHead[5] = (byte)(i + 1);
                byte[] needMsg = null;
                if (i != msgSendCount - 1) {
                    start = (maxLength - 6) * i;
                    end = (maxLength - 6) * (i + 1);
                    needMsg = MsgUtils.getMsgBytes(allByte, start, end);
                } else {
                    start = (maxLength - 6) * i;
                    end = allByte.length;
                    needMsg = MsgUtils.getMsgBytes(allByte, start, end);
                }
                int subLength = needMsg.length + msgHead.length;
                byte[] sendMsg = new byte[needMsg.length + msgHead.length];
                System.arraycopy(msgHead, 0, sendMsg, 0, 6);
                System.arraycopy(needMsg, 0, sendMsg, 6, needMsg.length);
                MsgSubmit submit = new MsgSubmit();
                submit.setTotalLength(175 + subLength + 20);
                submit.setCommandId(4);
                submit.setSequenceId(seqId);
                submit.setPkTotal((byte)msgSendCount);
                submit.setPkNumber((byte)(i + 1));
                submit.setRegisteredDelivery((byte)0);
                submit.setMsgLevel((byte)1);
                submit.setFeeUserType((byte)0);
                submit.setFeeTerminalId("");
                submit.setFeeTerminalType((byte)0);
                submit.setTpPId((byte)0);
                submit.setTpUdhi((byte)1);
                submit.setMsgFmt((byte)8);
                submit.setMsgSrc(MsgConfig.getSpId());
                submit.setSrcId(MsgConfig.getSpCode());
                submit.setDestTerminalId(cusMsisdn);
                submit.setMsgLength((byte)subLength);
                submit.setMsgContent(sendMsg);
                dataList.add(submit.toByteArry());
                ++i;
            }
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            logger.info((Object)("\u6570\u636e\u4e50\u56ed\u4e8e" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u5411" + cusMsisdn + "\u4e0b\u53d1\u957f\u77ed\u4fe1\uff0c\u5e8f\u5217\u53f7\u4e3a:" + seqId));
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u53d1\u9001\u957f\u77ed\u4fe1" + e.getMessage()));
            return false;
        }
    }

    public static boolean cancelISMG() {
        try {
            MsgHead head = new MsgHead();
            head.setTotalLength(12);
            head.setCommandId(2);
            head.setSequenceId(MsgUtils.getSequence());
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            dataList.add(head.toByteArry());
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            MsgContainer.getSocketInstance().close();
            out.close();
            in.close();
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
                in.close();
            }
            catch (IOException e1) {
                in = null;
                out = null;
            }
            logger.error((Object)("\u62c6\u9664\u4e0eISMG\u7684\u94fe\u63a5" + e.getMessage()));
            return false;
        }
    }

    public static boolean activityTestISMG() {
        try {
            logger.info((Object)"activityTestISMG================start");
            MsgHead head = new MsgHead();
            head.setTotalLength(12);
            head.setCommandId(8);
            head.setSequenceId(MsgUtils.getSequence());
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            dataList.add(head.toByteArry());
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            logger.info((Object)"activityTestISMG================end");
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
                logger.info((Object)"activityTestISMG================end");
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u94fe\u8def\u68c0\u67e5" + e.getMessage()));
            return false;
        }
    }

    private static boolean sendShortWapPushMsg(String url, String desc, String cusMsisdn) {
        try {
            byte[] byArray = new byte[12];
            byArray[0] = 11;
            byArray[1] = 5;
            byArray[2] = 4;
            byArray[3] = 11;
            byArray[4] = -124;
            byArray[5] = 35;
            byArray[6] = -16;
            byArray[8] = 3;
            byArray[9] = 3;
            byArray[10] = 1;
            byArray[11] = 1;
            byte[] szWapPushHeader1 = byArray;
            byte[] szWapPushHeader2 = new byte[]{41, 6, 6, 3, -82, -127, -22, -115, -54};
            byte[] byArray2 = new byte[9];
            byArray2[0] = 2;
            byArray2[1] = 5;
            byArray2[2] = 106;
            byArray2[4] = 69;
            byArray2[5] = -58;
            byArray2[6] = 8;
            byArray2[7] = 12;
            byArray2[8] = 3;
            byte[] szWapPushIndicator = byArray2;
            byte[] szWapPushUrl = url.getBytes("utf-8");
            byte[] byArray3 = new byte[3];
            byArray3[1] = 1;
            byArray3[2] = 3;
            byte[] szWapPushDisplayTextHeader = byArray3;
            byte[] szMsg = desc.getBytes("utf-8");
            byte[] byArray4 = new byte[3];
            byArray4[1] = 1;
            byArray4[2] = 1;
            byte[] szEndOfWapPush = byArray4;
            int msgLength = 30 + szWapPushUrl.length + 3 + szMsg.length + 3;
            int seq = MsgUtils.getSequence();
            MsgSubmit submit = new MsgSubmit();
            submit.setTotalLength(175 + msgLength + 20);
            submit.setCommandId(4);
            submit.setSequenceId(seq);
            submit.setPkTotal((byte)1);
            submit.setPkNumber((byte)1);
            submit.setRegisteredDelivery((byte)0);
            submit.setMsgLevel((byte)1);
            submit.setFeeUserType((byte)0);
            submit.setFeeTerminalId("");
            submit.setFeeTerminalType((byte)0);
            submit.setTpPId((byte)0);
            submit.setTpUdhi((byte)1);
            submit.setMsgFmt((byte)4);
            submit.setMsgSrc(MsgConfig.getSpId());
            submit.setSrcId(MsgConfig.getSpCode());
            submit.setDestTerminalId(cusMsisdn);
            submit.setMsgLength((byte)msgLength);
            byte[] sendMsg = new byte[30 + szWapPushUrl.length + 3 + szMsg.length + 3];
            System.arraycopy(szWapPushHeader1, 0, sendMsg, 0, 12);
            System.arraycopy(szWapPushHeader2, 0, sendMsg, 12, 9);
            System.arraycopy(szWapPushIndicator, 0, sendMsg, 21, 9);
            System.arraycopy(szWapPushUrl, 0, sendMsg, 30, szWapPushUrl.length);
            System.arraycopy(szWapPushDisplayTextHeader, 0, sendMsg, 30 + szWapPushUrl.length, 3);
            System.arraycopy(szMsg, 0, sendMsg, 30 + szWapPushUrl.length + 3, szMsg.length);
            System.arraycopy(szEndOfWapPush, 0, sendMsg, 30 + szWapPushUrl.length + 3 + szMsg.length, 3);
            submit.setMsgContent(sendMsg);
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            dataList.add(submit.toByteArry());
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            logger.info((Object)("\u6570\u636e\u4e50\u56ed\u4e8e" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u5411" + cusMsisdn + "\u4e0b\u53d1web push\u77ed\u77ed\u4fe1\uff0c\u5e8f\u5217\u53f7\u4e3a:" + seq));
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u53d1\u9001web push\u77ed\u77ed\u4fe1" + e.getMessage()));
            return false;
        }
    }

    private static boolean sendLongWapPushMsg(String url, String desc, String cusMsisdn) {
        try {
            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
            byte[] byArray = new byte[12];
            byArray[0] = 11;
            byArray[1] = 5;
            byArray[2] = 4;
            byArray[3] = 11;
            byArray[4] = -124;
            byArray[5] = 35;
            byArray[6] = -16;
            byArray[8] = 3;
            byArray[9] = 3;
            byArray[10] = 1;
            byArray[11] = 1;
            byte[] wdp = byArray;
            byte[] wsp = new byte[]{41, 6, 6, 3, -82, -127, -22, -115, -54};
            byte[] byArray2 = new byte[9];
            byArray2[0] = 2;
            byArray2[1] = 5;
            byArray2[2] = 106;
            byArray2[4] = 69;
            byArray2[5] = -58;
            byArray2[6] = 8;
            byArray2[7] = 12;
            byArray2[8] = 3;
            byte[] szWapPushIndicator = byArray2;
            byte[] szWapPushUrl = url.getBytes("utf-8");
            byte[] byArray3 = new byte[3];
            byArray3[1] = 1;
            byArray3[2] = 3;
            byte[] szWapPushDisplayTextHeader = byArray3;
            byte[] szMsg = desc.getBytes("utf-8");
            byte[] byArray4 = new byte[3];
            byArray4[1] = 1;
            byArray4[2] = 1;
            byte[] szEndOfWapPush = byArray4;
            byte[] allByte = new byte[18 + szWapPushUrl.length + 3 + szMsg.length + 3];
            System.arraycopy(wsp, 0, allByte, 0, 9);
            System.arraycopy(szWapPushIndicator, 0, allByte, 9, 9);
            System.arraycopy(szWapPushUrl, 0, allByte, 18, szWapPushUrl.length);
            System.arraycopy(szWapPushDisplayTextHeader, 0, allByte, 18 + szWapPushUrl.length, 3);
            System.arraycopy(szMsg, 0, allByte, 18 + szWapPushUrl.length + 3, szMsg.length);
            System.arraycopy(szEndOfWapPush, 0, allByte, 18 + szWapPushUrl.length + 3 + szMsg.length, 3);
            int msgMax = 140;
            int msgCount = allByte.length % (msgMax - wdp.length) == 0 ? allByte.length / (msgMax - wdp.length) : allByte.length / (msgMax - wdp.length) + 1;
            wdp[10] = (byte)msgCount;
            int seqId = MsgUtils.getSequence();
            int i = 0;
            while (i < msgCount) {
                int end;
                int start;
                wdp[11] = (byte)(i + 1);
                byte[] needMsg = null;
                if (i != msgCount - 1) {
                    start = (msgMax - wdp.length) * i;
                    end = (msgMax - wdp.length) * (i + 1);
                    needMsg = MsgUtils.getMsgBytes(allByte, start, end);
                } else {
                    start = (msgMax - wdp.length) * i;
                    end = allByte.length;
                    needMsg = MsgUtils.getMsgBytes(allByte, start, end);
                }
                int msgLength = needMsg.length + wdp.length;
                MsgSubmit submit = new MsgSubmit();
                submit.setTotalLength(175 + msgLength + 20);
                submit.setCommandId(4);
                submit.setSequenceId(seqId);
                submit.setPkTotal((byte)msgCount);
                submit.setPkNumber((byte)(i + 1));
                submit.setRegisteredDelivery((byte)0);
                submit.setMsgLevel((byte)1);
                submit.setFeeUserType((byte)0);
                submit.setFeeTerminalId("");
                submit.setFeeTerminalType((byte)0);
                submit.setTpPId((byte)0);
                submit.setTpUdhi((byte)1);
                submit.setMsgFmt((byte)4);
                submit.setMsgSrc(MsgConfig.getSpId());
                submit.setSrcId(MsgConfig.getSpCode());
                submit.setDestTerminalId(cusMsisdn);
                submit.setMsgLength((byte)msgLength);
                byte[] sendMsg = new byte[wdp.length + needMsg.length];
                System.arraycopy(wdp, 0, sendMsg, 0, wdp.length);
                System.arraycopy(needMsg, 0, sendMsg, wdp.length, needMsg.length);
                submit.setMsgContent(sendMsg);
                dataList.add(submit.toByteArry());
                ++i;
            }
            CmppSender sender = new CmppSender(MsgContainer.getSocketDOS(), MsgContainer.getSocketDIS(), dataList);
            sender.start();
            logger.info((Object)("\u6570\u636e\u4e50\u56ed\u4e8e" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u5411" + cusMsisdn + "\u4e0b\u53d1web pus\u957f\u77ed\u4fe1\uff0c\u5e8f\u5217\u53f7\u4e3a:" + seqId));
            return true;
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (IOException e1) {
                out = null;
            }
            logger.error((Object)("\u53d1\u9001web push\u957f\u77ed\u4fe1" + e.getMessage()));
            return false;
        }
    }
}

