/*
 * Decompiled with CFR 0.152.
 */
package weixin.sms.util.msg.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import weixin.sms.util.msg.domain.MsgActiveTestResp;
import weixin.sms.util.msg.domain.MsgConnectResp;
import weixin.sms.util.msg.domain.MsgDeliver;
import weixin.sms.util.msg.domain.MsgDeliverResp;
import weixin.sms.util.msg.domain.MsgHead;
import weixin.sms.util.msg.domain.MsgSubmitResp;
import weixin.sms.util.msg.util.MsgUtils;

public class CmppSender {
    private static Logger logger = Logger.getLogger(CmppSender.class);
    private List<byte[]> sendData = new ArrayList<byte[]>();
    private List<byte[]> getData = new ArrayList<byte[]>();
    private DataOutputStream out;
    private DataInputStream in;

    public CmppSender(DataOutputStream out, DataInputStream in, List<byte[]> sendData) {
        this.sendData = sendData;
        this.out = out;
        this.in = in;
    }

    public void start() throws Exception {
        if (this.out != null && this.sendData != null) {
            for (byte[] data : this.sendData) {
                logger.info((Object)("\u53d1\u9001\u7684\u4e8c\u8fdb\u5236\u961f\u5217\u91ccdata\u957f\u5ea6====" + data.length));
                this.sendMsg(data);
                byte[] returnData = this.getInData();
                logger.info((Object)("\u53d1\u9001\u7684\u4e8c\u8fdb\u5236\u961f\u5217\u91cc\u54cd\u5e94\u503c\u7684\u957f\u5ea6====" + returnData.length));
                this.getData.add(returnData);
            }
        }
        if (this.in != null && this.getData != null) {
            for (byte[] data : this.getData) {
                logger.info((Object)("\u63a5\u6536\u7684\u4e8c\u8fdb\u5236\u961f\u5217\u91ccdata\u957f\u5ea6====" + data.length));
                if (data.length < 8) continue;
                MsgHead head = new MsgHead(data);
                switch (head.getCommandId()) {
                    case -2147483647: {
                        logger.info((Object)("\u94fe\u63a5\u81f3\u77ed\u4fe1\u7f51\u5173\u4e4b\u524ddata\u957f\u5ea6====" + data.length));
                        MsgConnectResp connectResp = new MsgConnectResp(data);
                        logger.info((Object)("\u5feb\u6d88\u5e73\u53f0" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u94fe\u63a5\u77ed\u4fe1\u7f51\u5173,\u72b6\u6001:" + connectResp.getStatusStr() + " \u5e8f\u5217\u53f7\uff1a" + connectResp.getSequenceId()));
                        break;
                    }
                    case -2147483640: {
                        MsgActiveTestResp activeResp = new MsgActiveTestResp(data);
                        logger.info((Object)("\u5feb\u6d88\u5e73\u53f0" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u77ed\u4fe1\u7f51\u5173\u4e0e\u77ed\u4fe1\u7f51\u5173\u8fdb\u884c\u8fde\u63a5\u68c0\u67e5" + " \u5e8f\u5217\u53f7\uff1a" + activeResp.getSequenceId()));
                        break;
                    }
                    case -2147483644: {
                        MsgSubmitResp submitResp = new MsgSubmitResp(data);
                        logger.info((Object)("\u5feb\u6d88\u5e73\u53f0" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u5411\u7528\u6237\u4e0b\u53d1\u77ed\u4fe1\uff0c\u72b6\u6001\u7801:" + submitResp.getResult() + " \u5e8f\u5217\u53f7\uff1a" + submitResp.getSequenceId()));
                        break;
                    }
                    case -2147483646: {
                        logger.info((Object)("\u5feb\u6d88\u5e73\u53f0" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\u62c6\u9664\u4e0eISMG\u7684\u94fe\u63a5" + " \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case -2147483641: {
                        logger.info((Object)("CMPP_CANCEL_RESP \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 7: {
                        logger.info((Object)("CMPP_CANCEL \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 5: {
                        MsgDeliver msgDeliver = new MsgDeliver(data);
                        if (msgDeliver.getResult() == 0) {
                            logger.info((Object)("CMPP_DELIVER \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId() + "\uff0c\u662f\u5426\u6d88\u606f\u56de\u590d" + (msgDeliver.getRegisteredDelivery() == 0 ? "\u4e0d\u662f,\u6d88\u606f\u5185\u5bb9\uff1a" + msgDeliver.getMsgContent() : "\u662f\uff0c\u76ee\u7684\u624b\u673a\u53f7\uff1a" + msgDeliver.getDestTerminalId())));
                        } else {
                            logger.info((Object)("CMPP_DELIVER \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        }
                        MsgDeliverResp msgDeliverResp = new MsgDeliverResp();
                        msgDeliverResp.setTotalLength(24);
                        msgDeliverResp.setCommandId(-2147483643);
                        msgDeliverResp.setSequenceId(MsgUtils.getSequence());
                        msgDeliverResp.setMsgId(msgDeliver.getMsgId());
                        msgDeliverResp.setResult(msgDeliver.getResult());
                        this.sendMsg(msgDeliverResp.toByteArry());
                        break;
                    }
                    case -2147483643: {
                        logger.info((Object)("CMPP_DELIVER_RESP \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 6: {
                        logger.info((Object)("CMPP_QUERY \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case -2147483642: {
                        logger.info((Object)("CMPP_QUERY_RESP \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 2: {
                        logger.info((Object)("CMPP_TERMINATE \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 1: {
                        logger.info((Object)("CMPP_CONNECT \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 8: {
                        logger.info((Object)("CMPP_ACTIVE_TEST \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    case 4: {
                        logger.info((Object)("CMPP_SUBMIT \u5e8f\u5217\u53f7\uff1a" + head.getSequenceId()));
                        break;
                    }
                    default: {
                        logger.error((Object)("\u65e0\u6cd5\u89e3\u6790IMSP\u8fd4\u56de\u7684\u5305\u7ed3\u6784\uff1a\u5305\u957f\u5ea6\u4e3a" + head.getTotalLength()));
                    }
                }
            }
        }
    }

    public List<byte[]> getGetData() {
        return this.getData;
    }

    private boolean sendMsg(byte[] data) throws Exception {
        try {
            this.out.write(data);
            this.out.flush();
            return true;
        }
        catch (NullPointerException ef) {
            logger.error((Object)"\u5728\u672c\u8fde\u7ed3\u4e0a\u53d1\u9001\u5df2\u6253\u5305\u540e\u7684\u6d88\u606f\u7684\u5b57\u8282:\u65e0\u5b57\u8282\u8f93\u5165");
            return false;
        }
    }

    private byte[] getInData() throws IOException {
        try {
            int len = this.in.readInt();
            logger.info((Object)("\u8f93\u5165\u7684\u6d41\u91cc\u8bfb\u53d6\u7684len==" + len));
            if (this.in != null && len != 0) {
                byte[] data = new byte[len - 4];
                this.in.read(data);
                return data;
            }
            return null;
        }
        catch (NullPointerException ef) {
            logger.error((Object)"\u5728\u672c\u8fde\u7ed3\u4e0a\u63a5\u53d7\u5b57\u8282\u6d88\u606f:\u65e0\u6d41\u8f93\u5165");
            return null;
        }
        catch (EOFException eof) {
            logger.error((Object)("\u5728\u672c\u8fde\u7ed3\u4e0a\u63a5\u53d7\u5b57\u8282\u6d88\u606f:" + eof.getMessage()));
            return null;
        }
    }
}

